/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import java.util.Arrays;
import org.apache.pulsar.tests.ExtendedNettyLeakDetector;
import org.apache.pulsar.tests.ThreadDumpUtil;
import org.testng.IExecutionListener;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.internal.thread.ThreadTimeoutException;

public class PulsarTestListener
implements ITestListener,
IExecutionListener,
ISuiteListener {
    public void onTestStart(ITestResult result) {
        ExtendedNettyLeakDetector.setInitialHint(String.format("Test: %s.%s", result.getTestClass().getName(), result.getMethod().getMethodName()));
        System.out.format("------- Starting test %s.%s(%s)-------\n", result.getTestClass(), result.getMethod().getMethodName(), Arrays.toString(result.getParameters()));
    }

    public void onTestSuccess(ITestResult result) {
        System.out.format("------- SUCCESS -- %s.%s(%s)-------\n", result.getTestClass(), result.getMethod().getMethodName(), Arrays.toString(result.getParameters()));
        ExtendedNettyLeakDetector.triggerLeakDetection();
    }

    public void onTestFailure(ITestResult result) {
        if (!(result.getThrowable() instanceof SkipException)) {
            System.out.format("!!!!!!!!! FAILURE-- %s.%s(%s)-------\n", result.getTestClass(), result.getMethod().getMethodName(), Arrays.toString(result.getParameters()));
            if (result.getThrowable() != null) {
                result.getThrowable().printStackTrace();
                if (result.getThrowable() instanceof ThreadTimeoutException) {
                    System.out.println("====== THREAD DUMPS ======");
                    System.out.println(ThreadDumpUtil.buildThreadDiagnosticString());
                }
            }
        }
        ExtendedNettyLeakDetector.triggerLeakDetection();
    }

    public void onTestSkipped(ITestResult result) {
        if (!(result.getThrowable() instanceof SkipException)) {
            System.out.format("~~~~~~~~~ SKIPPED -- %s.%s(%s)-------\n", result.getTestClass(), result.getMethod().getMethodName(), Arrays.toString(result.getParameters()));
            if (result.getThrowable() != null) {
                result.getThrowable().printStackTrace();
                if (result.getThrowable() instanceof ThreadTimeoutException) {
                    System.out.println("====== THREAD DUMPS ======");
                    System.out.println(ThreadDumpUtil.buildThreadDiagnosticString());
                }
            }
        }
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        ExtendedNettyLeakDetector.triggerLeakDetection();
    }

    public void onStart(ITestContext context) {
        ExtendedNettyLeakDetector.setInitialHint("Starting test: " + context.getName());
    }

    public void onFinish(ITestContext context) {
        ExtendedNettyLeakDetector.triggerLeakDetection();
        ExtendedNettyLeakDetector.setInitialHint("Finished test: " + context.getName());
    }

    public void onFinish(ISuite suite) {
        ExtendedNettyLeakDetector.setInitialHint("Finished suite: " + suite.getName());
    }

    public void onExecutionFinish() {
        if (!ExtendedNettyLeakDetector.isEnabled()) {
            return;
        }
        ExtendedNettyLeakDetector.triggerLeakDetection();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        ExtendedNettyLeakDetector.triggerLeakDetection();
    }
}

