/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.testng.IExecutionListener;
import org.testng.ISuite;
import org.testng.ISuiteListener;

public class JacocoDumpListener
implements ISuiteListener,
IExecutionListener {
    private final MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
    private final ObjectName jacocoObjectName;
    private final JacocoProxy jacocoProxy;
    private final boolean enabled;
    private long lastDumpTime;
    private static final long DUMP_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(120L);

    public JacocoDumpListener() {
        try {
            this.jacocoObjectName = new ObjectName("org.jacoco:type=Runtime");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        this.enabled = this.checkEnabled();
        this.jacocoProxy = this.enabled ? MBeanServerInvocationHandler.newProxyInstance(this.platformMBeanServer, this.jacocoObjectName, JacocoProxy.class, false) : null;
        this.lastDumpTime = System.currentTimeMillis();
    }

    private boolean checkEnabled() {
        try {
            this.platformMBeanServer.getObjectInstance(this.jacocoObjectName);
        }
        catch (InstanceNotFoundException e) {
            return false;
        }
        return true;
    }

    public void onFinish(ISuite suite) {
        if (this.enabled && System.currentTimeMillis() - this.lastDumpTime > DUMP_INTERVAL_MILLIS) {
            this.triggerJacocoDump();
        }
    }

    public void onExecutionFinish() {
        if (this.enabled) {
            this.triggerJacocoDump();
        }
    }

    private void triggerJacocoDump() {
        System.out.println("Dumping Jacoco coverage data to file...");
        long start = System.currentTimeMillis();
        this.jacocoProxy.dump(true);
        this.lastDumpTime = System.currentTimeMillis();
        System.out.println("Completed in " + (this.lastDumpTime - start) + "ms.");
    }

    public static interface JacocoProxy {
        public void dump(boolean var1);
    }
}

