/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ResourceLeakDetector;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedNettyLeakDetector<T>
extends ResourceLeakDetector<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtendedNettyLeakDetector.class);
    public static final String NETTY_CUSTOM_LEAK_DETECTOR_SYSTEM_PROPERTY_NAME = "io.netty.customResourceLeakDetector";
    private static final File DUMP_DIR = new File(System.getenv().getOrDefault("NETTY_LEAK_DUMP_DIR", System.getProperty("java.io.tmpdir")));
    public static final String EXIT_JVM_ON_LEAK_SYSTEM_PROPERTY_NAME = ExtendedNettyLeakDetector.class.getName() + ".exitJvmOnLeak";
    public static final String SLEEP_AFTER_GC_AND_FINALIZATION_MILLIS_SYSTEM_PROPERTY_NAME = ExtendedNettyLeakDetector.class.getName() + ".sleepAfterGCAndFinalizationMillis";
    private static final long SLEEP_AFTER_GC_AND_FINALIZATION_MILLIS = Long.parseLong(System.getProperty(SLEEP_AFTER_GC_AND_FINALIZATION_MILLIS_SYSTEM_PROPERTY_NAME, "10"));
    private static boolean exitJvmOnLeak;
    private static final boolean DEFAULT_EXIT_JVM_ON_LEAK;
    public static final String EXIT_JVM_DELAY_MILLIS_SYSTEM_PROPERTY_NAME;
    private static final long EXIT_JVM_DELAY_MILLIS;
    public static final String USE_SHUTDOWN_HOOK_SYSTEM_PROPERTY_NAME;
    private static boolean useShutdownHook;
    private boolean exitThreadStarted;
    private static volatile String initialHint;

    public static void triggerLeakDetection() {
        if (!ExtendedNettyLeakDetector.isEnabled()) {
            return;
        }
        System.gc();
        System.runFinalization();
        try {
            Thread.sleep(SLEEP_AFTER_GC_AND_FINALIZATION_MILLIS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        ExtendedNettyLeakDetector.triggerLeakReporting();
    }

    private static void triggerLeakReporting() {
        ByteBuf buffer = ByteBufAllocator.DEFAULT.directBuffer();
        ByteBuf retainedSlice = buffer.retainedSlice();
        retainedSlice.release();
        buffer.release();
    }

    public ExtendedNettyLeakDetector(Class<?> resourceType, int samplingInterval, long maxActive) {
        super(resourceType, samplingInterval, maxActive);
    }

    public ExtendedNettyLeakDetector(Class<?> resourceType, int samplingInterval) {
        super(resourceType, samplingInterval);
    }

    public ExtendedNettyLeakDetector(String resourceType, int samplingInterval, long maxActive) {
        super(resourceType, samplingInterval, maxActive);
    }

    public static void setInitialHint(String initialHint) {
        ExtendedNettyLeakDetector.initialHint = initialHint;
    }

    protected boolean needReport() {
        return true;
    }

    protected Object getInitialHint(String resourceType) {
        String currentInitialHint = initialHint;
        if (currentInitialHint != null) {
            return currentInitialHint;
        }
        return super.getInitialHint(resourceType);
    }

    protected void reportTracedLeak(String resourceType, String records) {
        super.reportTracedLeak(resourceType, records);
        this.dumpToFile(resourceType, records);
        this.maybeExitJVM();
    }

    protected void reportUntracedLeak(String resourceType) {
        super.reportUntracedLeak(resourceType);
        this.dumpToFile(resourceType, null);
        this.maybeExitJVM();
    }

    private synchronized void maybeExitJVM() {
        if (this.exitThreadStarted) {
            return;
        }
        if (exitJvmOnLeak) {
            new Thread(() -> {
                LOG.error("Exiting JVM due to Netty resource leak. Check logs for more details. Dumped to {}", (Object)DUMP_DIR.getAbsolutePath());
                System.err.println("Exiting JVM due to Netty resource leak. Check logs for more details. Dumped to " + DUMP_DIR.getAbsolutePath());
                ExtendedNettyLeakDetector.triggerLeakDetectionBeforeJVMExit();
                LogManager.shutdown();
                System.err.flush();
                System.out.flush();
                Runtime.getRuntime().halt(1);
            }).start();
            this.exitThreadStarted = true;
        }
    }

    private void dumpToFile(String resourceType, String records) {
        try {
            if (!DUMP_DIR.exists()) {
                DUMP_DIR.mkdirs();
            }
            String datetimePart = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss.SSS").format(ZonedDateTime.now());
            File nettyLeakDumpFile = new File(DUMP_DIR, "netty_leak_" + datetimePart + ".txt");
            String linePrefix = exitJvmOnLeak ? "::error::" : "::warning::";
            try (PrintWriter out = new PrintWriter(new FileWriter(nettyLeakDumpFile, true));){
                out.print(linePrefix);
                if (records != null) {
                    out.println("Traced leak detected " + resourceType);
                    out.println(records);
                } else {
                    out.println("Untraced leak detected " + resourceType);
                }
                out.println();
                out.flush();
            }
        }
        catch (IOException e) {
            LOG.error("Cannot write thread leak dump", (Throwable)e);
        }
    }

    public static boolean isExtendedNettyLeakDetectorEnabled() {
        return ExtendedNettyLeakDetector.class.getName().equals(System.getProperty(NETTY_CUSTOM_LEAK_DETECTOR_SYSTEM_PROPERTY_NAME));
    }

    public static void disableExitJVMOnLeak() {
        exitJvmOnLeak = false;
    }

    public static void restoreExitJVMOnLeak() {
        ExtendedNettyLeakDetector.triggerLeakDetection();
        exitJvmOnLeak = DEFAULT_EXIT_JVM_ON_LEAK;
    }

    private static void maybeRegisterShutdownHook() {
        if (!exitJvmOnLeak && useShutdownHook) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (!ExtendedNettyLeakDetector.isEnabled()) {
                    return;
                }
                ExtendedNettyLeakDetector.triggerLeakDetectionBeforeJVMExit();
            }, ExtendedNettyLeakDetector.class.getSimpleName() + "ShutdownHook"));
        }
    }

    private static void triggerLeakDetectionBeforeJVMExit() {
        ExtendedNettyLeakDetector.triggerLeakDetection();
        try {
            Thread.sleep(EXIT_JVM_DELAY_MILLIS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ExtendedNettyLeakDetector.triggerLeakDetection();
    }

    static {
        DEFAULT_EXIT_JVM_ON_LEAK = exitJvmOnLeak = Boolean.valueOf(System.getProperty(EXIT_JVM_ON_LEAK_SYSTEM_PROPERTY_NAME, "false")).booleanValue();
        EXIT_JVM_DELAY_MILLIS_SYSTEM_PROPERTY_NAME = ExtendedNettyLeakDetector.class.getName() + ".exitJvmDelayMillis";
        EXIT_JVM_DELAY_MILLIS = Long.parseLong(System.getProperty(EXIT_JVM_DELAY_MILLIS_SYSTEM_PROPERTY_NAME, "1000"));
        USE_SHUTDOWN_HOOK_SYSTEM_PROPERTY_NAME = ExtendedNettyLeakDetector.class.getName() + ".useShutdownHook";
        useShutdownHook = Boolean.valueOf(System.getProperty(USE_SHUTDOWN_HOOK_SYSTEM_PROPERTY_NAME, "false"));
        ExtendedNettyLeakDetector.maybeRegisterShutdownHook();
    }
}

