/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import java.lang.management.ManagementFactory;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.management.JMException;
import javax.management.ObjectName;

public class HeapHistogramUtil {
    public static String buildHeapHistogram() {
        StringBuilder dump = new StringBuilder();
        dump.append(String.format("Timestamp: %s", DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.now())));
        dump.append("\n\n");
        try {
            dump.append(HeapHistogramUtil.callDiagnosticCommand("gcHeapInfo", new String[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        dump.append("\n");
        try {
            dump.append(HeapHistogramUtil.callDiagnosticCommand("gcClassHistogram", new String[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return dump.toString();
    }

    static String callDiagnosticCommand(String operationName, String ... args) throws JMException {
        return (String)ManagementFactory.getPlatformMBeanServer().invoke(new ObjectName("com.sun.management:type=DiagnosticCommand"), operationName, new Object[]{args}, new String[]{String[].class.getName()});
    }
}

