/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.apache.pulsar.buildtools.shaded.org.apache.commons.lang3.ClassUtils;
import org.apache.pulsar.buildtools.shaded.org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.pulsar.buildtools.shaded.org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.pulsar.tests.ThreadLocalStateCleaner;
import org.mockito.internal.stubbing.InvocationContainerImpl;
import org.mockito.internal.util.MockUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MockitoThreadLocalStateCleaner {
    public static final MockitoThreadLocalStateCleaner INSTANCE = new MockitoThreadLocalStateCleaner();
    private static final Logger LOG = LoggerFactory.getLogger(MockitoThreadLocalStateCleaner.class);
    private static final ThreadLocal<?> MOCKING_PROGRESS_PROVIDER = MockitoThreadLocalStateCleaner.lookupMockingProgressThreadLocal();

    private static ThreadLocal<?> lookupMockingProgressThreadLocal() {
        try {
            Field profilerField = FieldUtils.getDeclaredField(ClassUtils.getClass("org.mockito.internal.progress.ThreadSafeMockingProgress"), "MOCKING_PROGRESS_PROVIDER", true);
            if (profilerField != null) {
                return (ThreadLocal)profilerField.get(null);
            }
            LOG.warn("Cannot find Mockito's ThreadSafeMockingProgress.MOCKING_PROGRESS_PROVIDER field. This might be due to using an unsupported Mockito version.");
            return null;
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            LOG.warn("Cannot find Mockito's ThreadSafeMockingProgress.MOCKING_PROGRESS_PROVIDER thread local", (Throwable)e);
            return null;
        }
    }

    private MockitoThreadLocalStateCleaner() {
    }

    public void cleanup() {
        ThreadLocalStateCleaner.INSTANCE.cleanupThreadLocal(MOCKING_PROGRESS_PROVIDER, (thread, mockingProgress) -> {
            try {
                Object mock;
                LOG.info("Removing {} instance from thread {}", (Object)mockingProgress.getClass().getName(), thread);
                LOG.info("Calling MockingProgress.validateState() method on instance (toString={})", mockingProgress);
                MethodUtils.invokeMethod(mockingProgress, "validateState");
                Object ongoingStubbing = MethodUtils.invokeMethod(mockingProgress, "pullOngoingStubbing");
                if (ongoingStubbing != null && (mock = MethodUtils.invokeMethod(ongoingStubbing, "getMock")) != null && MockUtil.isMock((Object)mock)) {
                    LOG.warn("Invalid usage of Mockito detected on thread {}. There is ongoing stubbing on mock of class={} instance={}", new Object[]{thread, mock.getClass().getName(), mock});
                    try {
                        MockitoThreadLocalStateCleaner.clearInvocations(thread, mock);
                    }
                    catch (Exception e) {
                        LOG.warn("Clearing invocations failed", (Throwable)e);
                    }
                }
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                LOG.debug("Cannot call validateState on existing Mockito ProgressProvider");
            }
            catch (InvocationTargetException e) {
                LOG.warn("Invalid usage of Mockito detected on thread {}", thread, (Object)e.getCause());
            }
            catch (Exception e) {
                LOG.warn("Removing {} instance from thread {} failed", new Object[]{mockingProgress.getClass().getName(), thread, e});
            }
        });
    }

    private static void clearInvocations(Thread thread, Object mock) {
        InvocationContainerImpl invocationContainer = MockUtil.getInvocationContainer((Object)mock);
        if (invocationContainer.hasInvocationForPotentialStubbing()) {
            LOG.warn("Mock contains registered invocations that should be cleared. thread {} class={} instance={}", new Object[]{thread, mock.getClass().getName(), mock});
            invocationContainer.clearInvocations();
        }
    }

    public boolean isEnabled() {
        return MOCKING_PROGRESS_PROVIDER != null;
    }
}

