/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.pluto.maven.AbstractPlutoMojo;
import org.apache.pluto.maven.InstallationDependency;
import org.apache.pluto.util.install.InstallationConfig;
import org.apache.pluto.util.install.PortalInstaller;
import org.apache.pluto.util.install.PortalInstallerFactory;
import org.apache.pluto.util.install.ServerConfig;

public abstract class AbstractManagementMojo
extends AbstractPlutoMojo {
    protected String domain = "PlutoDomain";
    protected String server = "PlutoServer";
    protected String host = "localhost";
    protected int port;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    protected ArtifactRepository artifactRepository;
    protected List<ArtifactRepository> remoteRepositories;
    protected String portalContext;
    protected String version;

    protected AbstractManagementMojo() {
    }

    protected List<File> getSharedDependencies() throws ArtifactNotFoundException, ArtifactResolutionException {
        return this.getDependencies(InstallationDependency.getSharedDependencies());
    }

    protected List<File> getEndorsedDependencies() throws ArtifactNotFoundException, ArtifactResolutionException {
        return this.getDependencies(InstallationDependency.getEndorsedDependencies());
    }

    private List<File> getDependencies(Collection<InstallationDependency> artifacts) throws ArtifactNotFoundException, ArtifactResolutionException {
        ArrayList<File> list = new ArrayList<File>();
        for (InstallationDependency dep : artifacts) {
            Artifact artifact = this.artifactFactory.createArtifactWithClassifier(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getType(), null);
            this.artifactResolver.resolve(artifact, this.remoteRepositories, this.artifactRepository);
            if (artifact.getFile() == null) {
                this.getLog().warn((CharSequence)("Unable to find file for artifact: " + artifact.getArtifactId()));
            }
            list.add(artifact.getFile());
        }
        return list;
    }

    protected ServerConfig getServerConfig() {
        ServerConfig config = new ServerConfig();
        config.setDomain(this.domain);
        config.setHost(this.host);
        config.setPort(this.port);
        config.setServer(this.server);
        return config;
    }

    protected PortalInstaller getHandler() {
        return PortalInstallerFactory.getAppServerHandler((File)this.installationDirectory);
    }

    protected InstallationConfig createInstallationConfig() throws ArtifactNotFoundException, ArtifactResolutionException {
        InstallationConfig config = new InstallationConfig();
        config.setInstallationDirectory(this.installationDirectory);
        config.setPortalContextPath(this.portalContext);
        config.setPortalApplication(this.getPortalApplication());
        config.setPortletApplications(this.getPortletApplications());
        config.setEndorsedDependencies(this.getEndorsedDependencies());
        config.setSharedDependencies(this.getSharedDependencies());
        config.setServerConfig(this.getServerConfig());
        return config;
    }

    private File getPortalApplication() throws ArtifactNotFoundException, ArtifactResolutionException {
        InstallationDependency dep = InstallationDependency.PORTAL;
        Artifact artifact = this.artifactFactory.createBuildArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getType());
        this.artifactResolver.resolve(artifact, this.remoteRepositories, this.artifactRepository);
        return artifact.getFile();
    }

    private Map<String, File> getPortletApplications() throws ArtifactNotFoundException, ArtifactResolutionException {
        HashMap<String, File> files = new HashMap<String, File>();
        InstallationDependency dep = InstallationDependency.TESTSUITE;
        Artifact artifact = this.artifactFactory.createBuildArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getType());
        this.artifactResolver.resolve(artifact, this.remoteRepositories, this.artifactRepository);
        files.put("testsuite", artifact.getFile());
        return files;
    }

    @Override
    protected void doValidate() throws Exception {
        if (this.installationDirectory == null || !this.installationDirectory.exists()) {
            throw new MojoExecutionException("A valid installation directory must be provided in order to install pluto.");
        }
    }
}

