/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.pluto.container.util.NamespacedNamesEnumeration;

public class ServletPortletSessionProxy
implements InvocationHandler {
    HttpSession servletSession;
    String portletWindowId;
    String portletScopeAttrNamePrefix;

    public static HttpSession createProxy(HttpServletRequest request, String portletWindowId) {
        HttpSession servletSession = request.getSession();
        HashSet interfaces = new HashSet();
        interfaces.add(HttpSession.class);
        Class<?> current = servletSession.getClass();
        while (current != null) {
            try {
                Class<?>[] currentInterfaces = current.getInterfaces();
                for (int i = 0; i < currentInterfaces.length; ++i) {
                    interfaces.add(currentInterfaces[i]);
                }
                current = current.getSuperclass();
            }
            catch (Exception e) {
                current = null;
            }
        }
        Object proxy = Proxy.newProxyInstance(servletSession.getClass().getClassLoader(), interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)new ServletPortletSessionProxy(request.getSession(), portletWindowId));
        return (HttpSession)proxy;
    }

    private ServletPortletSessionProxy(HttpSession servletSession, String portletWindowId) {
        this.servletSession = servletSession;
        this.portletWindowId = portletWindowId;
        this.portletScopeAttrNamePrefix = "javax.portlet.p." + this.portletWindowId + '?';
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        String[] retval = null;
        if (("getAttribute".equals(m.getName()) || "getValue".equals(m.getName())) && args.length == 1 && args[0] instanceof String) {
            retval = this.servletSession.getAttribute(this.portletScopeAttrNamePrefix + (String)args[0]);
        } else if (("setAttribute".equals(m.getName()) || "putValue".equals(m.getName())) && args.length == 2 && args[0] instanceof String) {
            this.servletSession.setAttribute(this.portletScopeAttrNamePrefix + (String)args[0], args[1]);
        } else if (("removeAttribute".equals(m.getName()) || "removeValue".equals(m.getName())) && args.length == 1 && args[0] instanceof String) {
            this.servletSession.removeAttribute(this.portletScopeAttrNamePrefix + (String)args[0]);
        } else if ("getAttributeNames".equals(m.getName()) && args == null) {
            retval = new NamespacedNamesEnumeration(this.servletSession.getAttributeNames(), this.portletScopeAttrNamePrefix);
        } else if ("getValueNames".equals(m.getName()) && args == null) {
            ArrayList list = new ArrayList();
            NamespacedNamesEnumeration e = new NamespacedNamesEnumeration(this.servletSession.getAttributeNames(), this.portletScopeAttrNamePrefix);
            while (e.hasMoreElements()) {
                list.add(e.nextElement());
            }
            retval = list.toArray(new String[list.size()]);
        } else {
            try {
                retval = m.invoke((Object)this.servletSession, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
        return retval;
    }
}

