/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.CacheControl;
import javax.portlet.MimeResponse;
import javax.portlet.PortletURL;
import javax.portlet.ResourceURL;
import org.apache.pluto.container.PortletMimeResponseContext;
import org.apache.pluto.container.PortletResponseContext;
import org.apache.pluto.container.PortletURLProvider;
import org.apache.pluto.container.impl.PortletResponseImpl;
import org.apache.pluto.container.impl.PortletURLImpl;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.Supports;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeResponseImpl
extends PortletResponseImpl
implements MimeResponse {
    private ArrayList<String> responseContentTypes;
    private boolean usingWriter;
    private boolean usingStream;
    private boolean committed;
    private String contentType;
    private PortletMimeResponseContext responseContext;

    public MimeResponseImpl(PortletMimeResponseContext responseContext) {
        super((PortletResponseContext)responseContext);
        this.responseContext = responseContext;
        PortletDefinition portletDefinition = this.getPortletWindow().getPortletDefinition();
        this.getCacheControl().setExpirationTime(portletDefinition.getExpirationCache());
        this.getCacheControl().setPublicScope("portlet.public-scope".equals(portletDefinition.getCacheScope()));
    }

    protected List<String> getResponseContentTypes() {
        if (this.responseContentTypes == null) {
            this.responseContentTypes = new ArrayList();
            PortletDefinition dd = this.getPortletWindow().getPortletDefinition();
            for (Supports sup : dd.getSupports()) {
                this.responseContentTypes.add(sup.getMimeType());
            }
            if (this.responseContentTypes.isEmpty()) {
                this.responseContentTypes.add("text/html");
            }
        }
        return this.responseContentTypes;
    }

    public PortletURL createActionURL() {
        return new PortletURLImpl(this.responseContext, PortletURLProvider.TYPE.ACTION);
    }

    public PortletURL createRenderURL() {
        return new PortletURLImpl(this.responseContext, PortletURLProvider.TYPE.RENDER);
    }

    public ResourceURL createResourceURL() {
        return new PortletURLImpl(this.responseContext, PortletURLProvider.TYPE.RESOURCE);
    }

    public void flushBuffer() throws IOException {
        this.committed = true;
        this.responseContext.flushBuffer();
    }

    public int getBufferSize() {
        return this.responseContext.getBufferSize();
    }

    public CacheControl getCacheControl() {
        return this.responseContext.getCacheControl();
    }

    public String getCharacterEncoding() {
        return this.responseContext.getCharacterEncoding();
    }

    public String getContentType() {
        return this.contentType;
    }

    public Locale getLocale() {
        return this.responseContext.getLocale();
    }

    public OutputStream getPortletOutputStream() throws IllegalStateException, IOException {
        if (this.usingWriter) {
            throw new IllegalStateException("getPortletOutputStream can't be used after getWriter was invoked.");
        }
        if (this.getContentType() == null) {
            this.setContentType(this.getResponseContentTypes().get(0));
        }
        this.usingStream = true;
        return this.responseContext.getOutputStream();
    }

    public PrintWriter getWriter() throws IllegalStateException, IOException {
        if (this.usingStream) {
            throw new IllegalStateException("getWriter can't be used after getOutputStream was invoked.");
        }
        if (this.getContentType() == null) {
            this.setContentType(this.getResponseContentTypes().get(0));
        }
        this.usingWriter = true;
        return this.responseContext.getWriter();
    }

    public boolean isCommitted() {
        return this.committed ? true : this.responseContext.isCommitted();
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response is already committed");
        }
        this.responseContext.reset();
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response is already committed");
        }
        this.responseContext.resetBuffer();
    }

    public void setBufferSize(int size) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response is already committed");
        }
        this.responseContext.setBufferSize(size);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        this.responseContext.setContentType(contentType);
    }

    @Override
    public void setProperty(String name, String value) {
        if ("portlet.use-cached-content".equals(name)) {
            this.getCacheControl().setUseCachedContent(value != null);
        } else if ("portlet.expiration-cache".equals(name)) {
            int expirationTime;
            try {
                expirationTime = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                expirationTime = 0;
            }
            this.getCacheControl().setExpirationTime(expirationTime);
        } else if ("portlet.ETag".equals(name)) {
            this.getCacheControl().setETag(value);
        } else if ("portlet.cache-scope".equals(name)) {
            this.getCacheControl().setPublicScope("portlet.public-scope".equals(value));
        } else {
            super.setProperty(name, value);
        }
    }
}

