/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.pluto.container.PortletAppDescriptorService;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.impl.PortletAppType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PortletAppDescriptorServiceImpl
implements PortletAppDescriptorService {
    private static final String NAMESPACE_PREFIX = "xp";
    private DocumentBuilderFactory domFactory;

    public static Locale convertStringToLocale(String lang) {
        if (lang == null) {
            return null;
        }
        String country = "";
        String variant = "";
        String[] localeArray = lang.split("[-|_]");
        for (int i = 0; i < localeArray.length; ++i) {
            if (i == 0) {
                lang = localeArray[i];
                continue;
            }
            if (i == 1) {
                country = localeArray[i];
                continue;
            }
            if (i != 2) continue;
            variant = localeArray[i];
        }
        return new Locale(lang, country, variant);
    }

    public PortletApplicationDefinition createPortletApplicationDefinition() {
        return new PortletAppType();
    }

    public PortletApplicationDefinition read(String name, String contextPath, InputStream in) throws IOException {
        JAXBElement app = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"org.apache.pluto.container.om.portlet10.impl:org.apache.pluto.container.om.portlet.impl", (ClassLoader)PortletAppDescriptorServiceImpl.class.getClassLoader());
            Unmarshaller u = jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            app = (JAXBElement)u.unmarshal(in);
        }
        catch (JAXBException jaxbEx) {
            IOException ioe = new IOException(jaxbEx.getMessage());
            ioe.initCause(jaxbEx);
            throw ioe;
        }
        catch (Exception me) {
            IOException ioe = new IOException(me.getLocalizedMessage());
            ioe.initCause(me);
            throw new IOException(me.getLocalizedMessage());
        }
        PortletApplicationDefinition pad = null;
        pad = app.getValue() instanceof org.apache.pluto.container.om.portlet10.impl.PortletAppType ? ((org.apache.pluto.container.om.portlet10.impl.PortletAppType)app.getValue()).upgrade() : (PortletApplicationDefinition)app.getValue();
        pad.setName(name);
        pad.setContextPath(contextPath);
        return pad;
    }

    public void mergeWebDescriptor(PortletApplicationDefinition pa, InputStream webDescriptor) throws Exception {
        String prefix;
        if (this.domFactory == null) {
            this.domFactory = DocumentBuilderFactory.newInstance();
            this.domFactory.setNamespaceAware(true);
        }
        DocumentBuilder builder = this.domFactory.newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId.equals("http://java.sun.com/dtd/web-app_2_3.dtd")) {
                    return new InputSource(this.getClass().getResourceAsStream("web-app_2_3.dtd"));
                }
                return null;
            }
        });
        Document document = builder.parse(webDescriptor);
        Element root = document.getDocumentElement();
        String namespace = root.getNamespaceURI();
        XPath xpath = XPathFactory.newInstance().newXPath();
        if (namespace != null && namespace.length() > 0) {
            prefix = "xp:";
            xpath.setNamespaceContext(new XPathNamespaceContext(NAMESPACE_PREFIX, namespace));
        } else {
            prefix = "";
            xpath.setNamespaceContext(new XPathNamespaceContext(""));
        }
        NodeList nodes = (NodeList)xpath.evaluate("/" + prefix + "web-app/" + prefix + "locale-encoding-mapping-list/" + prefix + "locale-encoding-mapping", document, XPathConstants.NODESET);
        if (nodes != null) {
            int nsize = nodes.getLength();
            for (int i = 0; i < nsize; ++i) {
                String encoding;
                String locale;
                Element element = (Element)nodes.item(i);
                NodeList children = element.getElementsByTagName("locale");
                if (children == null || children.getLength() == 0 || (locale = children.item(0).getTextContent().trim()).length() <= 0 || (children = element.getElementsByTagName("encoding")) == null || children.getLength() == 0 || (encoding = children.item(0).getTextContent().trim()).length() <= 0) continue;
                pa.getLocaleEncodingMappings().put(PortletAppDescriptorServiceImpl.convertStringToLocale(locale), encoding);
            }
        }
    }

    public void write(PortletApplicationDefinition app, OutputStream out) throws IOException {
        try {
            JAXBContext jc = null;
            Object src = null;
            if ("1.0".equals(app.getVersion())) {
                jc = JAXBContext.newInstance((String)"org.apache.pluto.container.om.portlet10.impl");
                src = new org.apache.pluto.container.om.portlet10.impl.PortletAppType(app);
            } else {
                jc = JAXBContext.newInstance((String)"org.apache.pluto.container.om.portlet.impl");
                src = app;
            }
            Marshaller m = jc.createMarshaller();
            m.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal(src, out);
        }
        catch (JAXBException jaxbEx) {
            jaxbEx.printStackTrace();
            throw new IOException(jaxbEx.getMessage());
        }
        catch (Exception me) {
            throw new IOException(me.getLocalizedMessage());
        }
    }

    private static class XPathNamespaceContext
    implements NamespaceContext {
        private String namespaceURI;
        private String prefix;

        public XPathNamespaceContext(String prefix) {
            this(prefix, "http://www.w3.org/XML/1998/namespace");
        }

        public XPathNamespaceContext(String prefix, String namespaceURI) {
            this.prefix = prefix;
            this.namespaceURI = namespaceURI;
        }

        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new NullPointerException("Null prefix");
            }
            if (this.prefix.equals(prefix)) {
                return this.namespaceURI;
            }
            if ("xml".equals(prefix)) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            return "";
        }

        public String getPrefix(String namespaceURI) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String namespaceURI) {
            throw new UnsupportedOperationException();
        }
    }
}

