/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.pluto.container.PageResourceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class HeaderData {
    private static final Logger LOG = LoggerFactory.getLogger(HeaderData.class);
    private static final boolean isDebug = LOG.isDebugEnabled();
    private static final boolean isTrace = LOG.isTraceEnabled();
    private DocumentBuilder docBuilder = null;
    private Document doc = null;
    private Element root = null;
    private static final String ROOT_ELEMENT = "rootElement";
    private static final String ROOT_ELEMENT_START = "<rootElement>";
    private static final String ROOT_ELEMENT_END = "</rootElement>";
    private static final String ROOT_ELEMENT_REGEX = "(?:\\s*)</{0,1}rootElement>(?:\\s*)";
    private static final Set<String> allowedTags = new HashSet<String>(Arrays.asList("META", "LINK", "STYLE", "SCRIPT", "NOSCRIPT"));
    private List<Cookie> cookies = new ArrayList<Cookie>();
    private Map<String, List<String>> httpHeaders = new HashMap<String, List<String>>();
    private int bufferSize = 128;
    private ByteArrayOutputStream baoStream = null;
    private StringWriter sWriter = null;
    private PrintWriter pWriter = null;
    private Map<PageResourceId, String> resources = new LinkedHashMap<PageResourceId, String>();

    private void setupDoc() throws ParserConfigurationException {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        dbfac.setExpandEntityReferences(true);
        this.docBuilder = dbfac.newDocumentBuilder();
        this.docBuilder.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException arg0) throws SAXException {
            }

            @Override
            public void fatalError(SAXParseException arg0) throws SAXException {
            }

            @Override
            public void error(SAXParseException arg0) throws SAXException {
            }
        });
        this.doc = this.docBuilder.newDocument();
        this.root = this.doc.createElement(ROOT_ELEMENT);
        this.doc.appendChild(this.root);
    }

    private String getTags(Document doc) {
        String tags = "";
        if (doc != null) {
            DOMSource src = new DOMSource(doc);
            StringWriter sw = new StringWriter();
            StreamResult res = new StreamResult(sw);
            try {
                Transformer trans = TransformerFactory.newInstance().newTransformer();
                trans.setOutputProperty("indent", "yes");
                trans.setOutputProperty("omit-xml-declaration", "yes");
                trans.setOutputProperty("method", "html");
                trans.transform(src, res);
                tags = sw.toString().replaceAll(ROOT_ELEMENT_REGEX, "");
            }
            catch (Exception e) {
                StringBuilder txt = new StringBuilder();
                txt.append("Error converting tags to string. Exception: ");
                txt.append(e.toString());
                LOG.warn(txt.toString());
            }
        }
        if (isTrace) {
            StringBuilder sb = new StringBuilder();
            sb.append("returning tags: ");
            sb.append(tags.length() > 0 ? "\n" + tags : "");
            LOG.trace(sb.toString());
        }
        return tags;
    }

    private String getTagsFromText(String src, boolean chkArgs) {
        StringBuilder txt = new StringBuilder(128);
        if (src != null) {
            StringBuffer sb = new StringBuffer(128);
            sb.append(ROOT_ELEMENT_START);
            src = src.replaceAll("(<(?:meta|link).*?[^/])>", "$1/>");
            src = src.replaceAll("</(?:meta|link)>", "");
            Pattern pat = Pattern.compile("(?s)(?<=<(script|style))(.*?)(?=</(script|style))");
            Matcher mat = pat.matcher(src);
            while (mat.find()) {
                String group = mat.group();
                int indexOfBeginCDATA = group.indexOf("<![CDATA[");
                String replacedGroup = "";
                if (indexOfBeginCDATA < 0) {
                    replacedGroup = group.replaceAll("&", "&amp;").replaceAll("<", "&lt;");
                }
                while (indexOfBeginCDATA > -1) {
                    String beforeCDATA = group.substring(0, indexOfBeginCDATA);
                    replacedGroup = replacedGroup + beforeCDATA.replaceAll("&", "&amp;").replaceAll("<", "&lt;");
                    int indexOfEndCDATA = group.indexOf("]]>") + "]]>".length();
                    replacedGroup = replacedGroup + group.substring(indexOfBeginCDATA, indexOfEndCDATA);
                    String afterCDATA = group.substring(indexOfEndCDATA);
                    indexOfBeginCDATA = afterCDATA.indexOf("<![CDATA[");
                    if (indexOfBeginCDATA > 0) {
                        indexOfBeginCDATA += indexOfEndCDATA;
                        continue;
                    }
                    replacedGroup = replacedGroup + afterCDATA.replaceAll("&", "&amp;").replaceAll("<", "&lt;");
                }
                mat.appendReplacement(sb, Matcher.quoteReplacement(replacedGroup));
            }
            mat.appendTail(sb);
            sb.append(ROOT_ELEMENT_END);
            StringReader sr = new StringReader(sb.toString());
            InputSource is = new InputSource(sr);
            try {
                if (this.docBuilder == null) {
                    this.setupDoc();
                }
                Document adoc = this.docBuilder.parse(is);
                Element aroot = adoc.getDocumentElement();
                NodeList nodes = aroot.getChildNodes();
                for (int ii = 0; ii < nodes.getLength(); ++ii) {
                    String name;
                    StringBuilder err;
                    String text;
                    Node node = nodes.item(ii);
                    short type = node.getNodeType();
                    if (type != 8 && type != 3 && type != 1) {
                        StringBuilder err2 = new StringBuilder(128);
                        err2.append("Invalid node type: ");
                        err2.append(type);
                        err2.append(", node name: ").append(node.getNodeName());
                        LOG.warn(err2.toString());
                        if (chkArgs) {
                            throw new IllegalArgumentException(err2.toString());
                        }
                        aroot.removeChild(node);
                        continue;
                    }
                    if (type == 3 && !(text = ((Text)node).getWholeText()).matches("^\\s*$")) {
                        err = new StringBuilder(128);
                        err.append("Invalid text node: ");
                        err.append(node.getNodeValue());
                        err.append(", node name: ").append(node.getNodeName());
                        txt.append(", allowed tags: ").append(allowedTags.toString());
                        LOG.warn(err.toString());
                        if (chkArgs) {
                            throw new IllegalArgumentException(err.toString());
                        }
                        aroot.removeChild(node);
                        continue;
                    }
                    if (type != 1 || allowedTags.contains((name = ((Element)node).getTagName()).toUpperCase())) continue;
                    err = new StringBuilder(128);
                    err.append("Invalid tag: ");
                    err.append(name);
                    err.append(", node name: ").append(node.getNodeName());
                    LOG.warn(err.toString());
                    if (chkArgs) {
                        throw new IllegalArgumentException(err.toString());
                    }
                    aroot.removeChild(node);
                }
                txt.append(this.getTags(adoc));
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (SAXParseException e) {
                StringBuilder err = new StringBuilder();
                err.append("Problem parsing tag data: ").append(src.replaceAll("&", "&amp;").replaceAll("<", "&lt;"));
                throw new IllegalArgumentException(err.toString(), e);
            }
            catch (Exception e) {
                StringBuilder err = new StringBuilder();
                err.append("Problem parsing tag data: ");
                err.append("\n   Original data: ").append(src);
                err.append("\n   Modified buffer: ").append(sb.toString());
                err.append("\nStack trace:\n");
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.flush();
                err.append(sw.toString());
                LOG.warn(err.toString());
            }
        }
        return txt.toString();
    }

    public void resetBuffer() {
        if (isDebug) {
            LOG.debug("Resetting buffer.");
        }
        if (this.baoStream != null) {
            this.baoStream.reset();
        }
        if (this.pWriter != null) {
            this.sWriter = new StringWriter(this.bufferSize);
            this.pWriter = new PrintWriter(this.sWriter);
        }
    }

    public void reset() {
        this.resetBuffer();
        this.httpHeaders.clear();
        this.cookies.clear();
    }

    public PrintWriter getWriter() {
        if (this.baoStream != null) {
            throw new IllegalStateException("getWriter may not be called after getPortletOutputStream.");
        }
        if (this.pWriter == null) {
            this.sWriter = new StringWriter(this.bufferSize);
            this.pWriter = new PrintWriter(this.sWriter);
        }
        if (isDebug) {
            LOG.debug("returning writer.");
        }
        return this.pWriter;
    }

    public ByteArrayOutputStream getBaoStream() {
        if (this.sWriter != null) {
            throw new IllegalStateException("getPortletOutputStream may not be called after getWriter.");
        }
        if (this.baoStream == null) {
            this.baoStream = new ByteArrayOutputStream(this.bufferSize);
        }
        if (isDebug) {
            LOG.debug("returning output stream.");
        }
        return this.baoStream;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getHeadSectionMarkup() {
        StringBuilder txt = new StringBuilder(128);
        txt.append(this.getTags(this.doc));
        String src = null;
        if (this.sWriter != null) {
            src = this.sWriter.toString();
        } else if (this.baoStream != null) {
            src = this.baoStream.toString();
        }
        txt.append("\n<!-- markup from portlet output stream -->");
        txt.append(this.getTagsFromText(src, false));
        return txt.toString();
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public Map<String, List<String>> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void addHttpHeader(String name, String value) {
        if (!this.httpHeaders.containsKey(name)) {
            ArrayList vals = new ArrayList(2);
            this.httpHeaders.put(name, vals);
        }
        this.httpHeaders.get(name).add(value);
    }

    public void setHttpHeader(String name, String value) {
        ArrayList<String> vals = new ArrayList<String>(Arrays.asList(value));
        this.httpHeaders.put(name, vals);
    }

    public void addHeaderTag(Element e) {
        String tag = e.getTagName().toUpperCase();
        if (allowedTags.contains(tag)) {
            if (this.root != null) {
                this.root.appendChild(e);
            }
        } else {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Ignoring element with disallowed tag name: ").append(tag);
            txt.append(", allowed tags: ").append(allowedTags.toString());
            LOG.warn(txt.toString());
        }
    }

    public Element createElement(String tagName) {
        try {
            if (this.doc == null) {
                this.setupDoc();
            }
            return this.doc.createElement(tagName);
        }
        catch (ParserConfigurationException e) {
            throw new DOMException(0, "Initialization failure");
        }
    }

    public void addDependency(String name, String scope, String version) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Dependency name field may not be null or empty.");
        }
        PageResourceId pres = new PageResourceId(name, scope, version);
        this.resources.put(pres, null);
    }

    public void addDependency(String name, String scope, String version, String markup) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Dependency name field may not be null or empty.");
        }
        if (markup == null || markup.length() == 0) {
            throw new IllegalArgumentException("Markup may not be null or empty when adding dependency.");
        }
        PageResourceId pres = new PageResourceId(name, scope, version);
        String resource = this.getTagsFromText(markup, true);
        this.resources.put(pres, resource);
    }

    public Map<PageResourceId, String> getDynamicResources() {
        return this.resources;
    }
}

