/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.Event;
import javax.portlet.MutableRenderParameters;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.xml.namespace.QName;
import org.apache.pluto.container.PortletStateAwareResponseContext;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.impl.PortletResponseImpl;
import org.apache.pluto.container.util.ArgumentUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StateAwareResponseImpl
extends PortletResponseImpl
implements StateAwareResponse {
    private final Logger LOGGER = LoggerFactory.getLogger(StateAwareResponseImpl.class);
    private final boolean isDebug = this.LOGGER.isDebugEnabled();
    protected PortletStateAwareResponseContext responseContext;
    private final String windowId;

    public StateAwareResponseImpl(PortletStateAwareResponseContext responseContext) {
        super(responseContext);
        this.responseContext = responseContext;
        this.windowId = responseContext.getPortletWindow().getId().getStringId();
    }

    protected abstract void checkSetStateChanged();

    protected boolean isWindowStateAllowed(WindowState state) {
        Enumeration supportedStates = this.getPortalContext().getSupportedWindowStates();
        while (supportedStates.hasMoreElements()) {
            if (!((WindowState)supportedStates.nextElement()).equals((Object)state)) continue;
            return true;
        }
        return false;
    }

    public PortletMode getPortletMode() {
        return this.responseContext.getPortletMode();
    }

    public Map<String, String[]> getRenderParameterMap() {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        Set<String> names = this.responseContext.getPrivateParameterNames(this.windowId);
        for (String name : names) {
            String[] vals = this.responseContext.getParameterValues(this.windowId, name);
            parameters.put(name, vals);
        }
        return parameters;
    }

    public WindowState getWindowState() {
        return this.responseContext.getWindowState();
    }

    public void removePublicRenderParameter(String name) {
        ArgumentUtility.validateNotEmpty("name", name);
        this.checkSetStateChanged();
        this.responseContext.removePublicRenderParameter(this.windowId, name);
    }

    public void setEvent(QName qname, Serializable value) {
        Event event;
        ArgumentUtility.validateNotNull("qname", qname);
        if (this.LOGGER.isTraceEnabled()) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("QName: ").append(qname.toString());
            txt.append(", value class: ").append(value == null ? "null" : value.getClass().getCanonicalName());
            this.LOGGER.debug(txt.toString());
        }
        if ((event = this.responseContext.getEventProvider().createEvent(qname, value)) != null) {
            this.responseContext.getEvents().add(event);
        }
    }

    public void setEvent(String name, Serializable value) {
        PortletWindow window = this.getPortletWindow();
        String defaultNamespace = window.getPortletDefinition().getApplication().getDefaultNamespace();
        QName qname = new QName(defaultNamespace, name);
        this.setEvent(qname, value);
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        ArgumentUtility.validateNotNull("portletMode", portletMode);
        if (!this.isPortletModeAllowed(portletMode)) {
            throw new PortletModeException("Can't set this PortletMode", portletMode);
        }
        this.checkSetStateChanged();
        this.responseContext.setPortletMode(portletMode);
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        ArgumentUtility.validateNotNull("windowState", windowState);
        if (!this.isWindowStateAllowed(windowState)) {
            throw new WindowStateException("Can't set this WindowState", windowState);
        }
        this.checkSetStateChanged();
        this.responseContext.setWindowState(windowState);
    }

    public void setRenderParameters(Map<String, String[]> parameters) {
        ArgumentUtility.validateNotNull("parameters", parameters);
        for (String key : parameters.keySet()) {
            String[] vals = parameters.get(key);
            if (key != null && vals != null) continue;
            throw new IllegalArgumentException("parameters map contains a null key or values array");
        }
        this.checkSetStateChanged();
        Set<String> currNames = this.responseContext.getPrivateParameterNames(this.windowId);
        currNames.removeAll(parameters.keySet());
        for (String name : currNames) {
            this.responseContext.removeParameter(this.windowId, name);
        }
        for (String key : parameters.keySet()) {
            this.responseContext.setParameter(this.windowId, key, parameters.get(key));
        }
    }

    public void setRenderParameter(String key, String value) {
        ArgumentUtility.validateNotEmpty("key", key);
        this.checkSetStateChanged();
        if (value == null) {
            this.responseContext.removeParameter(this.windowId, key);
        } else {
            String[] values = new String[]{value};
            this.responseContext.setParameter(this.windowId, key, values);
        }
    }

    public void setRenderParameter(String key, String ... values) {
        ArgumentUtility.validateNotEmpty("key", key);
        this.checkSetStateChanged();
        if (values == null) {
            this.responseContext.removeParameter(this.windowId, key);
        } else {
            this.responseContext.setParameter(this.windowId, key, (String[])values.clone());
        }
    }

    public MutableRenderParameters getRenderParameters() {
        this.checkSetStateChanged();
        return this.responseContext.getRenderParameters(this.windowId);
    }
}

