/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.processor;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.portlet.annotations.RenderStateScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletStateScopedConfig
implements Serializable {
    private static final long serialVersionUID = -5333145344722804837L;
    private final Logger LOG = LoggerFactory.getLogger(PortletStateScopedConfig.class);
    private final boolean isTrace = this.LOG.isTraceEnabled();
    private final List<String> sortedAnnotatedClassNames = new ArrayList<String>();
    private static final String RP_PREFIX = "\ufe34";
    private final Map<Contextual<?>, PSSDescription> context2Anno = new HashMap();
    private final Map<Class<?>, PSSDescription> class2Anno = new HashMap();

    public void addAnnotation(Class<?> beanClass, RenderStateScoped anno) {
        PSSDescription desc = new PSSDescription();
        desc.pssAnno = anno;
        this.class2Anno.put(beanClass, desc);
    }

    public void activate(BeanManager bm) {
        for (Class<?> c : this.class2Anno.keySet()) {
            this.sortedAnnotatedClassNames.add(c.getCanonicalName());
        }
        Collections.sort(this.sortedAnnotatedClassNames);
        for (Class<?> c : this.class2Anno.keySet()) {
            PSSDescription desc = this.class2Anno.get(c);
            if (desc.pssAnno.paramName().length() > 0) {
                desc.paramName = desc.pssAnno.paramName();
                continue;
            }
            desc.paramName = RP_PREFIX + this.sortedAnnotatedClassNames.indexOf(c.getCanonicalName());
        }
        for (Class<?> cls : this.class2Anno.keySet()) {
            Set beans = bm.getBeans(cls, new Annotation[0]);
            Bean bean = bm.resolve(beans);
            assert (bean != null);
            this.context2Anno.put((Contextual<?>)bean, this.class2Anno.get(cls));
        }
        if (this.isTrace) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("PortletStateScopedBeanHolder configuration.");
            txt.append(" Annotated Beans: ");
            txt.append(this.getConfigAsString());
            this.LOG.debug(txt.toString());
        }
    }

    public Set<Class<?>> getBeanClasses() {
        return this.class2Anno.keySet();
    }

    public String getConfigAsString() {
        StringBuilder txt = new StringBuilder(128);
        for (Class<?> c : this.class2Anno.keySet()) {
            txt.append("\n\tClass: ").append(c.getCanonicalName());
            PSSDescription desc = this.class2Anno.get(c);
            txt.append(", Param name: ").append(desc.paramName);
        }
        return txt.toString();
    }

    public String getParamName(Class<?> beanClass) {
        String name = null;
        for (Contextual<?> b : this.context2Anno.keySet()) {
            Bean bean;
            if (!(b instanceof Bean) || !beanClass.isAssignableFrom((bean = (Bean)b).getBeanClass())) continue;
            name = this.context2Anno.get(b).paramName;
            break;
        }
        return name;
    }

    public String getParamName(Bean<?> bean) {
        PSSDescription desc = this.context2Anno.get(bean);
        assert (desc != null);
        assert (desc.paramName.length() > 0);
        return desc.paramName;
    }

    private class PSSDescription
    implements Serializable {
        private static final long serialVersionUID = 4089751663717085089L;
        RenderStateScoped pssAnno;
        String paramName;

        private PSSDescription() {
        }
    }
}

