/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.ant;

import java.io.File;
import org.apache.pluto.util.UtilityException;
import org.apache.pluto.util.assemble.Assembler;
import org.apache.pluto.util.assemble.AssemblerConfig;
import org.apache.pluto.util.assemble.AssemblerFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class AssembleTask
extends Task {
    private File portletxml;
    private File webxml;
    private File destfile;
    private File webapp;

    public File getPortletxml() {
        if (this.webapp != null) {
            return new File(this.webapp, "WEB-INF/portlet.xml");
        }
        return this.portletxml;
    }

    public void setPortletxml(File portletxml) {
        this.portletxml = portletxml;
    }

    public File getWebxml() {
        if (this.webapp != null) {
            return new File(this.webapp, "WEB-INF/web.xml");
        }
        return this.webxml;
    }

    public void setWebxml(File webxml) {
        this.webxml = webxml;
    }

    public File getDestfile() {
        if (this.destfile != null) {
            return this.destfile;
        }
        return this.getWebxml();
    }

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public File getWebapp() {
        return this.webapp;
    }

    public void setWebapp(File webapp) {
        this.webapp = webapp;
    }

    public void execute() throws BuildException {
        this.validateArgs();
        try {
            AssemblerConfig config = new AssemblerConfig();
            config.setPortletDescriptor(this.getPortletxml());
            config.setWebappDescriptor(this.getWebxml());
            config.setDestination(this.getDestfile());
            Assembler assembler = AssemblerFactory.getFactory().createAssemblerAnt(config);
            assembler.assemble(config);
        }
        catch (UtilityException ue) {
            throw new BuildException((Throwable)ue);
        }
    }

    private void validateArgs() throws BuildException {
        if (this.webapp != null) {
            if (!this.webapp.exists()) {
                throw new BuildException("webapp " + this.webapp.getAbsolutePath() + " does not exist");
            }
            return;
        }
        if (this.portletxml == null || !this.portletxml.exists()) {
            throw new BuildException("portletxml " + this.portletxml + " does not exist");
        }
        if (this.webxml == null || !this.webxml.exists()) {
            throw new BuildException("webxml " + this.webxml + " does not exist");
        }
    }
}

