/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.statistics.impl;

import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.statistics.AggregateStatistics;
import org.apache.jetspeed.statistics.InvalidCriteriaException;
import org.apache.jetspeed.statistics.PortalStatistics;
import org.apache.jetspeed.statistics.StatisticsQueryCriteria;
import org.apache.jetspeed.statistics.UserStats;
import org.apache.jetspeed.statistics.impl.AggregateStatisticsImpl;
import org.apache.jetspeed.statistics.impl.BatchedPageStatistics;
import org.apache.jetspeed.statistics.impl.BatchedPortletStatistics;
import org.apache.jetspeed.statistics.impl.BatchedStatistics;
import org.apache.jetspeed.statistics.impl.BatchedUserStatistics;
import org.apache.jetspeed.statistics.impl.LogRecord;
import org.apache.jetspeed.statistics.impl.PageLogRecord;
import org.apache.jetspeed.statistics.impl.PortletLogRecord;
import org.apache.jetspeed.statistics.impl.StatisticsQueryCriteriaImpl;
import org.apache.jetspeed.statistics.impl.UserLogRecord;
import org.apache.jetspeed.statistics.impl.UserStatsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalStatisticsImpl
implements PortalStatistics {
    protected static final Logger logger = LoggerFactory.getLogger(PortalStatisticsImpl.class);
    protected BatchedStatistics portletBatch;
    protected BatchedStatistics pageBatch;
    protected BatchedStatistics userBatch;
    protected static final String portletLogFormat = "{0} {1} {2} [{3}] \"{4} {5} {6}\" {7} {8}";
    protected static final String pageLogFormat = "{0} {1} {2} [{3}] \"{4} {5}\" {6} {7}";
    protected static final String logoutLogFormat = "{0} {1} {2} [{3}] \"{4}\" {5} {6}";
    protected static final int STATUS_LOGGED_IN = 1;
    protected static final int STATUS_LOGGED_OUT = 2;
    protected boolean logToCLF = true;
    protected boolean logToDatabase = true;
    protected int maxRecordToFlush_Portlet = 30;
    protected int maxRecordToFlush_User = 30;
    protected int maxRecordToFlush_Page = 30;
    protected long maxTimeMsToFlush_Portlet = 10000L;
    protected long maxTimeMsToFlush_User = 10000L;
    protected long maxTimeMsToFlush_Page = 10000L;
    protected DataSource ds;
    protected int currentUserCount = 0;
    protected Map currentUsers;
    protected SimpleDateFormat formatter = null;
    private boolean loggingDisabled;

    public PortalStatisticsImpl(boolean logToCLF, boolean logToDatabase, int maxRecordToFlush_Portal, int maxRecordToFlush_User, int maxRecordToFlush_Page, long maxTimeMsToFlush_Portal, long maxTimeMsToFlush_User, long maxTimeMsToFlush_Page, DataSource dataSource) {
        this.logToCLF = logToCLF;
        this.logToDatabase = logToDatabase;
        this.loggingDisabled = !logToCLF && !logToDatabase;
        this.maxRecordToFlush_Portlet = maxRecordToFlush_Portal;
        this.maxRecordToFlush_User = maxRecordToFlush_User;
        this.maxRecordToFlush_Page = maxRecordToFlush_Page;
        this.maxTimeMsToFlush_Portlet = maxTimeMsToFlush_Portal;
        this.maxTimeMsToFlush_User = maxTimeMsToFlush_User;
        this.maxTimeMsToFlush_Page = maxTimeMsToFlush_Page;
        this.ds = dataSource;
        this.currentUsers = Collections.synchronizedMap(new TreeMap());
    }

    public void springInit() throws NamingException {
        this.formatter = new SimpleDateFormat("dd/MM/yyyy:hh:mm:ss z");
        this.currentUserCount = 0;
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    public void logPortletAccess(RequestContext request, String portletName, String statusCode, long msElapsedTime) {
        if (this.loggingDisabled) {
            return;
        }
        try {
            ContentPage cp;
            HttpServletRequest req = request.getRequest();
            Principal principal = req.getUserPrincipal();
            String userName = principal != null ? principal.getName() : "guest";
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            PortletLogRecord record = new PortletLogRecord();
            record.setPortletName(portletName);
            record.setUserName(userName);
            if (req.getRemoteAddr() != null) {
                record.setIpAddress(req.getRemoteAddr());
            }
            if ((cp = request.getPage()) != null && cp.getPath() != null) {
                record.setPagePath(cp.getPath());
            }
            record.setStatus(Integer.parseInt(statusCode));
            record.setTimeStamp(timestamp);
            record.setMsElapsedTime(msElapsedTime);
            if (this.logToCLF) {
                this.saveAccessToCLF(record);
            }
            if (this.logToDatabase) {
                this.storeAccessToStats(record);
            }
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeAccessToStats(LogRecord record) {
        PortalStatisticsImpl portalStatisticsImpl;
        if (record instanceof PortletLogRecord) {
            if (this.portletBatch == null) {
                portalStatisticsImpl = this;
                synchronized (portalStatisticsImpl) {
                    if (this.portletBatch == null) {
                        this.portletBatch = new BatchedPortletStatistics(this.ds, this.maxRecordToFlush_Portlet, this.maxTimeMsToFlush_Portlet, "portletLogBatcher");
                        this.portletBatch.startThread();
                    }
                }
            }
            this.portletBatch.addStatistic(record);
        }
        if (record instanceof PageLogRecord) {
            if (this.pageBatch == null) {
                portalStatisticsImpl = this;
                synchronized (portalStatisticsImpl) {
                    if (this.pageBatch == null) {
                        this.pageBatch = new BatchedPageStatistics(this.ds, this.maxRecordToFlush_Page, this.maxTimeMsToFlush_Page, "pageLogBatcher");
                        this.pageBatch.startThread();
                    }
                }
            }
            this.pageBatch.addStatistic(record);
        }
        if (record instanceof UserLogRecord) {
            if (this.userBatch == null) {
                portalStatisticsImpl = this;
                synchronized (portalStatisticsImpl) {
                    if (this.userBatch == null) {
                        this.userBatch = new BatchedUserStatistics(this.ds, this.maxRecordToFlush_User, this.maxTimeMsToFlush_User, "userLogBatcher");
                        this.userBatch.startThread();
                    }
                }
            }
            this.userBatch.addStatistic(record);
        }
    }

    protected void saveAccessToCLF(LogRecord record) {
        Object[] args1;
        LogRecord rec;
        Object[] args = new Object[]{""};
        String logMessage = "";
        if (record instanceof PortletLogRecord) {
            rec = (PortletLogRecord)record;
            args1 = new Object[]{rec.getIpAddress(), "-", rec.getUserName(), rec.getTimeStamp(), rec.getLogType(), this.formatter.format(rec.getTimeStamp()), ((PortletLogRecord)rec).getPortletName(), new Integer(rec.getStatus()).toString(), new Long(rec.getMsElapsedTime())};
            args = args1;
            logMessage = MessageFormat.format(portletLogFormat, args).toString();
        }
        if (record instanceof PageLogRecord) {
            rec = (PageLogRecord)record;
            args1 = new Object[]{rec.getIpAddress(), "-", rec.getUserName(), rec.getTimeStamp(), rec.getLogType(), this.formatter.format(rec.getTimeStamp()), new Integer(rec.getStatus()).toString(), new Long(rec.getMsElapsedTime())};
            args = args1;
            logMessage = MessageFormat.format(pageLogFormat, args).toString();
        }
        if (record instanceof UserLogRecord) {
            rec = (UserLogRecord)record;
            args1 = new Object[]{rec.getIpAddress(), "-", rec.getUserName(), rec.getTimeStamp(), rec.getLogType(), this.formatter.format(rec.getTimeStamp()), new Integer(rec.getStatus()).toString(), new Long(rec.getMsElapsedTime())};
            args = args1;
            logMessage = MessageFormat.format(logoutLogFormat, args).toString();
        }
        logger.info(logMessage);
    }

    public void logPageAccess(RequestContext request, String statusCode, long msElapsedTime) {
        if (this.loggingDisabled) {
            return;
        }
        try {
            HttpServletRequest req = request.getRequest();
            Principal principal = req.getUserPrincipal();
            String userName = principal != null ? principal.getName() : "guest";
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            PageLogRecord record = new PageLogRecord();
            record.setUserName(userName);
            record.setIpAddress(req.getRemoteAddr());
            ContentPage cp = request.getPage();
            if (cp != null && cp.getPath() != null) {
                record.setPagePath(cp.getPath());
            }
            record.setStatus(Integer.parseInt(statusCode));
            record.setTimeStamp(timestamp);
            record.setMsElapsedTime(msElapsedTime);
            if (this.logToCLF) {
                this.saveAccessToCLF(record);
            }
            if (this.logToDatabase) {
                this.storeAccessToStats(record);
            }
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logUserLogout(String ipAddress, String userName, long msSessionLength) {
        if (this.loggingDisabled) {
            return;
        }
        try {
            if (userName == null) {
                userName = "guest";
            }
            if (!"guest".equals(userName)) {
                if (ipAddress == null) {
                    ipAddress = "";
                }
                Map map = this.currentUsers;
                synchronized (map) {
                    UserStats userStats = null;
                    Map users = (Map)this.currentUsers.get(userName);
                    if (users != null && users.size() > 0) {
                        userStats = (UserStats)users.get(ipAddress);
                    }
                    if (userStats != null) {
                        --this.currentUserCount;
                        userStats.setNumberOfSession(userStats.getNumberOfSessions() - 1);
                        if (userStats.getNumberOfSessions() <= 0) {
                            users.remove(ipAddress);
                            this.currentUsers.put(userName, users);
                        }
                    }
                }
            }
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            UserLogRecord record = new UserLogRecord();
            record.setUserName(userName);
            record.setIpAddress(ipAddress);
            record.setStatus(2);
            record.setTimeStamp(timestamp);
            record.setMsElapsedTime(msSessionLength);
            if (this.logToCLF) {
                this.saveAccessToCLF(record);
            }
            if (this.logToDatabase) {
                this.storeAccessToStats(record);
            }
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logUserLogin(RequestContext request, long msElapsedLoginTime) {
        if (this.loggingDisabled) {
            return;
        }
        try {
            HttpServletRequest req = request.getRequest();
            Principal principal = req.getUserPrincipal();
            String userName = principal != null ? principal.getName() : "guest";
            String ipAddress = req.getRemoteAddr();
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            UserLogRecord record = new UserLogRecord();
            if (!"guest".equals(userName)) {
                ++this.currentUserCount;
                if (ipAddress == null) {
                    ipAddress = "";
                }
                Map map = this.currentUsers;
                synchronized (map) {
                    UserStats userStats = null;
                    TreeMap<String, UserStats> users = (TreeMap<String, UserStats>)this.currentUsers.get(userName);
                    if (users != null && users.size() > 0) {
                        userStats = (UserStats)users.get(ipAddress);
                    } else {
                        users = new TreeMap<String, UserStats>();
                    }
                    if (userStats == null) {
                        userStats = new UserStatsImpl();
                        userStats.setNumberOfSession(0);
                        userStats.setUsername(userName);
                        userStats.setInetAddressFromIp(ipAddress);
                    }
                    userStats.setNumberOfSession(userStats.getNumberOfSessions() + 1);
                    users.put(ipAddress, userStats);
                    this.currentUsers.put(userName, users);
                }
            }
            record.setUserName(userName);
            record.setIpAddress(ipAddress);
            record.setStatus(1);
            record.setTimeStamp(timestamp);
            record.setMsElapsedTime(msElapsedLoginTime);
            if (this.logToCLF) {
                this.saveAccessToCLF(record);
            }
            if (this.logToDatabase) {
                this.storeAccessToStats(record);
            }
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void springDestroy() {
        Thread thread;
        if (this.portletBatch != null) {
            this.portletBatch.tellThreadToStop();
            thread = this.portletBatch.thread;
            synchronized (thread) {
                this.portletBatch.thread.notify();
            }
        }
        if (this.userBatch != null) {
            this.userBatch.tellThreadToStop();
            thread = this.userBatch.thread;
            synchronized (thread) {
                this.userBatch.thread.notify();
            }
        }
        if (this.pageBatch != null) {
            this.pageBatch.tellThreadToStop();
            thread = this.pageBatch.thread;
            synchronized (thread) {
                this.pageBatch.thread.notify();
            }
        }
        if (this.currentUserCount != 0 && logger.isDebugEnabled()) {
            logger.debug("destroying while users are logged in");
        }
        boolean done = false;
        while (!done) {
            done = true;
            if (this.portletBatch != null && !this.portletBatch.isDone()) {
                done = false;
            }
            if (this.userBatch != null && !this.userBatch.isDone()) {
                done = false;
            }
            if (this.pageBatch != null && !this.pageBatch.isDone()) {
                done = false;
            }
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected Date getStartDateFromPeriod(String period, Date end) {
        GregorianCalendar gcEnd = new GregorianCalendar();
        gcEnd.setTime(end);
        if (period != null) {
            if (period.endsWith("m")) {
                String p = period.substring(0, period.length() - 1);
                int ret = Integer.parseInt(p);
                gcEnd.add(2, ret * -1);
            } else if (period.endsWith("d")) {
                String p = period.substring(0, period.length() - 1);
                int ret = Integer.parseInt(p);
                gcEnd.add(10, ret * 24 * -1);
            } else if (period.endsWith("h")) {
                String p = period.substring(0, period.length() - 1);
                int ret = Integer.parseInt(p);
                gcEnd.add(10, ret * -1);
            } else if (period.equals("all")) {
                gcEnd = new GregorianCalendar();
                gcEnd.set(1968, 7, 15);
            } else {
                int ret = Integer.parseInt(period);
                gcEnd.add(12, ret * -1);
            }
        } else {
            gcEnd = new GregorianCalendar();
            gcEnd.set(1968, 7, 15);
        }
        return gcEnd.getTime();
    }

    public StatisticsQueryCriteria createStatisticsQueryCriteria() {
        return new StatisticsQueryCriteriaImpl();
    }

    public AggregateStatistics getDefaultEmptyAggregateStatistics() {
        return new AggregateStatisticsImpl();
    }

    public AggregateStatistics queryStatistics(StatisticsQueryCriteria criteria) throws InvalidCriteriaException {
        String query2;
        String query1;
        String groupColumn;
        String tableName;
        AggregateStatisticsImpl as = new AggregateStatisticsImpl();
        Date end = new Date();
        Date start = this.getStartDateFromPeriod(criteria.getTimePeriod(), end);
        String queryType = criteria.getQueryType();
        if ("user".equals(queryType)) {
            tableName = "USER_STATISTICS";
            groupColumn = "USER_NAME";
        } else if ("portlet".equals(queryType)) {
            tableName = "PORTLET_STATISTICS";
            groupColumn = "PORTLET";
        } else if ("page".equals(queryType)) {
            tableName = "PAGE_STATISTICS";
            groupColumn = "PAGE";
        } else {
            throw new InvalidCriteriaException(" invalid queryType passed to queryStatistics");
        }
        String orderColumn = "itemcount";
        String ascDesc = "DESC";
        if (!"user".equals(queryType)) {
            query1 = "select count(*) as itemcount , MIN(ELAPSED_TIME) as amin ,AVG(ELAPSED_TIME) as aavg ,MAX(ELAPSED_TIME) as amax from " + tableName + " where time_stamp > ? and time_stamp < ?";
            query2 = "select count(*) as itemcount ," + groupColumn + ", MIN(ELAPSED_TIME) as amin ,AVG(ELAPSED_TIME) as aavg ,MAX(ELAPSED_TIME) as amax " + "from " + tableName + " where time_stamp > ? and time_stamp < ? group by " + groupColumn + "  order by " + orderColumn + " " + ascDesc;
        } else {
            query1 = "select count(*) as itemcount , MIN(ELAPSED_TIME) as amin,AVG(ELAPSED_TIME) as aavg ,MAX(ELAPSED_TIME) as amax from " + tableName + " where time_stamp > ? and time_stamp < ? and status = 2";
            query2 = "select count(*) as itemcount ," + groupColumn + ", MIN(ELAPSED_TIME) as amin ,AVG(ELAPSED_TIME) as aavg ,MAX(ELAPSED_TIME) as amax " + "from " + tableName + " where time_stamp > ? and time_stamp < ? and status = 2 group by " + groupColumn + "  order by " + orderColumn + " " + ascDesc;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.ds.getConnection();
            pstmt = con.prepareStatement(query1);
            pstmt.setTimestamp(1, new Timestamp(start.getTime()));
            pstmt.setTimestamp(2, new Timestamp(end.getTime()));
            rs = pstmt.executeQuery();
            float denominator = 1.0f;
            if ("user".equals(queryType)) {
                denominator = 60000.0f;
            }
            if (rs.next()) {
                as.setHitCount(rs.getInt("itemcount"));
                as.setMinProcessingTime(rs.getFloat("amin") / denominator);
                as.setAvgProcessingTime(rs.getFloat("aavg") / denominator);
                as.setMaxProcessingTime(rs.getFloat("amax") / denominator);
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            pstmt = con.prepareStatement(query2);
            pstmt.setTimestamp(1, new Timestamp(start.getTime()));
            pstmt.setTimestamp(2, new Timestamp(end.getTime()));
            rs = pstmt.executeQuery();
            int rowCount = 0;
            int totalRows = 5;
            String listsizeStr = criteria.getListsize();
            int temp = -1;
            try {
                temp = Integer.parseInt(listsizeStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (temp != -1) {
                totalRows = temp;
            }
            while (rs.next() && rowCount < totalRows) {
                HashMap<String, String> row = new HashMap<String, String>();
                row.put("count", "" + rs.getInt("itemcount"));
                String col = rs.getString(groupColumn);
                int maxColLen = 35;
                if (col != null && col.length() > maxColLen) {
                    col = col.substring(0, maxColLen);
                }
                row.put("groupColumn", col);
                row.put("min", "" + this.floatFormatter(rs.getFloat("amin") / denominator));
                row.put("avg", "" + this.floatFormatter(rs.getFloat("aavg") / denominator));
                row.put("max", "" + this.floatFormatter(rs.getFloat("amax") / denominator));
                as.addRow(row);
                ++rowCount;
            }
        }
        catch (SQLException e) {
            throw new InvalidCriteriaException(e.toString());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ignore) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception ignore) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {
                    logger.error("error releasing the connection", (Throwable)e);
                }
            }
        }
        return as;
    }

    protected String floatFormatter(float f) {
        int f2 = new Float(f).intValue();
        return Integer.toString(f2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getListOfLoggedInUsers() {
        ArrayList list = new ArrayList();
        Map map = this.currentUsers;
        synchronized (map) {
            list.addAll(this.currentUsers.values());
        }
        return list;
    }

    public int getNumberOfLoggedInUsers() {
        return this.currentUserCount;
    }

    public void forceFlush() {
        if (this.pageBatch != null) {
            this.pageBatch.flush();
        }
        if (this.portletBatch != null) {
            this.portletBatch.flush();
        }
        if (this.userBatch != null) {
            this.userBatch.flush();
        }
    }
}

