/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.util.Date;
import org.apache.jetspeed.security.CredentialPasswordEncoder;
import org.apache.jetspeed.security.CredentialPasswordValidator;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.spi.impl.AbstractPasswordCredentialInterceptorImpl;

public class PasswordExpirationInterceptor
extends AbstractPasswordCredentialInterceptorImpl {
    private long maxLifeSpanInMillis;

    public PasswordExpirationInterceptor(int maxLifeSpanInDays) {
        this.maxLifeSpanInMillis = (long)maxLifeSpanInDays * 1000L * 60L * 60L * 24L;
    }

    @Override
    public boolean afterAuthenticated(PasswordCredential credential, boolean authenticated) throws SecurityException {
        long currentTime;
        long expirationTime;
        boolean update = false;
        if (!credential.isExpired() && (expirationTime = credential.getExpirationDate().getTime()) <= (currentTime = new Date().getTime())) {
            credential.setExpired(true);
            update = true;
        }
        return update;
    }

    @Override
    public boolean afterLoad(String userName, PasswordCredential credential, CredentialPasswordEncoder encoder, CredentialPasswordValidator validator) throws SecurityException {
        boolean update = false;
        if (credential.getExpirationDate() == null) {
            credential.setExpirationDate(new java.sql.Date(new Date().getTime() + this.maxLifeSpanInMillis));
            update = true;
        }
        return update;
    }

    @Override
    public void beforeCreate(PasswordCredential credential) throws SecurityException {
        this.setExpiration(credential);
    }

    public void beforeSetPassword(PasswordCredential credential, String password) throws SecurityException {
        this.setExpiration(credential);
    }

    protected void setExpiration(PasswordCredential credential) {
        java.sql.Date nextExpirationDate = new java.sql.Date(new Date().getTime() + this.maxLifeSpanInMillis);
        if (credential.getExpirationDate() == null || credential.getExpirationDate().before(nextExpirationDate)) {
            credential.setExpirationDate(nextExpirationDate);
        }
        credential.setExpired(false);
    }
}

