/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import javax.naming.AuthenticationException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.security.CredentialPasswordEncoder;
import org.apache.jetspeed.security.InvalidPasswordException;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.spi.AlgorithmUpgradeCredentialPasswordEncoder;
import org.apache.jetspeed.security.spi.JetspeedSecuritySynchronizer;
import org.apache.jetspeed.security.spi.UserPasswordCredentialAccessManager;
import org.apache.jetspeed.security.spi.UserPasswordCredentialManager;
import org.apache.jetspeed.security.spi.UserPasswordCredentialPolicyManager;
import org.apache.jetspeed.security.spi.UserPasswordCredentialStorageManager;
import org.apache.jetspeed.security.spi.impl.PasswordCredentialImpl;
import org.apache.jetspeed.security.spi.impl.SynchronizationStateAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.HardcodedFilter;
import org.springframework.ldap.pool.factory.PoolingContextSource;
import org.springframework.ldap.support.LdapUtils;

public class LdapUserPasswordCredentialManagerImpl
implements UserPasswordCredentialManager {
    private static final long serialVersionUID = 1131764631931510796L;
    static final Logger log = LoggerFactory.getLogger(UserPasswordCredentialManager.class);
    private UserPasswordCredentialStorageManager upcsm;
    private UserPasswordCredentialAccessManager upcam;
    private UserPasswordCredentialPolicyManager upcpm;
    private UserManager um;
    private JetspeedSecuritySynchronizer synchronizer;
    private PoolingContextSource poolingContextsource;
    private String userEntryPrefix;
    private DistinguishedName userSearchPath;
    private SearchControls searchControls;
    private Filter userFilter;
    private CredentialPasswordEncoder cpe;
    private boolean persistCredentials;
    private boolean changePasswordByUser;

    public LdapUserPasswordCredentialManagerImpl(UserPasswordCredentialStorageManager upcsm, UserPasswordCredentialAccessManager upcam, UserPasswordCredentialPolicyManager upcpm, CredentialPasswordEncoder cpe, PoolingContextSource poolingContextSource, String userSearchBase, String userFilter, String userEntryPrefix, String searchScope) {
        this.upcsm = upcsm;
        this.upcam = upcam;
        this.upcpm = upcpm;
        this.cpe = cpe != null && (upcpm == null || upcpm.getCredentialPasswordEncoder() != cpe) ? cpe : null;
        this.poolingContextsource = poolingContextSource;
        this.userEntryPrefix = userEntryPrefix;
        this.userSearchPath = new DistinguishedName(userSearchBase);
        if (!StringUtils.isEmpty((String)userFilter)) {
            this.userFilter = new HardcodedFilter(userFilter);
        }
        this.searchControls = new SearchControls();
        this.searchControls.setReturningAttributes(new String[0]);
        this.searchControls.setReturningObjFlag(false);
        this.searchControls.setSearchScope(Integer.parseInt(searchScope));
    }

    protected String getUserDn(String userName) throws SecurityException {
        String string;
        DirContext ctx = null;
        try {
            EqualsFilter filter = new EqualsFilter(this.userEntryPrefix, userName);
            if (this.userFilter != null) {
                filter = new AndFilter().and(this.userFilter).and((Filter)filter);
            }
            ctx = this.poolingContextsource.getReadOnlyContext();
            NamingEnumeration<SearchResult> results = ctx.search((Name)this.userSearchPath, filter.encode(), this.searchControls);
            String dn = null;
            if (null != results && results.hasMore()) {
                SearchResult result = results.next();
                dn = result.getNameInNamespace();
            }
            if (dn == null) {
                throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("user", (Object)userName));
            }
            string = dn;
        }
        catch (NamingException nex) {
            try {
                throw new SecurityException(SecurityException.UNEXPECTED.create((Object)this.getClass().getName(), (Object)"authenticateUser", (Object)nex.getMessage()), (Throwable)nex);
            }
            catch (Throwable throwable) {
                LdapUtils.closeContext(ctx);
                throw throwable;
            }
        }
        LdapUtils.closeContext((DirContext)ctx);
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void authenticateUser(String userName, String dn, String password) throws SecurityException {
        DirContext ctx = null;
        try {
            ctx = this.poolingContextsource.getContextSource().getContext(dn, password);
            ctx.close();
            ctx = null;
        }
        catch (AuthenticationException aex) {
            try {
                if (aex.getMessage() == null) throw new SecurityException((Throwable)aex);
                if (!aex.getMessage().equalsIgnoreCase("[LDAP: error code 49 - Invalid Credentials]")) throw new SecurityException((Throwable)aex);
                throw new InvalidPasswordException();
                catch (NamingException nex) {
                    throw new SecurityException(SecurityException.UNEXPECTED.create((Object)this.getClass().getName(), (Object)"authenticateUser", (Object)nex.getMessage()), (Throwable)nex);
                }
            }
            catch (Throwable throwable) {
                LdapUtils.closeContext(ctx);
                throw throwable;
            }
        }
        LdapUtils.closeContext((DirContext)ctx);
    }

    protected void setPassword(String userName, String dn, String oldPassword, String newPassword, boolean changePasswordByUserOnly) throws SecurityException {
        DirContext ctx = null;
        try {
            ctx = changePasswordByUserOnly ? this.poolingContextsource.getContextSource().getContext(dn, oldPassword) : this.poolingContextsource.getReadWriteContext();
            DistinguishedName name = new DistinguishedName(dn);
            name.removeFirst((Name)new DistinguishedName(ctx.getNameInNamespace()));
            BasicAttribute namingAttr = new BasicAttribute("userPassword", newPassword);
            ModificationItem[] items = new ModificationItem[]{new ModificationItem(2, namingAttr)};
            ctx.modifyAttributes((Name)name, items);
        }
        catch (NamingException nex) {
            try {
                throw new SecurityException(SecurityException.UNEXPECTED.create((Object)this.getClass().getName(), (Object)"setPassword", (Object)nex.getMessage()), (Throwable)nex);
            }
            catch (Throwable throwable) {
                LdapUtils.closeContext(ctx);
                throw throwable;
            }
        }
        LdapUtils.closeContext((DirContext)ctx);
    }

    public void setUserManager(UserManager um) {
        this.um = um;
    }

    public void setJetspeedSecuritySynchronizer(JetspeedSecuritySynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public void setPersistCredentials(boolean persistCredentials) {
        this.persistCredentials = persistCredentials;
    }

    public boolean isPersistCredentials() {
        return this.persistCredentials;
    }

    public void setChangePasswordByUser(boolean changePasswordByUser) {
        this.changePasswordByUser = changePasswordByUser;
    }

    public boolean isChangePasswordByUser() {
        return this.changePasswordByUser;
    }

    @Override
    public PasswordCredential getPasswordCredential(User user) throws SecurityException {
        if (this.isPersistCredentials()) {
            PasswordCredential credential = this.upcsm.getPasswordCredential(user);
            if (!credential.isNew() && this.upcpm != null && this.upcpm.onLoad(credential, user.getName())) {
                this.upcsm.storePasswordCredential(credential);
            }
            return credential;
        }
        PasswordCredentialImpl credential = new PasswordCredentialImpl();
        credential.setUser(user);
        return credential;
    }

    @Override
    public void storePasswordCredential(PasswordCredential credential) throws SecurityException {
        String userDn = null;
        boolean authenticated = false;
        boolean isNewPasswordSet = credential.isNewPasswordSet();
        String newPassword = credential.getNewPassword();
        String oldPassword = credential.getOldPassword();
        String password = credential.getPassword();
        boolean encoded = credential.isEncoded();
        if (SynchronizationStateAccess.isSynchronizing()) {
            authenticated = true;
        } else if (isNewPasswordSet) {
            userDn = this.getUserDn(credential.getUserName());
            if (oldPassword != null) {
                this.authenticateUser(credential.getUserName(), userDn, oldPassword);
                authenticated = true;
            }
        }
        if (this.upcpm != null) {
            this.upcpm.onStore(credential, authenticated);
        }
        if (this.isPersistCredentials()) {
            this.upcsm.storePasswordCredential(credential);
        }
        if (isNewPasswordSet && !SynchronizationStateAccess.isSynchronizing()) {
            String ldapPassword = credential.getPassword();
            if (this.cpe != null && newPassword != null || !encoded) {
                ldapPassword = this.cpe.encode(credential.getUserName(), newPassword != null ? newPassword : password);
            }
            this.setPassword(credential.getUserName(), userDn, oldPassword, ldapPassword, oldPassword != null ? this.changePasswordByUser : false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PasswordCredential getAuthenticatedPasswordCredential(String userName, String password) throws SecurityException {
        PasswordCredentialImpl credential;
        if (!SynchronizationStateAccess.isSynchronizing()) {
            this.authenticateUser(userName, this.getUserDn(userName), password);
            if (this.synchronizer != null) {
                this.synchronizer.synchronizeUserPrincipal(userName);
            }
        }
        PasswordCredentialImpl passwordCredentialImpl = credential = this.isPersistCredentials() ? this.upcam.getPasswordCredential(userName) : new PasswordCredentialImpl();
        if (credential == null) {
            credential = new PasswordCredentialImpl();
            if (this.um == null) {
                log.error("New User PasswordCredential cannot be persisted: requires UserManager to be set!!!");
            } else {
                credential.setUser(this.um.getUser(userName));
            }
        }
        boolean setPassword = false;
        if (this.isPersistCredentials() && (!credential.isNew() || credential.getUser() != null)) {
            if (credential.isNew()) {
                setPassword = true;
            } else {
                String encodedPassword = password;
                if (this.upcpm != null && this.upcpm.getCredentialPasswordEncoder() != null && credential.isEncoded()) {
                    CredentialPasswordEncoder encoder = this.upcpm.getCredentialPasswordEncoder();
                    encodedPassword = this.upcpm.getCredentialPasswordEncoder() instanceof AlgorithmUpgradeCredentialPasswordEncoder ? ((AlgorithmUpgradeCredentialPasswordEncoder)encoder).encode(credential, password) : encoder.encode(userName, password);
                }
                if (!credential.getPassword().equals(encodedPassword)) {
                    setPassword = true;
                }
            }
            if (setPassword) {
                credential.setPassword(null, password);
                boolean synchronizing = SynchronizationStateAccess.isSynchronizing();
                try {
                    SynchronizationStateAccess.setSynchronizing(Boolean.TRUE);
                    this.storePasswordCredential(credential);
                    SynchronizationStateAccess.setSynchronizing(synchronizing ? Boolean.TRUE : Boolean.FALSE);
                }
                catch (Throwable throwable) {
                    SynchronizationStateAccess.setSynchronizing(synchronizing ? Boolean.TRUE : Boolean.FALSE);
                    throw throwable;
                }
            }
            if (this.upcpm != null) {
                if (this.upcpm.onLoad(credential, userName)) {
                    this.upcsm.storePasswordCredential(credential);
                }
                if (credential.isEnabled() && !credential.isExpired()) {
                    if (this.upcpm.authenticate(credential, userName, password, true)) {
                        this.upcsm.storePasswordCredential(credential);
                    }
                    if (!credential.isEnabled() || credential.isExpired()) {
                        throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("user", (Object)userName));
                    }
                    if (credential.getAuthenticationFailures() != 0) {
                        throw new SecurityException(SecurityException.INVALID_PASSWORD);
                    }
                }
            }
        }
        if (credential.getUser() == null) {
            if (!credential.isNew()) {
                try {
                    this.upcam.loadPasswordCredentialUser(credential);
                }
                catch (Exception e) {
                    throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("user", (Object)userName), (Throwable)e);
                }
            } else {
                credential.setUserName(userName);
            }
        }
        return credential;
    }
}

