/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Segment;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.security.JetspeedPrincipalQueryContext;
import org.apache.jetspeed.security.JetspeedPrincipalResultList;
import org.apache.jetspeed.security.impl.PersistentJetspeedPrincipal;
import org.apache.jetspeed.security.spi.JetspeedPrincipalLookupManager;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.accesslayer.RowReader;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JetspeedPrincipalLookupManagerAbstract
implements JetspeedPrincipalLookupManager {
    static final Logger log = LoggerFactory.getLogger(JetspeedPrincipalLookupManagerAbstract.class);
    private static final String PARAM_PLACEHOLDER_PREFIX = "@@paramPlaceHolder";
    private static final String PARAM_PLACEHOLDER_SUFFIX = "@@";
    private static final Pattern PARAM_PLACEHOLDER_PATTERN = Pattern.compile("(@@paramPlaceHolder\\d+@@)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JetspeedPrincipalResultList getPrincipals(JetspeedPrincipalQueryContext queryContext) {
        int numberOfRecords = 0;
        ArrayList<PersistentJetspeedPrincipal> results = new ArrayList<PersistentJetspeedPrincipal>();
        Connection conn = null;
        Statement pstmtForPaging = null;
        ResultSet rsForPaging = null;
        Statement pstmtForCount = null;
        ResultSet rsForCount = null;
        try {
            conn = PersistenceBrokerFactory.defaultPersistenceBroker().serviceConnectionManager().getConnection();
            PreparedStatement[] pstmts = this.createPagingPreparedStatementAndCountPreparedStatement(conn, queryContext);
            pstmtForPaging = pstmts[0];
            pstmtForCount = pstmts[1];
            rsForPaging = pstmtForPaging.executeQuery();
            boolean hasRecords = rsForPaging.next();
            if (hasRecords) {
                this.scrollToOffset(conn, rsForPaging, queryContext.getOffset());
                int i = 0;
                while ((long)i < queryContext.getLength()) {
                    RowReader rr = PersistenceBrokerFactory.defaultPersistenceBroker().getClassDescriptor(PersistentJetspeedPrincipal.class).getRowReader();
                    HashMap row = new HashMap();
                    rr.readObjectArrayFrom(rsForPaging, row);
                    PersistentJetspeedPrincipal p = (PersistentJetspeedPrincipal)rr.readObjectFrom(row);
                    QueryByCriteria query = new QueryByCriteria((Object)p);
                    p = (PersistentJetspeedPrincipal)PersistenceBrokerFactory.defaultPersistenceBroker().getObjectByQuery((Query)query);
                    results.add(p);
                    if (!rsForPaging.next()) break;
                    ++i;
                }
                rsForPaging.close();
                rsForPaging = null;
                pstmtForPaging.close();
                pstmtForPaging = null;
                rsForCount = pstmtForCount.executeQuery();
                while (rsForCount.next()) {
                    numberOfRecords += rsForCount.getInt(1);
                }
                rsForCount.close();
                rsForCount = null;
                pstmtForCount.close();
                pstmtForCount = null;
            }
        }
        catch (SQLException e) {
            log.error("Error reading principal.", (Throwable)e);
        }
        catch (PBFactoryException e) {
            log.error("Error reading principal.", (Throwable)e);
        }
        catch (LookupException e) {
            log.error("Error reading principal.", (Throwable)e);
        }
        finally {
            if (rsForPaging != null) {
                try {
                    rsForPaging.close();
                }
                catch (Exception ignore) {}
            }
            if (pstmtForPaging != null) {
                try {
                    pstmtForPaging.close();
                }
                catch (Exception ignore) {}
            }
            if (rsForCount != null) {
                try {
                    rsForCount.close();
                }
                catch (Exception ignore) {}
            }
            if (pstmtForCount != null) {
                try {
                    pstmtForCount.close();
                }
                catch (Exception ignore) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    log.error("error releasing the connection", (Throwable)e);
                }
            }
        }
        return new JetspeedPrincipalResultList(results, (long)numberOfRecords);
    }

    private String putParamPlaceHolder(Map<String, Object> paramPlaceHolders, Object value) {
        String paramPlaceHolderName = PARAM_PLACEHOLDER_PREFIX + paramPlaceHolders.size() + PARAM_PLACEHOLDER_SUFFIX;
        paramPlaceHolders.put(paramPlaceHolderName, value);
        return paramPlaceHolderName;
    }

    private PreparedStatement[] createPagingPreparedStatementAndCountPreparedStatement(Connection conn, JetspeedPrincipalQueryContext queryContext) throws SQLException {
        String _paramPlaceHolderName = null;
        HashMap<String, Object> _paramPlaceHolders = new HashMap<String, Object>();
        String attributeConstraint = null;
        String fromPart = "SECURITY_PRINCIPAL";
        int cnt = 1;
        if (queryContext.getSecurityAttributes() != null) {
            for (Map.Entry attribute : queryContext.getSecurityAttributes().entrySet()) {
                if (attributeConstraint == null) {
                    _paramPlaceHolderName = this.putParamPlaceHolder(_paramPlaceHolders, attribute.getKey());
                    attributeConstraint = " a" + cnt + ".PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID AND a" + cnt + ".ATTR_NAME = " + _paramPlaceHolderName;
                    _paramPlaceHolderName = this.putParamPlaceHolder(_paramPlaceHolders, this.convertWildcardsForLike((String)attribute.getValue()));
                    attributeConstraint = attributeConstraint + " AND a" + cnt + ".ATTR_VALUE LIKE " + _paramPlaceHolderName;
                } else {
                    _paramPlaceHolderName = this.putParamPlaceHolder(_paramPlaceHolders, attribute.getKey());
                    attributeConstraint = attributeConstraint + " AND a" + cnt + ".PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID AND a" + cnt + ".ATTR_NAME = " + _paramPlaceHolderName;
                    _paramPlaceHolderName = this.putParamPlaceHolder(_paramPlaceHolders, this.convertWildcardsForLike((String)attribute.getValue()));
                    attributeConstraint = attributeConstraint + " AND a" + cnt + ".ATTR_VALUE LIKE " + _paramPlaceHolderName;
                }
                fromPart = fromPart + ", SECURITY_ATTRIBUTE a" + cnt;
                ++cnt;
            }
        }
        String constraint = null;
        if (queryContext.getNameFilter() != null && queryContext.getNameFilter().length() > 0) {
            _paramPlaceHolderName = this.putParamPlaceHolder(_paramPlaceHolders, this.convertWildcardsForLike(queryContext.getNameFilter()));
            constraint = "SECURITY_PRINCIPAL.PRINCIPAL_NAME LIKE " + _paramPlaceHolderName;
        }
        String roleConstraints = null;
        if (queryContext.getAssociatedRoles() != null && queryContext.getAssociatedRoles().size() > 0 && ((String)queryContext.getAssociatedRoles().get(0)).length() > 0) {
            for (String roleName : queryContext.getAssociatedRoles()) {
                _paramPlaceHolderName = this.putParamPlaceHolder(_paramPlaceHolders, this.convertWildcardsForLike(roleName));
                if (roleConstraints == null) {
                    roleConstraints = "r" + cnt + ".ASSOC_NAME = '" + "isMemberOf" + "' AND r" + cnt + ".TO_PRINCIPAL_ID=rp" + cnt + ".PRINCIPAL_ID AND rp" + cnt + ".PRINCIPAL_NAME LIKE " + _paramPlaceHolderName + " AND rp" + cnt + ".PRINCIPAL_TYPE='role' AND r" + cnt + ".FROM_PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID";
                    continue;
                }
                roleConstraints = " AND r" + cnt + ".ASSOC_NAME='" + "isMemberOf" + "' AND r" + cnt + ".TO_PRINCIPAL_ID=rp" + cnt + ".PRINCIPAL_ID AND rp" + cnt + ".PRINCIPAL_NAME LIKE " + _paramPlaceHolderName + " AND rp" + cnt + ".PRINCIPAL_TYPE='role' AND r" + cnt + ".FROM_PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID";
            }
            fromPart = fromPart + ", SECURITY_PRINCIPAL_ASSOC r" + cnt + ", SECURITY_PRINCIPAL rp" + cnt;
            ++cnt;
        }
        String groupConstraints = null;
        if (queryContext.getAssociatedGroups() != null && queryContext.getAssociatedGroups().size() > 0 && ((String)queryContext.getAssociatedGroups().get(0)).length() > 0) {
            for (String groupName : queryContext.getAssociatedGroups()) {
                _paramPlaceHolderName = this.putParamPlaceHolder(_paramPlaceHolders, this.convertWildcardsForLike(groupName));
                if (groupConstraints == null) {
                    groupConstraints = "r" + cnt + ".ASSOC_NAME='" + "isMemberOf" + "' AND r" + cnt + ".TO_PRINCIPAL_ID=rp" + cnt + ".PRINCIPAL_ID AND rp" + cnt + ".PRINCIPAL_NAME LIKE " + _paramPlaceHolderName + " AND rp" + cnt + ".PRINCIPAL_TYPE='group' AND r" + cnt + ".FROM_PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID";
                    continue;
                }
                groupConstraints = " AND r" + cnt + ".ASSOC_NAME='" + "isMemberOf" + "' AND r" + cnt + ".TO_PRINCIPAL_ID=rp" + cnt + ".PRINCIPAL_ID AND rp" + cnt + ".PRINCIPAL_NAME LIKE " + _paramPlaceHolderName + " AND rp" + cnt + ".PRINCIPAL_TYPE='group' AND r" + cnt + ".FROM_PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID";
            }
            fromPart = fromPart + ", SECURITY_PRINCIPAL_ASSOC r" + cnt + ", SECURITY_PRINCIPAL rp" + cnt;
            ++cnt;
        }
        String userConstraints = null;
        if (queryContext.getAssociatedUsers() != null && queryContext.getAssociatedUsers().size() > 0) {
            for (String userName : queryContext.getAssociatedGroups()) {
                _paramPlaceHolderName = this.putParamPlaceHolder(_paramPlaceHolders, this.convertWildcardsForLike(userName));
                if (userConstraints == null) {
                    userConstraints = "r" + cnt + ".ASSOC_NAME='" + "isMemberOf" + "' AND r" + cnt + ".FROM_PRINCIPAL_ID=rp" + cnt + ".PRINCIPAL_ID AND rp" + cnt + ".PRINCIPAL_NAME LIKE " + _paramPlaceHolderName + " AND rp" + cnt + ".PRINCIPAL_TYPE='user' AND r" + cnt + ".TO_PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID";
                    continue;
                }
                userConstraints = " AND r" + cnt + ".ASSOC_NAME='" + "isMemberOf" + "' AND r" + cnt + ".FROM_PRINCIPAL_ID=rp" + cnt + ".PRINCIPAL_ID AND rp" + cnt + ".PRINCIPAL_NAME LIKE " + _paramPlaceHolderName + " AND rp" + cnt + ".PRINCIPAL_TYPE='group' AND r" + cnt + ".TO_PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID";
            }
            fromPart = fromPart + ", SECURITY_PRINCIPAL_ASSOC r" + cnt + ", SECURITY_PRINCIPAL rp" + cnt;
            ++cnt;
        }
        if (attributeConstraint != null) {
            constraint = constraint != null ? constraint + " AND " + attributeConstraint : attributeConstraint;
        }
        if (roleConstraints != null) {
            constraint = constraint != null ? constraint + " AND " + roleConstraints : roleConstraints;
        }
        if (groupConstraints != null) {
            constraint = constraint != null ? constraint + " AND " + groupConstraints : groupConstraints;
        }
        if (userConstraints != null) {
            constraint = constraint != null ? constraint + " AND " + userConstraints : userConstraints;
        }
        String baseSqlStr = "SELECT SECURITY_PRINCIPAL.* from " + fromPart + " WHERE SECURITY_PRINCIPAL.PRINCIPAL_TYPE='" + queryContext.getJetspeedPrincipalType() + "' AND SECURITY_PRINCIPAL.DOMAIN_ID=" + queryContext.getSecurityDomain();
        if (constraint != null) {
            baseSqlStr = baseSqlStr + " AND " + constraint;
        }
        baseSqlStr = queryContext.getOrder() != null && queryContext.getOrder().equalsIgnoreCase("desc") ? baseSqlStr + " ORDER BY SECURITY_PRINCIPAL.PRINCIPAL_NAME DESC" : baseSqlStr + " ORDER BY SECURITY_PRINCIPAL.PRINCIPAL_NAME";
        StringBuilder preparedSqlBuilder = new StringBuilder(baseSqlStr.length());
        char[] sqlChars = baseSqlStr.toCharArray();
        ArrayList parameters = new ArrayList(_paramPlaceHolders.size());
        Segment segment = new Segment(sqlChars, 0, sqlChars.length);
        Matcher matcher = PARAM_PLACEHOLDER_PATTERN.matcher(segment);
        while (matcher.find()) {
            preparedSqlBuilder.append(segment.subSequence(0, matcher.start())).append('?');
            _paramPlaceHolderName = matcher.group(1);
            parameters.add(_paramPlaceHolders.get(_paramPlaceHolderName));
            segment = (Segment)segment.subSequence(matcher.end(), segment.length());
            matcher.reset(segment);
        }
        preparedSqlBuilder.append(segment);
        String preparedSqlStr = preparedSqlBuilder.toString();
        String sql = this.getPagingSql(preparedSqlStr, queryContext);
        PreparedStatement pstmtForPaging = conn.prepareStatement(sql, 1004, 1007);
        for (int i = 0; i < parameters.size(); ++i) {
            pstmtForPaging.setString(i + 1, (String)parameters.get(i));
        }
        pstmtForPaging.setFetchSize((int)(queryContext.getOffset() + queryContext.getLength()));
        String countSql = this.convertToCountQueryStatement(preparedSqlStr);
        PreparedStatement pstmtForCount = conn.prepareStatement(countSql);
        for (int i = 0; i < parameters.size(); ++i) {
            pstmtForCount.setString(i + 1, (String)parameters.get(i));
        }
        return new PreparedStatement[]{pstmtForPaging, pstmtForCount};
    }

    private String convertToCountQueryStatement(String baseSqlStr) {
        int fromPos = baseSqlStr.toUpperCase().indexOf(" FROM ");
        String countSql = "SELECT count(SECURITY_PRINCIPAL.PRINCIPAL_ID)" + baseSqlStr.substring(fromPos);
        int orderByPos = countSql.toUpperCase().indexOf(" ORDER BY ");
        if (orderByPos >= 0) {
            countSql = countSql.substring(0, orderByPos);
        }
        return countSql;
    }

    private String convertWildcardsForLike(String s) {
        String converted = s;
        if (s != null) {
            String textOnly = s;
            boolean foreWildcard = false;
            boolean rearWildcard = false;
            if (textOnly.length() > 0 && (textOnly.charAt(0) == '*' || textOnly.charAt(0) == '%')) {
                textOnly = textOnly.substring(1);
                foreWildcard = true;
            }
            if (textOnly.length() > 0 && (textOnly.charAt(s.length() - 1) == '*' || textOnly.charAt(s.length() - 1) == '%')) {
                textOnly = textOnly.substring(0, textOnly.length() - 1);
                rearWildcard = true;
            }
            if (textOnly.length() > 0) {
                StringBuilder sb = new StringBuilder(textOnly.length() + 2);
                if (foreWildcard) {
                    sb.append('%');
                }
                sb.append(StringUtils.remove((String)textOnly, (char)'%'));
                if (rearWildcard) {
                    sb.append('%');
                }
                converted = sb.toString();
            }
        }
        return converted;
    }

    @Deprecated
    protected String generateBaseSql(JetspeedPrincipalQueryContext queryContext) {
        String attributeConstraint = null;
        String fromPart = "SECURITY_PRINCIPAL";
        if (queryContext.getSecurityAttributes() != null) {
            int cnt = 1;
            for (Map.Entry attribute : queryContext.getSecurityAttributes().entrySet()) {
                attributeConstraint = attributeConstraint == null ? "a" + cnt + ".PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID AND a" + cnt + ".ATTR_NAME = '" + (String)attribute.getKey() + "' AND a" + cnt + ".ATTR_VALUE LIKE '" + (String)attribute.getValue() + "'" : attributeConstraint + " AND a" + cnt + ".PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID AND a" + cnt + ".ATTR_NAME = '" + (String)attribute.getKey() + "' AND a" + cnt + ".ATTR_VALUE LIKE '" + (String)attribute.getValue() + "'";
                fromPart = fromPart + ", SECURITY_ATTRIBUTE a" + cnt;
                ++cnt;
            }
        }
        String constraint = null;
        if (queryContext.getNameFilter() != null && queryContext.getNameFilter().length() > 0) {
            constraint = "SECURITY_PRINCIPAL.PRINCIPAL_NAME LIKE '" + queryContext.getNameFilter().replace('*', '%') + "'";
        }
        String roleConstraints = null;
        if (queryContext.getAssociatedRoles() != null && queryContext.getAssociatedRoles().size() > 0 && ((String)queryContext.getAssociatedRoles().get(0)).length() > 0) {
            int cnt = 1;
            for (String roleName : queryContext.getAssociatedRoles()) {
                if (roleConstraints == null) {
                    roleConstraints = "r" + cnt + ".ASSOC_NAME='" + "isMemberOf" + "' AND r" + cnt + ".TO_PRINCIPAL_ID=rp" + cnt + ".PRINCIPAL_ID AND rp" + cnt + ".PRINCIPAL_NAME LIKE '" + roleName + "' AND rp" + cnt + ".PRINCIPAL_TYPE='role' AND r" + cnt + ".FROM_PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID";
                    continue;
                }
                roleConstraints = " AND r" + cnt + ".ASSOC_NAME='" + "isMemberOf" + "' AND r" + cnt + ".TO_PRINCIPAL_ID=rp" + cnt + ".PRINCIPAL_ID AND rp" + cnt + ".PRINCIPAL_NAME LIKE '" + roleName + "' AND rp" + cnt + ".PRINCIPAL_TYPE='role' AND r" + cnt + ".FROM_PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID";
            }
            fromPart = fromPart + ", SECURITY_PRINCIPAL_ASSOC r" + cnt + ", SECURITY_PRINCIPAL rp" + cnt;
            ++cnt;
        }
        String groupConstraints = null;
        if (queryContext.getAssociatedGroups() != null && queryContext.getAssociatedGroups().size() > 0 && ((String)queryContext.getAssociatedGroups().get(0)).length() > 0) {
            int cnt = 1;
            for (String groupName : queryContext.getAssociatedGroups()) {
                if (groupConstraints == null) {
                    groupConstraints = "r" + cnt + ".ASSOC_NAME='" + "isMemberOf" + "' AND r" + cnt + ".TO_PRINCIPAL_ID=rp" + cnt + ".PRINCIPAL_ID AND rp" + cnt + ".PRINCIPAL_NAME LIKE '" + groupName + "' AND rp" + cnt + ".PRINCIPAL_TYPE='group' AND r" + cnt + ".FROM_PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID";
                    continue;
                }
                groupConstraints = " AND r" + cnt + ".ASSOC_NAME='" + "isMemberOf" + "' AND r" + cnt + ".TO_PRINCIPAL_ID=rp" + cnt + ".PRINCIPAL_ID AND rp" + cnt + ".PRINCIPAL_NAME LIKE '" + groupName + "' AND rp" + cnt + ".PRINCIPAL_TYPE='group' AND r" + cnt + ".FROM_PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID";
            }
            fromPart = fromPart + ", SECURITY_PRINCIPAL_ASSOC r" + cnt + ", SECURITY_PRINCIPAL rp" + cnt;
            ++cnt;
        }
        String userConstraints = null;
        if (queryContext.getAssociatedUsers() != null && queryContext.getAssociatedUsers().size() > 0) {
            int cnt = 1;
            for (String userName : queryContext.getAssociatedGroups()) {
                if (userConstraints == null) {
                    userConstraints = "r" + cnt + ".ASSOC_NAME='" + "isMemberOf" + "' AND r" + cnt + ".FROM_PRINCIPAL_ID=rp" + cnt + ".PRINCIPAL_ID AND rp" + cnt + ".PRINCIPAL_NAME LIKE '" + userName + "' AND rp" + cnt + ".PRINCIPAL_TYPE='user' AND r" + cnt + ".TO_PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID";
                    continue;
                }
                userConstraints = " AND r" + cnt + ".ASSOC_NAME='" + "isMemberOf" + "' AND r" + cnt + ".FROM_PRINCIPAL_ID=rp" + cnt + ".PRINCIPAL_ID AND rp" + cnt + ".PRINCIPAL_NAME LIKE '" + userName + "' AND rp" + cnt + ".PRINCIPAL_TYPE='group' AND r" + cnt + ".TO_PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID";
            }
            fromPart = fromPart + ", SECURITY_PRINCIPAL_ASSOC r" + cnt + ", SECURITY_PRINCIPAL rp" + cnt;
            ++cnt;
        }
        if (attributeConstraint != null) {
            constraint = constraint != null ? constraint + " AND " + attributeConstraint : attributeConstraint;
        }
        if (roleConstraints != null) {
            constraint = constraint != null ? constraint + " AND " + roleConstraints : roleConstraints;
        }
        if (groupConstraints != null) {
            constraint = constraint != null ? constraint + " AND " + groupConstraints : groupConstraints;
        }
        if (userConstraints != null) {
            constraint = constraint != null ? constraint + " AND " + userConstraints : userConstraints;
        }
        String baseSqlStr = "SELECT SECURITY_PRINCIPAL.* from " + fromPart + " WHERE SECURITY_PRINCIPAL.PRINCIPAL_TYPE='" + queryContext.getJetspeedPrincipalType() + "' AND SECURITY_PRINCIPAL.DOMAIN_ID=" + queryContext.getSecurityDomain();
        if (constraint != null) {
            baseSqlStr = baseSqlStr + " AND " + constraint;
        }
        baseSqlStr = queryContext.getOrder() != null && queryContext.getOrder().equalsIgnoreCase("desc") ? baseSqlStr + " ORDER BY SECURITY_PRINCIPAL.PRINCIPAL_NAME DESC" : baseSqlStr + " ORDER BY SECURITY_PRINCIPAL.PRINCIPAL_NAME";
        return baseSqlStr;
    }

    protected abstract String getPagingSql(String var1, JetspeedPrincipalQueryContext var2);

    protected abstract void scrollToOffset(Connection var1, ResultSet var2, long var3) throws SQLException;
}

