/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.mapping.SecurityEntityManager;
import org.apache.jetspeed.security.mapping.model.SecurityEntityRelationType;
import org.apache.jetspeed.security.spi.JetspeedPrincipalAssociationStorageManager;
import org.apache.jetspeed.security.spi.impl.SynchronizationStateAccess;

public class JetspeedPrincipalLdapAssociationStorageManager
implements JetspeedPrincipalAssociationStorageManager {
    private SecurityEntityManager ldapEntityManager;
    private JetspeedPrincipalAssociationStorageManager databaseStorageManager;

    public JetspeedPrincipalLdapAssociationStorageManager(JetspeedPrincipalAssociationStorageManager databaseStorageMngr, SecurityEntityManager ldapEntityManager) {
        this.ldapEntityManager = ldapEntityManager;
        this.databaseStorageManager = databaseStorageMngr;
    }

    @Override
    public void addAssociation(JetspeedPrincipal from, JetspeedPrincipal to, String associationName) throws SecurityException {
        SecurityEntityRelationType relationType;
        if (!SynchronizationStateAccess.isSynchronizing() && !this.ldapEntityManager.isReadOnly() && (relationType = this.ldapEntityManager.getSupportedEntityRelationType(associationName, from.getType().getName(), to.getType().getName())) != null && relationType.isCreateAllowed()) {
            this.ldapEntityManager.addRelation(from.getName(), to.getName(), relationType);
        }
        this.databaseStorageManager.addAssociation(from, to, associationName);
    }

    @Override
    public void removeAssociation(JetspeedPrincipal from, JetspeedPrincipal to, String associationName) throws SecurityException {
        SecurityEntityRelationType relationType;
        if (!SynchronizationStateAccess.isSynchronizing() && !this.ldapEntityManager.isReadOnly() && (relationType = this.ldapEntityManager.getSupportedEntityRelationType(associationName, from.getType().getName(), to.getType().getName())) != null && relationType.isRemoveAllowed()) {
            this.ldapEntityManager.removeRelation(from.getName(), to.getName(), relationType);
        }
        this.databaseStorageManager.removeAssociation(from, to, associationName);
    }
}

