/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.JetspeedPrincipalManagerProvider;
import org.apache.jetspeed.security.JetspeedPrincipalType;
import org.apache.jetspeed.security.SecurityAttributes;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.impl.SecurityAttributesImpl;

public abstract class TransientJetspeedPrincipal
implements JetspeedPrincipal,
Serializable {
    protected static JetspeedPrincipalManagerProvider jpmp;
    protected String name;
    private String type;
    protected transient JetspeedPrincipalType jpt;
    protected transient SecurityAttributes sa;
    private Long domainId;

    public static void setJetspeedPrincipalManagerProvider(JetspeedPrincipalManagerProvider jpmp) {
        TransientJetspeedPrincipal.jpmp = jpmp;
    }

    protected TransientJetspeedPrincipal() {
        this.type = jpmp.getPrincipalTypeByClassName(this.getClass().getName()).getName();
    }

    protected TransientJetspeedPrincipal(String type, String name) {
        this.name = name;
        this.type = type;
    }

    public TransientJetspeedPrincipal(String name) {
        this();
        this.name = name;
    }

    public Long getId() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public synchronized JetspeedPrincipalType getType() {
        if (this.jpt == null) {
            this.jpt = jpmp.getPrincipalType(this.type);
        }
        return this.jpt;
    }

    public Timestamp getCreationDate() {
        return null;
    }

    public Timestamp getModifiedDate() {
        return null;
    }

    public boolean isTransient() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean enabled) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    public boolean isMapped() {
        return false;
    }

    public void setMapped(boolean mapped) {
        throw new UnsupportedOperationException();
    }

    public boolean isReadOnly() {
        return false;
    }

    public void setReadOnly(boolean readOnly) {
        throw new UnsupportedOperationException();
    }

    public boolean isRemovable() {
        return false;
    }

    public void setRemovable(boolean removable) {
        throw new UnsupportedOperationException();
    }

    public boolean isExtendable() {
        return true;
    }

    public void setExtendable(boolean extendable) {
        throw new UnsupportedOperationException();
    }

    public synchronized SecurityAttributes getSecurityAttributes() {
        if (this.sa == null) {
            this.sa = new SecurityAttributesImpl(this);
        }
        return this.sa;
    }

    public Map<String, String> getInfoMap() {
        return this.getSecurityAttributes().getInfoMap();
    }

    public String toString() {
        return this.getType().getName() + ": " + this.getName() + " (id: " + this.getId() + ", transient: " + this.isTransient() + ", mapped: " + this.isMapped() + ")";
    }

    public Long getDomainId() {
        return this.domainId;
    }

    public void setDomainId(Long domainId) {
        this.domainId = domainId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JetspeedPrincipal) {
            JetspeedPrincipal other = (JetspeedPrincipal)o;
            return this.getName().equals(other.getName()) && this.getType().equals(other.getType()) && (this.getDomainId() != null ? this.getDomainId() : 0L) == (other.getDomainId() != null ? other.getDomainId() : 0L);
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getType().hashCode() ^ (this.getDomainId() != null ? this.getDomainId().intValue() : 0);
    }
}

