/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.activeauthentication;

import java.util.List;
import org.apache.jetspeed.cache.CacheElement;
import org.apache.jetspeed.cache.JetspeedCache;
import org.apache.jetspeed.security.activeauthentication.ActiveAuthenticationIdentityProvider;
import org.apache.jetspeed.security.activeauthentication.IdentityToken;
import org.apache.jetspeed.security.activeauthentication.IdentityTokenImpl;

public class ActiveAuthenticationIdentityProviderImpl
implements ActiveAuthenticationIdentityProvider {
    JetspeedCache cache;
    List<String> sessionAttributes;

    public ActiveAuthenticationIdentityProviderImpl(JetspeedCache cache, List<String> sessionAttributes) {
        this.cache = cache;
        this.sessionAttributes = sessionAttributes;
    }

    public IdentityToken createIdentityToken(String seed) {
        String token = seed + "-" + String.valueOf(System.currentTimeMillis());
        return this.createToken(token);
    }

    public IdentityToken createIdentityToken() {
        String token = String.valueOf(System.currentTimeMillis());
        return this.createToken(token);
    }

    private IdentityToken createToken(String token) {
        IdentityTokenImpl identityToken = new IdentityTokenImpl(token);
        CacheElement element = this.cache.createElement((Object)token, (Object)identityToken);
        this.cache.put(element);
        return identityToken;
    }

    public void completeAuthenticationEvent(String token) {
        this.cache.remove((Object)token);
    }

    public List<String> getSessionAttributeNames() {
        return this.sessionAttributes;
    }
}

