/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.migration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.codec.binary.Base64;
import org.apache.jetspeed.tools.migration.JetspeedMigration;
import org.apache.jetspeed.tools.migration.JetspeedMigrationListener;
import org.apache.jetspeed.tools.migration.JetspeedMigrationResult;
import org.apache.jetspeed.tools.migration.JetspeedMigrationResultImpl;

public class JetspeedSecurityMigration
implements JetspeedMigration {
    private static final int SYSTEM_SECURITY_DOMAIN_ID = 0;
    private static final int DEFAULT_SECURITY_DOMAIN_ID = 1;
    private static final char[] CREDENTIAL_VALUE_SCRAMBLER = "Jestspeed-2 is getting ready for release".toCharArray();

    public String getName() {
        return "Security";
    }

    public int detectSourceVersion(Connection sourceConnection, int sourceVersion) throws SQLException {
        int sourceSecurityVersion = 213;
        try {
            Statement securityDomainQueryStatement = sourceConnection.createStatement();
            securityDomainQueryStatement.executeQuery("SELECT DOMAIN_ID FROM SECURITY_DOMAIN WHERE DOMAIN_ID = 0");
            sourceSecurityVersion = 220;
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        return sourceSecurityVersion >= sourceVersion ? sourceSecurityVersion : sourceVersion;
    }

    public JetspeedMigrationResult migrate(Connection sourceConnection, int sourceVersion, Connection targetConnection, JetspeedMigrationListener migrationListener) throws SQLException {
        int rowsMigrated = 0;
        int maxSecurityDomainId = -1;
        PreparedStatement securityDomainInsertStatement = targetConnection.prepareStatement("INSERT INTO SECURITY_DOMAIN (DOMAIN_ID, DOMAIN_NAME, REMOTE, ENABLED, OWNER_DOMAIN_ID) VALUES (?, ?, ?, ?, ?)");
        Statement securityDomainQueryStatement = sourceConnection.createStatement();
        securityDomainQueryStatement.setFetchSize(10000);
        ResultSet securityDomainResultSet = null;
        switch (sourceVersion) {
            case 213: 
            case 214: {
                securityDomainInsertStatement.setInt(1, 0);
                securityDomainInsertStatement.setString(2, "[system]");
                securityDomainInsertStatement.setShort(3, (short)0);
                securityDomainInsertStatement.setShort(4, (short)1);
                securityDomainInsertStatement.setNull(5, 4);
                securityDomainInsertStatement.executeUpdate();
                ++rowsMigrated;
                migrationListener.rowMigrated(targetConnection);
                securityDomainInsertStatement.setInt(1, 1);
                securityDomainInsertStatement.setString(2, "[default]");
                securityDomainInsertStatement.setShort(3, (short)0);
                securityDomainInsertStatement.setShort(4, (short)1);
                securityDomainInsertStatement.setNull(5, 4);
                securityDomainInsertStatement.executeUpdate();
                ++rowsMigrated;
                migrationListener.rowMigrated(targetConnection);
                maxSecurityDomainId = 1;
                securityDomainResultSet = securityDomainQueryStatement.executeQuery("SELECT NAME FROM SSO_SITE");
                while (securityDomainResultSet.next()) {
                    securityDomainInsertStatement.setInt(1, ++maxSecurityDomainId);
                    securityDomainInsertStatement.setString(2, securityDomainResultSet.getString(1));
                    securityDomainInsertStatement.setShort(3, (short)1);
                    securityDomainInsertStatement.setShort(4, (short)1);
                    securityDomainInsertStatement.setInt(5, 1);
                    securityDomainInsertStatement.executeUpdate();
                    ++rowsMigrated;
                    migrationListener.rowMigrated(targetConnection);
                }
                break;
            }
            case 220: 
            case 221: {
                securityDomainResultSet = securityDomainQueryStatement.executeQuery("SELECT DOMAIN_ID, DOMAIN_NAME, REMOTE, ENABLED, OWNER_DOMAIN_ID FROM SECURITY_DOMAIN");
                while (securityDomainResultSet.next()) {
                    securityDomainInsertStatement.setInt(1, securityDomainResultSet.getInt(1));
                    securityDomainInsertStatement.setString(2, securityDomainResultSet.getString(2));
                    JetspeedMigration.Static.setNullableShort((ResultSet)securityDomainResultSet, (int)3, (PreparedStatement)securityDomainInsertStatement);
                    JetspeedMigration.Static.setNullableShort((ResultSet)securityDomainResultSet, (int)4, (PreparedStatement)securityDomainInsertStatement);
                    JetspeedMigration.Static.setNullableInt((ResultSet)securityDomainResultSet, (int)5, (PreparedStatement)securityDomainInsertStatement);
                    securityDomainInsertStatement.executeUpdate();
                    ++rowsMigrated;
                    migrationListener.rowMigrated(targetConnection);
                }
                break;
            }
        }
        securityDomainResultSet.close();
        securityDomainQueryStatement.close();
        securityDomainInsertStatement.close();
        PreparedStatement securityPrincipalInsertStatement = targetConnection.prepareStatement("INSERT INTO SECURITY_PRINCIPAL (PRINCIPAL_ID, PRINCIPAL_TYPE, PRINCIPAL_NAME, IS_MAPPED, IS_ENABLED, IS_READONLY, IS_REMOVABLE, CREATION_DATE, MODIFIED_DATE, DOMAIN_ID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        Statement securityPrincipalQueryStatement = sourceConnection.createStatement();
        securityPrincipalQueryStatement.setFetchSize(10000);
        ResultSet securityPrincipalResultSet = null;
        switch (sourceVersion) {
            case 213: 
            case 214: {
                securityPrincipalResultSet = securityPrincipalQueryStatement.executeQuery("SELECT PRINCIPAL_ID, IS_MAPPING_ONLY, IS_ENABLED, FULL_PATH, CREATION_DATE, MODIFIED_DATE FROM SECURITY_PRINCIPAL");
                PreparedStatement ssoSiteNameQueryStatement = sourceConnection.prepareStatement("SELECT NAME FROM SSO_SITE WHERE SITE_ID = ?");
                PreparedStatement domainQueryStatement = targetConnection.prepareStatement("SELECT DOMAIN_ID FROM SECURITY_DOMAIN WHERE DOMAIN_NAME = ?");
                while (securityPrincipalResultSet.next()) {
                    String fullPath = securityPrincipalResultSet.getString(4);
                    String principalType = null;
                    String principalName = null;
                    int domainId = 1;
                    if (fullPath.startsWith("/user/")) {
                        principalType = "user";
                        principalName = fullPath.substring(6);
                    } else if (fullPath.startsWith("/role/")) {
                        principalType = "role";
                        principalName = fullPath.substring(6);
                    } else if (fullPath.startsWith("/group/")) {
                        principalType = "group";
                        principalName = fullPath.substring(7);
                    } else if (fullPath.startsWith("/sso/")) {
                        principalType = "sso_user";
                        principalName = fullPath.substring(fullPath.lastIndexOf("/") + 1);
                        int ssoSiteId = Integer.parseInt(fullPath.substring(5, fullPath.indexOf("/", 5)));
                        String ssoSiteName = null;
                        ssoSiteNameQueryStatement.setInt(1, ssoSiteId);
                        ResultSet ssoSiteNameResultSet = ssoSiteNameQueryStatement.executeQuery();
                        if (!ssoSiteNameResultSet.next()) {
                            throw new SQLException("Unable to find SSO site name for id: " + ssoSiteId);
                        }
                        ssoSiteName = ssoSiteNameResultSet.getString(1);
                        ssoSiteNameResultSet.close();
                        domainQueryStatement.setString(1, ssoSiteName);
                        ResultSet domainResultSet = domainQueryStatement.executeQuery();
                        if (!domainResultSet.next()) {
                            throw new SQLException("Unable to find domain id for SSO site name: " + ssoSiteName);
                        }
                        domainId = domainResultSet.getInt(1);
                        domainResultSet.close();
                    }
                    if (principalType == null || principalName == null) continue;
                    securityPrincipalInsertStatement.setInt(1, securityPrincipalResultSet.getInt(1));
                    securityPrincipalInsertStatement.setString(2, principalType);
                    securityPrincipalInsertStatement.setString(3, principalName);
                    securityPrincipalInsertStatement.setShort(4, securityPrincipalResultSet.getShort(2));
                    securityPrincipalInsertStatement.setShort(5, securityPrincipalResultSet.getShort(3));
                    securityPrincipalInsertStatement.setShort(6, (short)0);
                    securityPrincipalInsertStatement.setShort(7, (short)1);
                    securityPrincipalInsertStatement.setTimestamp(8, securityPrincipalResultSet.getTimestamp(5));
                    securityPrincipalInsertStatement.setTimestamp(9, securityPrincipalResultSet.getTimestamp(6));
                    securityPrincipalInsertStatement.setInt(10, domainId);
                    securityPrincipalInsertStatement.executeUpdate();
                    ++rowsMigrated;
                    migrationListener.rowMigrated(targetConnection);
                }
                domainQueryStatement.close();
                ssoSiteNameQueryStatement.close();
                break;
            }
            case 220: 
            case 221: {
                securityPrincipalResultSet = securityPrincipalQueryStatement.executeQuery("SELECT PRINCIPAL_ID, PRINCIPAL_TYPE, PRINCIPAL_NAME, IS_MAPPED, IS_ENABLED, IS_READONLY, IS_REMOVABLE, CREATION_DATE, MODIFIED_DATE, DOMAIN_ID FROM SECURITY_PRINCIPAL");
                while (securityPrincipalResultSet.next()) {
                    securityPrincipalInsertStatement.setInt(1, securityPrincipalResultSet.getInt(1));
                    securityPrincipalInsertStatement.setString(2, securityPrincipalResultSet.getString(2));
                    securityPrincipalInsertStatement.setString(3, securityPrincipalResultSet.getString(3));
                    securityPrincipalInsertStatement.setShort(4, securityPrincipalResultSet.getShort(4));
                    securityPrincipalInsertStatement.setShort(5, securityPrincipalResultSet.getShort(5));
                    securityPrincipalInsertStatement.setShort(6, securityPrincipalResultSet.getShort(6));
                    securityPrincipalInsertStatement.setShort(7, securityPrincipalResultSet.getShort(7));
                    securityPrincipalInsertStatement.setTimestamp(8, securityPrincipalResultSet.getTimestamp(8));
                    securityPrincipalInsertStatement.setTimestamp(9, securityPrincipalResultSet.getTimestamp(9));
                    securityPrincipalInsertStatement.setInt(10, securityPrincipalResultSet.getInt(10));
                    securityPrincipalInsertStatement.executeUpdate();
                    ++rowsMigrated;
                    migrationListener.rowMigrated(targetConnection);
                }
                break;
            }
        }
        securityPrincipalResultSet.close();
        securityPrincipalQueryStatement.close();
        securityPrincipalInsertStatement.close();
        boolean securityAttributeRowsMigrated = false;
        PreparedStatement securityAttributeInsertStatement = targetConnection.prepareStatement("INSERT INTO SECURITY_ATTRIBUTE (ATTR_ID, PRINCIPAL_ID, ATTR_NAME, ATTR_VALUE) VALUES (?, ?, ?, ?)");
        Statement securityAttributeQueryStatement = sourceConnection.createStatement();
        securityAttributeQueryStatement.setFetchSize(10000);
        ResultSet securityAttributeResultSet = null;
        switch (sourceVersion) {
            case 213: 
            case 214: {
                securityAttributeResultSet = securityAttributeQueryStatement.executeQuery("SELECT V.PROPERTY_VALUE_ID, NV.FULL_PATH, V.PROPERTY_NAME, V.PROPERTY_VALUE FROM PREFS_PROPERTY_VALUE V, PREFS_NODE NV WHERE NV.NODE_ID = V.NODE_ID AND NV.FULL_PATH LIKE '%/userinfo'");
                PreparedStatement principalQueryStatement = targetConnection.prepareStatement("SELECT PRINCIPAL_ID FROM SECURITY_PRINCIPAL WHERE PRINCIPAL_TYPE = ? AND PRINCIPAL_NAME = ?");
                while (securityAttributeResultSet.next()) {
                    String fullPath = securityAttributeResultSet.getString(2);
                    String principalType = null;
                    String principalName = null;
                    if (fullPath.startsWith("/user/")) {
                        principalType = "user";
                        principalName = fullPath.substring(6, fullPath.length() - 9);
                    } else if (fullPath.startsWith("/role/")) {
                        principalType = "role";
                        principalName = fullPath.substring(6, fullPath.length() - 9);
                    } else if (fullPath.startsWith("/group/")) {
                        principalType = "group";
                        principalName = fullPath.substring(7, fullPath.length() - 9);
                    }
                    if (principalType == null || principalName == null) continue;
                    int principalId = 0;
                    principalQueryStatement.setString(1, principalType);
                    principalQueryStatement.setString(2, principalName);
                    ResultSet principalResultSet = principalQueryStatement.executeQuery();
                    if (!principalResultSet.next()) {
                        throw new SQLException("Unable to find security principal id for principal: " + principalType + "/" + principalName);
                    }
                    principalId = principalResultSet.getInt(1);
                    principalResultSet.close();
                    securityAttributeInsertStatement.setInt(1, securityAttributeResultSet.getInt(1));
                    securityAttributeInsertStatement.setInt(2, principalId);
                    securityAttributeInsertStatement.setString(3, securityAttributeResultSet.getString(3));
                    securityAttributeInsertStatement.setString(4, securityAttributeResultSet.getString(4));
                    securityAttributeInsertStatement.executeUpdate();
                    ++rowsMigrated;
                    migrationListener.rowMigrated(targetConnection);
                    securityAttributeRowsMigrated = true;
                }
                principalQueryStatement.close();
                break;
            }
            case 220: 
            case 221: {
                securityAttributeResultSet = securityAttributeQueryStatement.executeQuery("SELECT ATTR_ID, PRINCIPAL_ID, ATTR_NAME, ATTR_VALUE FROM SECURITY_ATTRIBUTE");
                while (securityAttributeResultSet.next()) {
                    securityAttributeInsertStatement.setInt(1, securityAttributeResultSet.getInt(1));
                    securityAttributeInsertStatement.setInt(2, securityAttributeResultSet.getInt(2));
                    securityAttributeInsertStatement.setString(3, securityAttributeResultSet.getString(3));
                    securityAttributeInsertStatement.setString(4, securityAttributeResultSet.getString(4));
                    securityAttributeInsertStatement.executeUpdate();
                    ++rowsMigrated;
                    migrationListener.rowMigrated(targetConnection);
                }
                break;
            }
        }
        securityAttributeResultSet.close();
        securityAttributeQueryStatement.close();
        securityAttributeInsertStatement.close();
        PreparedStatement securityPrincipalAssocInsertStatement = targetConnection.prepareStatement("INSERT INTO SECURITY_PRINCIPAL_ASSOC (ASSOC_NAME, FROM_PRINCIPAL_ID, TO_PRINCIPAL_ID) VALUES (?, ?, ?)");
        switch (sourceVersion) {
            case 213: 
            case 214: {
                Statement securityPrincipalAssocQueryStatement1 = sourceConnection.createStatement();
                securityPrincipalAssocQueryStatement1.setFetchSize(10000);
                ResultSet securityPrincipalAssocResultSet = securityPrincipalAssocQueryStatement1.executeQuery("SELECT USER_ID, ROLE_ID FROM SECURITY_USER_ROLE");
                while (securityPrincipalAssocResultSet.next()) {
                    securityPrincipalAssocInsertStatement.setString(1, "isMemberOf");
                    securityPrincipalAssocInsertStatement.setInt(2, securityPrincipalAssocResultSet.getInt(1));
                    securityPrincipalAssocInsertStatement.setInt(3, securityPrincipalAssocResultSet.getInt(2));
                    securityPrincipalAssocInsertStatement.executeUpdate();
                    ++rowsMigrated;
                    migrationListener.rowMigrated(targetConnection);
                }
                securityPrincipalAssocResultSet.close();
                securityPrincipalAssocQueryStatement1.close();
                Statement securityPrincipalAssocQueryStatement2 = sourceConnection.createStatement();
                securityPrincipalAssocQueryStatement2.setFetchSize(10000);
                securityPrincipalAssocResultSet = securityPrincipalAssocQueryStatement2.executeQuery("SELECT USER_ID, GROUP_ID FROM SECURITY_USER_GROUP");
                while (securityPrincipalAssocResultSet.next()) {
                    securityPrincipalAssocInsertStatement.setString(1, "isMemberOf");
                    securityPrincipalAssocInsertStatement.setInt(2, securityPrincipalAssocResultSet.getInt(1));
                    securityPrincipalAssocInsertStatement.setInt(3, securityPrincipalAssocResultSet.getInt(2));
                    securityPrincipalAssocInsertStatement.executeUpdate();
                    ++rowsMigrated;
                    migrationListener.rowMigrated(targetConnection);
                }
                securityPrincipalAssocResultSet.close();
                securityPrincipalAssocQueryStatement2.close();
                Statement securityPrincipalAssocQueryStatement3 = sourceConnection.createStatement();
                securityPrincipalAssocQueryStatement3.setFetchSize(10000);
                securityPrincipalAssocResultSet = securityPrincipalAssocQueryStatement3.executeQuery("SELECT GROUP_ID, ROLE_ID FROM SECURITY_GROUP_ROLE");
                while (securityPrincipalAssocResultSet.next()) {
                    securityPrincipalAssocInsertStatement.setString(1, "isMemberOf");
                    securityPrincipalAssocInsertStatement.setInt(2, securityPrincipalAssocResultSet.getInt(1));
                    securityPrincipalAssocInsertStatement.setInt(3, securityPrincipalAssocResultSet.getInt(2));
                    securityPrincipalAssocInsertStatement.executeUpdate();
                    ++rowsMigrated;
                    migrationListener.rowMigrated(targetConnection);
                }
                securityPrincipalAssocResultSet.close();
                securityPrincipalAssocQueryStatement3.close();
                Statement ssoPrincipalQueryStatement = sourceConnection.createStatement();
                ssoPrincipalQueryStatement.setFetchSize(10000);
                ResultSet ssoPrincipalResultSet = ssoPrincipalQueryStatement.executeQuery("SELECT PRINCIPAL_ID, FULL_PATH FROM SECURITY_PRINCIPAL WHERE FULL_PATH LIKE '/sso/%'");
                PreparedStatement principalQueryStatement = targetConnection.prepareStatement("SELECT PRINCIPAL_ID FROM SECURITY_PRINCIPAL WHERE PRINCIPAL_TYPE = 'user' AND DOMAIN_ID = 1 AND PRINCIPAL_NAME = ?");
                while (ssoPrincipalResultSet.next()) {
                    String fullPath = ssoPrincipalResultSet.getString(2);
                    int ssoPrincipalNameIndex = fullPath.lastIndexOf("/");
                    int principalNameIndex = fullPath.lastIndexOf("/", ssoPrincipalNameIndex - 1);
                    String principalName = fullPath.substring(principalNameIndex + 1, ssoPrincipalNameIndex);
                    int principalId = 0;
                    principalQueryStatement.setString(1, principalName);
                    ResultSet principalResultSet = principalQueryStatement.executeQuery();
                    if (!principalResultSet.next()) {
                        throw new SQLException("Unable to find security principal id for principal: " + principalName);
                    }
                    principalId = principalResultSet.getInt(1);
                    principalResultSet.close();
                    int ssoPrincipalId = ssoPrincipalResultSet.getInt(1);
                    securityPrincipalAssocInsertStatement.setString(1, "isRemoteIdFor");
                    securityPrincipalAssocInsertStatement.setInt(2, ssoPrincipalId);
                    securityPrincipalAssocInsertStatement.setInt(3, principalId);
                    securityPrincipalAssocInsertStatement.executeUpdate();
                    ++rowsMigrated;
                    migrationListener.rowMigrated(targetConnection);
                }
                principalQueryStatement.close();
                ssoPrincipalResultSet.close();
                ssoPrincipalQueryStatement.close();
                break;
            }
            case 220: 
            case 221: {
                Statement securityPrincipalAssocQueryStatement = sourceConnection.createStatement();
                securityPrincipalAssocQueryStatement.setFetchSize(10000);
                ResultSet securityPrincipalAssocResultSet = securityPrincipalAssocQueryStatement.executeQuery("SELECT ASSOC_NAME, FROM_PRINCIPAL_ID, TO_PRINCIPAL_ID FROM SECURITY_PRINCIPAL_ASSOC");
                while (securityPrincipalAssocResultSet.next()) {
                    securityPrincipalAssocInsertStatement.setString(1, securityPrincipalAssocResultSet.getString(1));
                    securityPrincipalAssocInsertStatement.setInt(2, securityPrincipalAssocResultSet.getInt(2));
                    securityPrincipalAssocInsertStatement.setInt(3, securityPrincipalAssocResultSet.getInt(3));
                    securityPrincipalAssocInsertStatement.executeUpdate();
                    ++rowsMigrated;
                    migrationListener.rowMigrated(targetConnection);
                }
                securityPrincipalAssocResultSet.close();
                securityPrincipalAssocQueryStatement.close();
            }
        }
        securityPrincipalAssocInsertStatement.close();
        PreparedStatement securityPermissionInsertStatement = targetConnection.prepareStatement("INSERT INTO SECURITY_PERMISSION (PERMISSION_ID, PERMISSION_TYPE, NAME, ACTIONS) VALUES (?, ?, ?, ?)");
        Statement securityPermissionQueryStatement = sourceConnection.createStatement();
        securityPermissionQueryStatement.setFetchSize(10000);
        ResultSet securityPermissionResultSet = null;
        switch (sourceVersion) {
            case 213: 
            case 214: {
                securityPermissionResultSet = securityPermissionQueryStatement.executeQuery("SELECT PERMISSION_ID, CLASSNAME, NAME, ACTIONS FROM SECURITY_PERMISSION");
                while (securityPermissionResultSet.next()) {
                    String className = securityPermissionResultSet.getString(2);
                    String permissionType = null;
                    if (className.equals("org.apache.jetspeed.security.FolderPermission")) {
                        permissionType = "folder";
                    } else if (className.equals("org.apache.jetspeed.security.PagePermission")) {
                        permissionType = "page";
                    } else if (className.equals("org.apache.jetspeed.security.PortletPermission")) {
                        permissionType = "portlet";
                    } else if (className.equals("org.apache.jetspeed.security.FragmentPermission")) {
                        permissionType = "fragment";
                    }
                    if (permissionType == null) continue;
                    securityPermissionInsertStatement.setInt(1, securityPermissionResultSet.getInt(1));
                    securityPermissionInsertStatement.setString(2, permissionType);
                    String name = securityPermissionResultSet.getString(3);
                    if (permissionType.equals("portlet")) {
                        String migratedPortlet = (String)PORTLET_NAME_2_1_X_TO_2_2_X_MIGRATION_MAP.get(name);
                        name = migratedPortlet != null ? migratedPortlet : name;
                    }
                    securityPermissionInsertStatement.setString(3, securityPermissionResultSet.getString(3));
                    securityPermissionInsertStatement.setString(4, securityPermissionResultSet.getString(4));
                    securityPermissionInsertStatement.executeUpdate();
                    ++rowsMigrated;
                    migrationListener.rowMigrated(targetConnection);
                }
                break;
            }
            case 220: 
            case 221: {
                securityPermissionResultSet = securityPermissionQueryStatement.executeQuery("SELECT PERMISSION_ID, PERMISSION_TYPE, NAME, ACTIONS FROM SECURITY_PERMISSION");
                while (securityPermissionResultSet.next()) {
                    securityPermissionInsertStatement.setInt(1, securityPermissionResultSet.getInt(1));
                    securityPermissionInsertStatement.setString(2, securityPermissionResultSet.getString(2));
                    securityPermissionInsertStatement.setString(3, securityPermissionResultSet.getString(3));
                    securityPermissionInsertStatement.setString(4, securityPermissionResultSet.getString(4));
                    securityPermissionInsertStatement.executeUpdate();
                    ++rowsMigrated;
                    migrationListener.rowMigrated(targetConnection);
                }
                break;
            }
        }
        securityPermissionResultSet.close();
        securityPermissionQueryStatement.close();
        securityPermissionInsertStatement.close();
        PreparedStatement principalPermissionInsertStatement = targetConnection.prepareStatement("INSERT INTO PRINCIPAL_PERMISSION (PRINCIPAL_ID, PERMISSION_ID) VALUES (?, ?)");
        Statement principalPermissionQueryStatement = sourceConnection.createStatement();
        principalPermissionQueryStatement.setFetchSize(10000);
        ResultSet principalPermissionResultSet = principalPermissionQueryStatement.executeQuery("SELECT PRINCIPAL_ID, PERMISSION_ID FROM PRINCIPAL_PERMISSION");
        while (principalPermissionResultSet.next()) {
            principalPermissionInsertStatement.setInt(1, principalPermissionResultSet.getInt(1));
            principalPermissionInsertStatement.setInt(2, principalPermissionResultSet.getInt(2));
            principalPermissionInsertStatement.executeUpdate();
            ++rowsMigrated;
            migrationListener.rowMigrated(targetConnection);
        }
        principalPermissionResultSet.close();
        principalPermissionQueryStatement.close();
        principalPermissionInsertStatement.close();
        PreparedStatement securityCredentialInsertStatement = targetConnection.prepareStatement("INSERT INTO SECURITY_CREDENTIAL (CREDENTIAL_ID, PRINCIPAL_ID, CREDENTIAL_VALUE, TYPE, UPDATE_ALLOWED, IS_STATE_READONLY, UPDATE_REQUIRED, IS_ENCODED, IS_ENABLED, AUTH_FAILURES, IS_EXPIRED, CREATION_DATE, MODIFIED_DATE, PREV_AUTH_DATE, LAST_AUTH_DATE, EXPIRATION_DATE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        Statement securityCredentialQueryStatement = sourceConnection.createStatement();
        securityCredentialQueryStatement.setFetchSize(10000);
        ResultSet securityCredentialResultSet = null;
        switch (sourceVersion) {
            case 213: 
            case 214: {
                securityCredentialResultSet = securityCredentialQueryStatement.executeQuery("SELECT CREDENTIAL_ID, PRINCIPAL_ID, COLUMN_VALUE, TYPE, UPDATE_REQUIRED, IS_ENCODED, IS_ENABLED, AUTH_FAILURES, IS_EXPIRED, CREATION_DATE, MODIFIED_DATE, PREV_AUTH_DATE, LAST_AUTH_DATE, EXPIRATION_DATE FROM SECURITY_CREDENTIAL");
                PreparedStatement principalTypeQueryStatement = targetConnection.prepareStatement("SELECT PRINCIPAL_TYPE FROM SECURITY_PRINCIPAL WHERE PRINCIPAL_ID = ?");
                while (securityCredentialResultSet.next()) {
                    boolean encoded;
                    int principalId = securityCredentialResultSet.getInt(2);
                    String principalType = null;
                    principalTypeQueryStatement.setInt(1, principalId);
                    ResultSet principalTypeResultSet = principalTypeQueryStatement.executeQuery();
                    if (!principalTypeResultSet.next()) {
                        throw new SQLException("Unable to find principal type for principal id: " + principalId);
                    }
                    principalType = principalTypeResultSet.getString(1);
                    principalTypeResultSet.close();
                    String credentialValue = securityCredentialResultSet.getString(3);
                    boolean bl = encoded = securityCredentialResultSet.getShort(6) != 0;
                    if (principalType.equals("sso_user") && !encoded) {
                        credentialValue = this.unscrambleCredentialValue(credentialValue);
                    }
                    securityCredentialInsertStatement.setInt(1, securityCredentialResultSet.getInt(1));
                    securityCredentialInsertStatement.setInt(2, principalId);
                    securityCredentialInsertStatement.setString(3, credentialValue);
                    securityCredentialInsertStatement.setShort(4, securityCredentialResultSet.getShort(4));
                    securityCredentialInsertStatement.setShort(5, (short)1);
                    securityCredentialInsertStatement.setShort(6, (short)0);
                    securityCredentialInsertStatement.setShort(7, securityCredentialResultSet.getShort(5));
                    securityCredentialInsertStatement.setShort(8, encoded ? (short)1 : 0);
                    securityCredentialInsertStatement.setShort(9, securityCredentialResultSet.getShort(7));
                    securityCredentialInsertStatement.setShort(10, securityCredentialResultSet.getShort(8));
                    securityCredentialInsertStatement.setShort(11, securityCredentialResultSet.getShort(9));
                    securityCredentialInsertStatement.setTimestamp(12, securityCredentialResultSet.getTimestamp(10));
                    securityCredentialInsertStatement.setTimestamp(13, securityCredentialResultSet.getTimestamp(11));
                    securityCredentialInsertStatement.setTimestamp(14, securityCredentialResultSet.getTimestamp(12));
                    securityCredentialInsertStatement.setTimestamp(15, securityCredentialResultSet.getTimestamp(13));
                    securityCredentialInsertStatement.setDate(16, securityCredentialResultSet.getDate(14));
                    securityCredentialInsertStatement.executeUpdate();
                    ++rowsMigrated;
                    migrationListener.rowMigrated(targetConnection);
                }
                principalTypeQueryStatement.close();
                break;
            }
            case 220: 
            case 221: {
                securityCredentialResultSet = securityCredentialQueryStatement.executeQuery("SELECT CREDENTIAL_ID, PRINCIPAL_ID, CREDENTIAL_VALUE, TYPE, UPDATE_ALLOWED, IS_STATE_READONLY, UPDATE_REQUIRED, IS_ENCODED, IS_ENABLED, AUTH_FAILURES, IS_EXPIRED, CREATION_DATE, MODIFIED_DATE, PREV_AUTH_DATE, LAST_AUTH_DATE, EXPIRATION_DATE FROM SECURITY_CREDENTIAL");
                while (securityCredentialResultSet.next()) {
                    securityCredentialInsertStatement.setInt(1, securityCredentialResultSet.getInt(1));
                    securityCredentialInsertStatement.setInt(2, securityCredentialResultSet.getInt(2));
                    securityCredentialInsertStatement.setString(3, securityCredentialResultSet.getString(3));
                    securityCredentialInsertStatement.setShort(4, securityCredentialResultSet.getShort(4));
                    securityCredentialInsertStatement.setShort(5, securityCredentialResultSet.getShort(5));
                    securityCredentialInsertStatement.setShort(6, securityCredentialResultSet.getShort(6));
                    securityCredentialInsertStatement.setShort(7, securityCredentialResultSet.getShort(7));
                    securityCredentialInsertStatement.setShort(8, securityCredentialResultSet.getShort(8));
                    securityCredentialInsertStatement.setShort(9, securityCredentialResultSet.getShort(9));
                    securityCredentialInsertStatement.setShort(10, securityCredentialResultSet.getShort(10));
                    securityCredentialInsertStatement.setShort(11, securityCredentialResultSet.getShort(11));
                    securityCredentialInsertStatement.setTimestamp(12, securityCredentialResultSet.getTimestamp(12));
                    securityCredentialInsertStatement.setTimestamp(13, securityCredentialResultSet.getTimestamp(13));
                    securityCredentialInsertStatement.setTimestamp(14, securityCredentialResultSet.getTimestamp(14));
                    securityCredentialInsertStatement.setTimestamp(15, securityCredentialResultSet.getTimestamp(15));
                    securityCredentialInsertStatement.setDate(16, securityCredentialResultSet.getDate(16));
                    securityCredentialInsertStatement.executeUpdate();
                    ++rowsMigrated;
                    migrationListener.rowMigrated(targetConnection);
                }
                break;
            }
        }
        securityCredentialResultSet.close();
        securityCredentialQueryStatement.close();
        securityCredentialInsertStatement.close();
        PreparedStatement ojbInsertStatement = targetConnection.prepareStatement("INSERT INTO OJB_HL_SEQ (TABLENAME, FIELDNAME, MAX_KEY, GRAB_SIZE, VERSION) VALUES (?, ?, ?, ?, ?)");
        Statement ojbQueryStatement = sourceConnection.createStatement();
        ResultSet ojbResultSet = ojbQueryStatement.executeQuery("SELECT TABLENAME, FIELDNAME, MAX_KEY, GRAB_SIZE, VERSION FROM OJB_HL_SEQ WHERE TABLENAME IN ('SEQ_SECURITY_PRINCIPAL', 'SEQ_SECURITY_ATTRIBUTE', 'SEQ_SECURITY_PERMISSION', 'SEQ_SECURITY_CREDENTIAL', 'SEQ_SECURITY_DOMAIN')");
        while (ojbResultSet.next()) {
            ojbInsertStatement.setString(1, ojbResultSet.getString(1));
            ojbInsertStatement.setString(2, ojbResultSet.getString(2));
            ojbInsertStatement.setInt(3, ojbResultSet.getInt(3));
            ojbInsertStatement.setInt(4, ojbResultSet.getInt(4));
            ojbInsertStatement.setInt(5, ojbResultSet.getInt(5));
            ojbInsertStatement.executeUpdate();
            ++rowsMigrated;
            migrationListener.rowMigrated(targetConnection);
        }
        ojbResultSet.close();
        ojbQueryStatement.close();
        switch (sourceVersion) {
            case 213: 
            case 214: {
                ojbQueryStatement = sourceConnection.createStatement();
                ojbResultSet = ojbQueryStatement.executeQuery("SELECT TABLENAME, FIELDNAME, MAX_KEY, GRAB_SIZE, VERSION FROM OJB_HL_SEQ WHERE TABLENAME IN ('SEQ_PREFS_PROPERTY_VALUE')");
                while (ojbResultSet.next()) {
                    String tableName = ojbResultSet.getString(1);
                    String migratedTableName = null;
                    if (tableName.equals("SEQ_PREFS_PROPERTY_VALUE") && securityAttributeRowsMigrated) {
                        migratedTableName = "SEQ_SECURITY_ATTRIBUTE";
                    }
                    if (migratedTableName == null) continue;
                    ojbInsertStatement.setString(1, migratedTableName);
                    ojbInsertStatement.setString(2, ojbResultSet.getString(2));
                    ojbInsertStatement.setInt(3, ojbResultSet.getInt(3));
                    ojbInsertStatement.setInt(4, ojbResultSet.getInt(4));
                    ojbInsertStatement.setInt(5, ojbResultSet.getInt(5));
                    ojbInsertStatement.executeUpdate();
                    ++rowsMigrated;
                    migrationListener.rowMigrated(targetConnection);
                }
                ojbResultSet.close();
                ojbQueryStatement.close();
                if (maxSecurityDomainId <= -1) break;
                int grabSize = 20;
                int version = (maxSecurityDomainId + (grabSize - 1)) / grabSize;
                int maxKey = version * grabSize;
                ojbInsertStatement.setString(1, "SEQ_SECURITY_DOMAIN");
                ojbInsertStatement.setString(2, "deprecatedColumn");
                ojbInsertStatement.setInt(3, maxKey);
                ojbInsertStatement.setInt(4, grabSize);
                ojbInsertStatement.setInt(5, version);
                ojbInsertStatement.executeUpdate();
                ++rowsMigrated;
                migrationListener.rowMigrated(targetConnection);
            }
        }
        ojbInsertStatement.close();
        return new JetspeedMigrationResultImpl(rowsMigrated);
    }

    private String unscrambleCredentialValue(String credentialValue) {
        byte[] valueBytes = credentialValue.getBytes();
        valueBytes = Base64.decodeBase64((byte[])valueBytes);
        char[] valueChars = new String(valueBytes).toCharArray();
        int len = Math.min(valueChars.length, CREDENTIAL_VALUE_SCRAMBLER.length);
        char[] unscrambledValueChars = new char[len];
        for (int i = 0; i < len; ++i) {
            unscrambledValueChars[i] = (char)(valueChars[i] ^ CREDENTIAL_VALUE_SCRAMBLER[i]);
        }
        return new String(unscrambledValueChars);
    }
}

