/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.util.ojb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.jetspeed.security.JetspeedPrincipalManagerProvider;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.RowReaderDefaultImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;

public class JetspeedPrincipalConcreteClassRowReader
extends RowReaderDefaultImpl {
    private static final long serialVersionUID = 1L;
    private ClassDescriptor m_cld;
    private static JetspeedPrincipalManagerProvider jpmp;
    private static final String OJB_CONCRETE_CLASS_KEY = "ojbTemporaryNoneColumnKey";

    public static void setJetspeedPrincipalManagerProvider(JetspeedPrincipalManagerProvider jpmp) {
        JetspeedPrincipalConcreteClassRowReader.jpmp = jpmp;
    }

    public JetspeedPrincipalConcreteClassRowReader(ClassDescriptor cld) {
        super(cld);
        this.m_cld = cld;
    }

    protected String extractOjbConcreteClass(ClassDescriptor cld, ResultSet rs) {
        FieldDescriptor fld = this.m_cld.getFieldDescriptorByName("type");
        if (fld == null) {
            return null;
        }
        try {
            Object tmp = fld.getJdbcType().getObjectFromColumn(rs, fld.getColumnName());
            String result = jpmp.getPrincipalType((String)tmp).getClassName();
            String string = result = result != null ? result.trim() : null;
            if (result == null || result.length() == 0) {
                throw new PersistenceBrokerException("ojbConcreteClass field for class " + cld.getClassNameOfObject() + " returned null or 0-length string");
            }
            return result;
        }
        catch (SQLException e) {
            throw new PersistenceBrokerException("Unexpected error while try to read 'ojbConcretClass' field from result set using column name " + fld.getColumnName() + " main class" + " was " + this.m_cld.getClassNameOfObject(), (Throwable)e);
        }
    }

    protected Object buildOrRefreshObject(Map row, ClassDescriptor targetClassDescriptor, Object targetObject) {
        Object result = targetObject;
        FieldDescriptor fmd = null;
        if (targetObject == null) {
            try {
                result = Class.forName((String)row.get(OJB_CONCRETE_CLASS_KEY)).newInstance();
            }
            catch (Exception e) {
                throw new PersistenceBrokerException("Unexpected error while try to instantiate concrete PersistentJetspeedPrincipal instance of class: [" + row.get(OJB_CONCRETE_CLASS_KEY), (Throwable)e);
            }
        }
        FieldDescriptor[] fields = targetClassDescriptor.getFieldDescriptions();
        for (int i = 0; i < fields.length; ++i) {
            fmd = fields[i];
            fmd.getPersistentField().set(result, row.get(fmd.getColumnName()));
        }
        return result;
    }

    protected ClassDescriptor selectClassDescriptor(Map row) throws PersistenceBrokerException {
        ClassDescriptor result = this.m_cld;
        String ojbConcreteClass = (String)row.get(OJB_CONCRETE_CLASS_KEY);
        if (ojbConcreteClass != null && (result = this.m_cld.getRepository().getDescriptorFor(ojbConcreteClass)) == null) {
            throw new PersistenceBrokerException("Can't find class-descriptor for ojbConcreteClass '" + ojbConcreteClass + "', the main class was " + this.m_cld.getClassNameOfObject());
        }
        return result;
    }
}

