/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.util;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.jetspeed.security.SecurityException;

public class PBEPasswordTool {
    private static final String CIPHER_ALGORITM = "PBEwithMD5andDES";
    private static final int PKCS_5_ITERATIONCOUNT = 1111;
    private static final byte[] PKCS_5_BASE_SALT = new byte[]{-87, -101, -56, 50, 86, 53, -29, 3};
    private SecretKey pbeKey;

    public PBEPasswordTool(String pbePassword) throws InvalidKeySpecException, NoSuchAlgorithmException {
        this.pbeKey = SecretKeyFactory.getInstance(CIPHER_ALGORITM).generateSecret(new PBEKeySpec(pbePassword.toCharArray()));
    }

    public String encode(String userName, String clearTextPassword) throws SecurityException {
        try {
            PBEParameterSpec cipherSpec = new PBEParameterSpec(this.createSalt(userName.getBytes("UTF-8")), 1111);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITM);
            cipher.init(1, (Key)this.pbeKey, cipherSpec);
            return new String(Base64.encodeBase64((byte[])cipher.doFinal(clearTextPassword.getBytes("UTF-8"))), "UTF-8");
        }
        catch (Exception e) {
            throw new SecurityException(SecurityException.UNEXPECTED.create((Object)"PBEPasswordTool", (Object)"encode", (Object)e.getMessage()), (Throwable)e);
        }
    }

    public String decode(String userName, String encodedPassword) throws SecurityException {
        try {
            PBEParameterSpec cipherSpec = new PBEParameterSpec(this.createSalt(userName.getBytes("UTF-8")), 1111);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITM);
            cipher.init(2, (Key)this.pbeKey, cipherSpec);
            return new String(cipher.doFinal(Base64.decodeBase64((byte[])encodedPassword.getBytes("UTF-8"))), "UTF-8");
        }
        catch (Exception e) {
            throw new SecurityException(SecurityException.UNEXPECTED.create((Object)"PBEPasswordTool", (Object)"decode", (Object)e.getMessage()), (Throwable)e);
        }
    }

    private byte[] createSalt(byte[] secret) {
        int i;
        byte[] salt = new byte[PKCS_5_BASE_SALT.length];
        for (i = 0; i < salt.length && i < secret.length; ++i) {
            salt[i] = secret[i];
        }
        while (i < salt.length) {
            salt[i] = PKCS_5_BASE_SALT[i];
            ++i;
        }
        return salt;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 4 || !args[0].equals("encode") && !args[0].equals("decode")) {
            System.err.println("Encode/Decode a user password using Password Based Encryption");
            System.err.println("Usage: PBEPasswordTool <encode|decode> <encoding-password> <username> <password>");
            System.err.println("  encode|decode    : specify if to encode or decode the provided password");
            System.err.println("  encoding-password: the password to be used for encoding and decoding");
            System.err.println("  username         : the name of the user to which the provided password belongs");
            System.err.println("  password         : the cleartext password to encode, or the encoded password to decode\n");
        } else if (args[0].toLowerCase().equals("encode")) {
            System.out.println("Encoded password: " + new PBEPasswordTool(args[1]).encode(args[2], args[3]));
        } else {
            System.out.println("Decoded password: " + new PBEPasswordTool(args[1]).decode(args[2], args[3]));
        }
    }
}

