/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mapping.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.security.mapping.impl.BaseSearchResultHandler;

public class CollectingSearchResultHandler<T, R>
extends BaseSearchResultHandler<T, R> {
    private T singleResult;
    private List<T> results;

    public CollectingSearchResultHandler() {
    }

    public CollectingSearchResultHandler(List<T> results) {
        this.results = results;
    }

    public CollectingSearchResultHandler(int maxSize) {
        super(maxSize);
    }

    public CollectingSearchResultHandler(int maxSize, List<T> results) {
        super(maxSize);
        this.results = results;
    }

    public T getSingleResult() {
        return this.singleResult;
    }

    public List<T> getResults() {
        if (this.results == null) {
            this.results = new ArrayList<T>();
        }
        return this.results;
    }

    @Override
    protected boolean postHandleSearchResult(T mappedResult, int pageSize, int pageIndex, int index) {
        if (this.getMaxCount() == 1) {
            this.singleResult = mappedResult;
        } else if (this.getMaxCount() == 0 || this.getCount() <= this.getMaxCount()) {
            this.getResults().add(mappedResult);
        }
        return true;
    }
}

