/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.jetspeed.cache.DistributedCacheObject;
import org.apache.jetspeed.security.SecurityAttributes;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.impl.SecurityAttributesImpl;
import org.apache.jetspeed.security.impl.TransientJetspeedPrincipal;
import org.apache.jetspeed.security.spi.impl.SynchronizationStateAccess;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerAware;
import org.apache.ojb.broker.PersistenceBrokerException;

public abstract class PersistentJetspeedPrincipal
extends TransientJetspeedPrincipal
implements PersistenceBrokerAware,
DistributedCacheObject,
Serializable {
    private Long id;
    private Timestamp creationDate;
    private Timestamp modifiedDate;
    private boolean enabled = true;
    private boolean mapped;
    private boolean readOnly;
    private boolean removable = true;
    private boolean extendable = true;
    protected Collection attributes;

    public PersistentJetspeedPrincipal() {
    }

    public PersistentJetspeedPrincipal(String name) {
        super(name);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Timestamp getCreationDate() {
        return this.creationDate;
    }

    @Override
    public Timestamp getModifiedDate() {
        return this.modifiedDate;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) throws SecurityException {
        if (this.isReadOnly() && !this.isSynchronizing()) {
            throw new SecurityException(SecurityException.PRINCIPAL_IS_READ_ONLY.createScoped(this.getType().getName(), (Object)this.getName()));
        }
        this.enabled = enabled;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public boolean isMapped() {
        return this.mapped;
    }

    @Override
    public void setMapped(boolean mapped) {
        this.mapped = mapped;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean isRemovable() {
        return this.removable;
    }

    @Override
    public void setRemovable(boolean removable) {
        this.removable = removable;
    }

    @Override
    public boolean isExtendable() {
        return this.extendable;
    }

    @Override
    public void setExtendable(boolean extendable) {
        this.extendable = extendable;
    }

    @Override
    public synchronized SecurityAttributes getSecurityAttributes() {
        if (this.sa == null) {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.sa = new SecurityAttributesImpl(this, this.attributes, this.isReadOnly(), this.isExtendable());
        }
        return this.sa;
    }

    @Override
    public Map<String, String> getInfoMap() {
        return this.getSecurityAttributes().getInfoMap();
    }

    public void afterDelete(PersistenceBroker pb) throws PersistenceBrokerException {
    }

    public synchronized void afterInsert(PersistenceBroker pb) throws PersistenceBrokerException {
        this.sa = null;
    }

    public void afterLookup(PersistenceBroker pb) throws PersistenceBrokerException {
    }

    public void afterUpdate(PersistenceBroker pb) throws PersistenceBrokerException {
    }

    public void beforeDelete(PersistenceBroker pb) throws PersistenceBrokerException {
    }

    public void beforeInsert(PersistenceBroker pb) throws PersistenceBrokerException {
        this.modifiedDate = this.creationDate = new Timestamp(System.currentTimeMillis());
    }

    public void beforeUpdate(PersistenceBroker pb) throws PersistenceBrokerException {
        this.modifiedDate = new Timestamp(System.currentTimeMillis());
    }

    protected boolean isSynchronizing() {
        return SynchronizationStateAccess.isSynchronizing();
    }

    public void notifyChange(int action) {
    }
}

