/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import javax.naming.AuthenticationException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.security.AuthenticatedUser;
import org.apache.jetspeed.security.AuthenticatedUserImpl;
import org.apache.jetspeed.security.InvalidPasswordException;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserCredential;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.impl.BaseAuthenticationProvider;
import org.apache.jetspeed.security.impl.UserCredentialImpl;
import org.apache.jetspeed.security.spi.JetspeedSecuritySynchronizer;
import org.apache.jetspeed.security.spi.UserPasswordCredentialManager;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.HardcodedFilter;
import org.springframework.ldap.pool.factory.PoolingContextSource;
import org.springframework.ldap.support.LdapUtils;

public class LdapAuthenticationProvider
extends BaseAuthenticationProvider {
    private JetspeedSecuritySynchronizer synchronizer;
    private UserPasswordCredentialManager upcm;
    private UserManager manager;
    private PoolingContextSource poolingContextsource;
    private String userEntryPrefix;
    private DistinguishedName userSearchPath;
    private SearchControls searchControls;
    private Filter userFilter;

    public LdapAuthenticationProvider(String providerName, String providerDescription, String loginConfig, UserPasswordCredentialManager upcm, UserManager manager, JetspeedSecuritySynchronizer synchronizer, PoolingContextSource poolingContextSource, String userSearchBase, String userFilter, String userEntryPrefix, String searchScope) {
        super(providerName, providerDescription, loginConfig);
        this.upcm = upcm;
        this.manager = manager;
        this.synchronizer = synchronizer;
        this.poolingContextsource = poolingContextSource;
        this.userEntryPrefix = userEntryPrefix;
        this.userSearchPath = new DistinguishedName(userSearchBase);
        if (!StringUtils.isEmpty((String)userFilter)) {
            this.userFilter = new HardcodedFilter(userFilter);
        }
        this.searchControls = new SearchControls();
        this.searchControls.setReturningAttributes(new String[0]);
        this.searchControls.setReturningObjFlag(true);
        this.searchControls.setSearchScope(Integer.parseInt(searchScope));
    }

    public AuthenticatedUser authenticate(String userName, String password) throws SecurityException {
        AuthenticatedUserImpl authUser = null;
        if (StringUtils.isEmpty((String)userName)) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("user", (Object)userName));
        }
        if (password == null) {
            throw new SecurityException(SecurityException.PASSWORD_REQUIRED);
        }
        this.authenticateUser(userName, password);
        if (this.synchronizer != null) {
            this.synchronizer.synchronizeUserPrincipal(userName);
        }
        User user = this.manager.getUser(userName);
        authUser = new AuthenticatedUserImpl(user, (UserCredential)new UserCredentialImpl((UserCredential)this.upcm.getPasswordCredential(user)));
        return authUser;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void authenticateUser(String userName, String password) throws SecurityException {
        DirContext ctx = null;
        try {
            EqualsFilter filter = new EqualsFilter(this.userEntryPrefix, userName);
            if (this.userFilter != null) {
                filter = new AndFilter().and(this.userFilter).and((Filter)filter);
            }
            ctx = this.poolingContextsource.getReadOnlyContext();
            NamingEnumeration<SearchResult> results = ctx.search((Name)this.userSearchPath, filter.encode(), this.searchControls);
            String dn = null;
            if (null != results && results.hasMore()) {
                SearchResult result = results.next();
                dn = result.getNameInNamespace();
            }
            if (dn == null) {
                throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("user", (Object)userName));
            }
            LdapUtils.closeContext((DirContext)ctx);
            ctx = this.poolingContextsource.getContextSource().getContext(dn, password);
        }
        catch (AuthenticationException aex) {
            try {
                if (aex.getMessage() == null) throw new SecurityException((Throwable)aex);
                if (!aex.getMessage().equalsIgnoreCase("[LDAP: error code 49 - Invalid Credentials]")) throw new SecurityException((Throwable)aex);
                throw new InvalidPasswordException();
                catch (NamingException nex) {
                    throw new SecurityException(SecurityException.UNEXPECTED.create((Object)this.getClass().getName(), (Object)"authenticateUser", (Object)nex.getMessage()), (Throwable)nex);
                }
            }
            catch (Throwable throwable) {
                LdapUtils.closeContext(ctx);
                throw throwable;
            }
        }
        LdapUtils.closeContext((DirContext)ctx);
    }
}

