/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.util.List;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.JetspeedPrincipalAssociationType;
import org.apache.jetspeed.security.JetspeedPrincipalManager;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.spi.JetspeedPrincipalAssociationHandler;
import org.apache.jetspeed.security.spi.JetspeedPrincipalAssociationStorageManager;
import org.apache.jetspeed.security.spi.JetspeedPrincipalManagerSPI;
import org.apache.jetspeed.security.spi.impl.SynchronizationStateAccess;

public abstract class BaseJetspeedPrincipalAssociationHandler
implements JetspeedPrincipalAssociationHandler {
    private JetspeedPrincipalAssociationType associationType;
    private JetspeedPrincipalAssociationStorageManager jpasm;
    private JetspeedPrincipalManagerSPI from;
    private JetspeedPrincipalManagerSPI to;

    public BaseJetspeedPrincipalAssociationHandler(JetspeedPrincipalAssociationType associationType, JetspeedPrincipalManagerSPI from, JetspeedPrincipalManagerSPI to, JetspeedPrincipalAssociationStorageManager jpasm) {
        this.associationType = associationType;
        this.from = from;
        this.to = to;
        this.jpasm = jpasm;
        if (!associationType.getFromPrincipalType().getName().equals(from.getPrincipalType().getName()) || !associationType.getToPrincipalType().getName().equals(to.getPrincipalType().getName())) {
            throw new IllegalArgumentException("Provided ManagerFrom or ManagerTo PrincipalType do not correspond with the AssociationType");
        }
        from.addAssociationHandler(this);
        if (from != to) {
            to.addAssociationHandler(this);
        }
    }

    public JetspeedPrincipalAssociationType getAssociationType() {
        return this.associationType;
    }

    public JetspeedPrincipalManager getManagerFrom() {
        return this.from;
    }

    public JetspeedPrincipalManager getManagerTo() {
        return this.to;
    }

    public void add(JetspeedPrincipal from, JetspeedPrincipal to) throws SecurityException {
        if (from.getType().equals(this.associationType.getFromPrincipalType()) && to.getType().equals(this.associationType.getToPrincipalType())) {
            if (!this.isSynchronizing()) {
                if (this.associationType.isSingular() && !this.getManagerFrom().getAssociatedFrom(from.getName(), from.getType(), this.associationType.getAssociationName()).isEmpty()) {
                    if (this.associationType.isMixedTypes()) {
                        throw new SecurityException(SecurityException.PRINCIPAL_ASSOCIATION_SINGULAR_MIXED.createScoped(from.getType().getName(), (Object)this.associationType.getAssociationName(), (Object)from.getName(), (Object)to.getType().getName()));
                    }
                    throw new SecurityException(SecurityException.PRINCIPAL_ASSOCIATION_SINGULAR.createScoped(from.getType().getName(), (Object)this.associationType.getAssociationName(), (Object)from.getName(), (Object)from.getType().getName()));
                }
                if (this.associationType.isDominant() && !this.getManagerTo().getAssociatedTo(to.getName(), to.getType(), this.associationType.getAssociationName()).isEmpty()) {
                    if (this.associationType.isMixedTypes()) {
                        throw new SecurityException(SecurityException.PRINCIPAL_ASSOCIATION_DOMINANT_MIXED.createScoped(to.getType().getName(), (Object)this.associationType.getAssociationName(), (Object)to.getName(), (Object)from.getType().getName()));
                    }
                    throw new SecurityException(SecurityException.PRINCIPAL_ASSOCIATION_DOMINANT.createScoped(to.getType().getName(), (Object)this.associationType.getAssociationName(), (Object)to.getName(), (Object)to.getType().getName()));
                }
            }
            this.jpasm.addAssociation(from, to, this.associationType.getAssociationName());
        }
    }

    public void remove(JetspeedPrincipal from, JetspeedPrincipal to) throws SecurityException {
        if (from.getType().equals(this.associationType.getFromPrincipalType()) && to.getType().equals(this.associationType.getToPrincipalType())) {
            this.jpasm.removeAssociation(from, to, this.associationType.getAssociationName());
        }
    }

    public void beforeRemoveFrom(JetspeedPrincipal from) throws SecurityException {
    }

    public void beforeRemoveTo(JetspeedPrincipal to) throws SecurityException {
        if (this.associationType.isDependent()) {
            List fromList = this.getManagerTo().getAssociatedTo(to.getName(), to.getType(), this.associationType.getAssociationName());
            for (JetspeedPrincipal from : fromList) {
                this.getManagerFrom().removePrincipal(from);
            }
        } else if (this.associationType.isRequired() && !this.isSynchronizing() && !this.getManagerTo().getAssociatedTo(to.getName(), to.getType(), this.associationType.getAssociationName()).isEmpty()) {
            throw new SecurityException(SecurityException.PRINCIPAL_ASSOCIATION_REQUIRED.createScoped(to.getType().getName(), (Object)to.getName(), (Object)this.associationType.getFromPrincipalType().getName(), (Object)this.associationType.getAssociationName()));
        }
    }

    protected boolean isSynchronizing() {
        return SynchronizationStateAccess.isSynchronizing();
    }
}

