/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mapping.ldap.dao;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.mapping.EntityFactory;
import org.apache.jetspeed.security.mapping.EntitySearchResultHandler;
import org.apache.jetspeed.security.mapping.SecurityEntityManager;
import org.apache.jetspeed.security.mapping.impl.SecurityEntityRelationTypeImpl;
import org.apache.jetspeed.security.mapping.ldap.dao.EntityDAO;
import org.apache.jetspeed.security.mapping.ldap.dao.EntityRelationDAO;
import org.apache.jetspeed.security.mapping.model.Entity;
import org.apache.jetspeed.security.mapping.model.SecurityEntityRelationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLDAPEntityManager
implements SecurityEntityManager {
    private boolean readOnly;
    private Map<String, EntityDAO> entityDAOs = new HashMap<String, EntityDAO>();
    private Map<SecurityEntityRelationType, EntityRelationDAO> entityRelationDAOs = new HashMap<SecurityEntityRelationType, EntityRelationDAO>();
    private Map<String, Set<SecurityEntityRelationType>> entityRelationTypes = new HashMap<String, Set<SecurityEntityRelationType>>();

    public DefaultLDAPEntityManager(List<EntityDAO> entityDAOs, List<EntityRelationDAO> entityRelationDAOs) {
        this(entityDAOs, entityRelationDAOs, false);
    }

    public DefaultLDAPEntityManager(List<EntityDAO> entityDAOs, List<EntityRelationDAO> entityRelationDAOs, boolean readOnly) {
        this.readOnly = readOnly;
        for (EntityDAO entityDAO : entityDAOs) {
            this.entityDAOs.put(entityDAO.getEntityType(), entityDAO);
            this.entityRelationTypes.put(entityDAO.getEntityType(), new HashSet());
        }
        if (entityRelationDAOs != null) {
            for (EntityRelationDAO entityRelationDAO : entityRelationDAOs) {
                SecurityEntityRelationType relationType = entityRelationDAO.getRelationType();
                if (this.entityDAOs.get(relationType.getFromEntityType()) == null || this.entityDAOs.get(relationType.getToEntityType()) == null) {
                    throw new IllegalArgumentException("Missing EntityDAO for EntityRelationDAO fromEntityType: " + relationType.getFromEntityType() + " and/or toEntityType: " + relationType.getToEntityType());
                }
                this.entityRelationDAOs.put(new SecurityEntityRelationTypeImpl(relationType.getRelationType(), relationType.getFromEntityType(), relationType.getToEntityType()), entityRelationDAO);
                this.entityRelationTypes.get(relationType.getFromEntityType()).add(relationType);
                this.entityRelationTypes.get(relationType.getToEntityType()).add(relationType);
            }
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public SecurityEntityRelationType getSupportedEntityRelationType(String relationType, String fromEntityType, String toEntityType) {
        SecurityEntityRelationTypeImpl key = new SecurityEntityRelationTypeImpl(relationType, fromEntityType, toEntityType);
        return this.entityRelationDAOs.containsKey(key) ? key : null;
    }

    @Override
    public Set<SecurityEntityRelationType> getSupportedEntityRelationTypes() {
        return this.entityRelationDAOs.keySet();
    }

    @Override
    public Set<String> getSupportedEntityTypes() {
        return this.entityRelationTypes.keySet();
    }

    @Override
    public Set<SecurityEntityRelationType> getSupportedEntityRelationTypes(String entityType) {
        return this.entityRelationTypes.get(entityType);
    }

    private EntityDAO getDAOForEntity(Entity entity) {
        return this.entityDAOs.get(entity.getType());
    }

    private void checkReadOnly(String methodName) throws SecurityException {
        if (this.readOnly) {
            throw new SecurityException(SecurityException.UNEXPECTED.create((Object)"DefaultLDAPEntityManager", (Object)methodName, (Object)"ReadOnly LDAP"));
        }
    }

    @Override
    public void addRelation(String fromEntityId, String toEntityId, SecurityEntityRelationType relationType) throws SecurityException {
        this.checkReadOnly("addRelation");
        EntityRelationDAO dao = this.entityRelationDAOs.get(relationType instanceof SecurityEntityRelationTypeImpl ? relationType : new SecurityEntityRelationTypeImpl(relationType));
        if (dao != null) {
            dao.addRelation(this.entityDAOs.get(relationType.getFromEntityType()), this.entityDAOs.get(relationType.getToEntityType()), fromEntityId, toEntityId);
        }
    }

    @Override
    public void removeRelation(String fromEntityId, String toEntityId, SecurityEntityRelationType relationType) throws SecurityException {
        this.checkReadOnly("removeRelation");
        EntityRelationDAO dao = this.entityRelationDAOs.get(relationType instanceof SecurityEntityRelationTypeImpl ? relationType : new SecurityEntityRelationTypeImpl(relationType));
        if (dao != null) {
            dao.removeRelation(this.entityDAOs.get(relationType.getFromEntityType()), this.entityDAOs.get(relationType.getToEntityType()), fromEntityId, toEntityId);
        }
    }

    @Override
    public void getAllEntities(String entityType, EntitySearchResultHandler handler) throws SecurityException {
        EntityDAO dao = this.entityDAOs.get(entityType);
        if (dao != null) {
            dao.getAllEntities(handler);
        }
    }

    @Override
    public Entity getEntity(String entityType, String entityId) throws SecurityException {
        EntityDAO dao = this.entityDAOs.get(entityType);
        return dao != null ? dao.getEntity(entityId) : null;
    }

    @Override
    public void getRelatedEntitiesTo(Entity toEntity, SecurityEntityRelationType relationType, EntitySearchResultHandler handler) throws SecurityException {
        EntityRelationDAO relationDAO = this.entityRelationDAOs.get(relationType instanceof SecurityEntityRelationTypeImpl ? relationType : new SecurityEntityRelationTypeImpl(relationType));
        if (relationDAO != null) {
            EntityDAO fromDAO = this.entityDAOs.get(relationType.getFromEntityType());
            EntityDAO toDAO = this.entityDAOs.get(relationType.getToEntityType());
            if (fromDAO != null && toDAO != null && toDAO.getEntityType().equals(toEntity.getType())) {
                relationDAO.getRelatedEntitiesTo(fromDAO, toDAO, toEntity, handler);
                return;
            }
        }
    }

    @Override
    public void getRelatedEntitiesFrom(Entity fromEntity, SecurityEntityRelationType relationType, EntitySearchResultHandler handler) throws SecurityException {
        EntityRelationDAO relationDAO = this.entityRelationDAOs.get(relationType instanceof SecurityEntityRelationTypeImpl ? relationType : new SecurityEntityRelationTypeImpl(relationType));
        if (relationDAO != null) {
            EntityDAO fromDAO = this.entityDAOs.get(relationType.getFromEntityType());
            EntityDAO toDAO = this.entityDAOs.get(relationType.getToEntityType());
            if (fromDAO != null && toDAO != null && fromDAO.getEntityType().equals(fromEntity.getType())) {
                relationDAO.getRelatedEntitiesFrom(fromDAO, toDAO, fromEntity, handler);
                return;
            }
        }
    }

    @Override
    public void updateEntity(Entity entity) throws SecurityException {
        this.checkReadOnly("updateEntity");
        EntityDAO dao = this.getDAOForEntity(entity);
        if (dao != null) {
            dao.update(entity);
        }
    }

    @Override
    public void removeEntity(Entity entity) throws SecurityException {
        this.checkReadOnly("removeEntity");
        EntityDAO dao = this.getDAOForEntity(entity);
        if (dao != null) {
            dao.remove(entity);
        }
    }

    @Override
    public void addEntity(Entity entity) throws SecurityException {
        this.checkReadOnly("addEntity");
        EntityDAO dao = this.getDAOForEntity(entity);
        if (dao != null) {
            dao.add(entity);
        }
    }

    @Override
    public void addEntity(Entity entity, Entity parentEntity) throws SecurityException {
        this.checkReadOnly("addEntity");
        EntityDAO parentEntityDao = this.getDAOForEntity(parentEntity);
        EntityDAO dao = this.getDAOForEntity(entity);
        Entity liveParentEntity = null;
        if (parentEntityDao != null && dao != null) {
            liveParentEntity = parentEntityDao.getEntity(parentEntity.getId());
            if (liveParentEntity == null) {
                throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(parentEntity.getType(), (Object)parentEntity.getId()));
            }
            dao.add(entity, liveParentEntity);
        }
    }

    @Override
    public EntityFactory getEntityFactory(String entityType) {
        EntityDAO dao = this.entityDAOs.get(entityType);
        return dao != null ? dao.getEntityFactory() : null;
    }
}

