/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mapping;

import java.util.Set;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.mapping.EntityFactory;
import org.apache.jetspeed.security.mapping.EntitySearchResultHandler;
import org.apache.jetspeed.security.mapping.model.Entity;
import org.apache.jetspeed.security.mapping.model.SecurityEntityRelationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SecurityEntityManager {
    public boolean isReadOnly();

    public Set<String> getSupportedEntityTypes();

    public Set<SecurityEntityRelationType> getSupportedEntityRelationTypes();

    public Set<SecurityEntityRelationType> getSupportedEntityRelationTypes(String var1);

    public SecurityEntityRelationType getSupportedEntityRelationType(String var1, String var2, String var3);

    public Entity getEntity(String var1, String var2) throws SecurityException;

    public void getAllEntities(String var1, EntitySearchResultHandler var2) throws SecurityException;

    public void addEntity(Entity var1) throws SecurityException;

    public void addEntity(Entity var1, Entity var2) throws SecurityException;

    public void removeEntity(Entity var1) throws SecurityException;

    public void updateEntity(Entity var1) throws SecurityException;

    public void addRelation(String var1, String var2, SecurityEntityRelationType var3) throws SecurityException;

    public void removeRelation(String var1, String var2, SecurityEntityRelationType var3) throws SecurityException;

    public void getRelatedEntitiesFrom(Entity var1, SecurityEntityRelationType var2, EntitySearchResultHandler var3) throws SecurityException;

    public void getRelatedEntitiesTo(Entity var1, SecurityEntityRelationType var2, EntitySearchResultHandler var3) throws SecurityException;

    public EntityFactory getEntityFactory(String var1);
}

