/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.components.RefreshableBean;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.spi.JetspeedSecuritySynchronizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnStartupSecuritySynchronizationBean
implements RefreshableBean {
    private static final Logger log = LoggerFactory.getLogger(OnStartupSecuritySynchronizationBean.class);
    private UserManager userManager;
    private JetspeedSecuritySynchronizer synchronizer;
    private boolean synchronizeAllUser;
    private String synchronizeEntityType;

    public OnStartupSecuritySynchronizationBean(JetspeedSecuritySynchronizer synchronizer, UserManager userManager, boolean synchronizeAllUser, String synchronizeEntityType) {
        this.synchronizer = synchronizer;
        this.userManager = userManager;
        this.synchronizeAllUser = synchronizeAllUser;
        this.synchronizeEntityType = synchronizeEntityType;
    }

    public void refresh() {
        block7: {
            if (this.synchronizer != null) {
                try {
                    if (this.userManager.getUser(this.userManager.getAnonymousUser()) == null) {
                        this.synchronizer.synchronizeUserPrincipal(this.userManager.getAnonymousUser());
                    }
                    if (this.synchronizeAllUser) {
                        this.synchronizer.synchronizeAll();
                    } else if (StringUtils.isNotEmpty((String)this.synchronizeEntityType)) {
                        this.synchronizer.synchronizePrincipalsByType(this.synchronizeEntityType);
                    }
                }
                catch (SecurityException secExp) {
                    if (!log.isErrorEnabled()) break block7;
                    log.error("Error occured while executing JetspeedPostContextLoader", (Throwable)secExp);
                }
            }
        }
    }
}

