/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.jetspeed.security.JetspeedPrincipalQueryContext;
import org.apache.jetspeed.security.JetspeedPrincipalResultList;
import org.apache.jetspeed.security.impl.PersistentJetspeedPrincipal;
import org.apache.jetspeed.security.spi.JetspeedPrincipalLookupManager;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.accesslayer.RowReader;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JetspeedPrincipalLookupManagerAbstract
implements JetspeedPrincipalLookupManager {
    static final Logger log = LoggerFactory.getLogger(JetspeedPrincipalLookupManagerAbstract.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JetspeedPrincipalResultList getPrincipals(JetspeedPrincipalQueryContext queryContext) {
        String baseSqlStr = this.generateBaseSql(queryContext);
        String sqlStr = this.getPagingSql(baseSqlStr, queryContext);
        int numberOfRecords = 0;
        ArrayList<PersistentJetspeedPrincipal> results = new ArrayList<PersistentJetspeedPrincipal>();
        PreparedStatement pstmt = null;
        Connection conn = null;
        try {
            conn = PersistenceBrokerFactory.defaultPersistenceBroker().serviceConnectionManager().getConnection();
            pstmt = conn.prepareStatement(sqlStr, 1004, 1007);
            pstmt.setFetchSize((int)(queryContext.getOffset() + queryContext.getLength()));
            ResultSet rs = pstmt.executeQuery();
            boolean hasRecords = rs.next();
            if (hasRecords) {
                int orderPos;
                this.scrollToOffset(conn, rs, queryContext.getOffset());
                int i = 0;
                while ((long)i < queryContext.getLength()) {
                    RowReader rr = PersistenceBrokerFactory.defaultPersistenceBroker().getClassDescriptor(PersistentJetspeedPrincipal.class).getRowReader();
                    HashMap row = new HashMap();
                    rr.readObjectArrayFrom(rs, row);
                    PersistentJetspeedPrincipal p = (PersistentJetspeedPrincipal)rr.readObjectFrom(row);
                    QueryByCriteria query = new QueryByCriteria((Object)p);
                    p = (PersistentJetspeedPrincipal)PersistenceBrokerFactory.defaultPersistenceBroker().getObjectByQuery((Query)query);
                    results.add(p);
                    if (!rs.next()) break;
                    ++i;
                }
                rs.close();
                int fromPos = baseSqlStr.toUpperCase().indexOf(" FROM ");
                if (fromPos >= 0) {
                    baseSqlStr = "select count(SECURITY_PRINCIPAL.PRINCIPAL_ID)" + baseSqlStr.substring(fromPos);
                }
                if ((orderPos = baseSqlStr.toUpperCase().indexOf(" ORDER BY ")) >= 0) {
                    baseSqlStr = baseSqlStr.substring(0, orderPos);
                }
                pstmt = conn.prepareStatement(baseSqlStr);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    numberOfRecords += rs.getInt(1);
                }
                rs.close();
            }
        }
        catch (SQLException e) {
            log.error("Error reading principal.", (Throwable)e);
        }
        catch (PBFactoryException e) {
            log.error("Error reading principal.", (Throwable)e);
        }
        catch (LookupException e) {
            log.error("Error reading principal.", (Throwable)e);
        }
        finally {
            try {
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                log.error("Error closing connection.", (Throwable)e);
            }
        }
        return new JetspeedPrincipalResultList(results, (long)numberOfRecords);
    }

    protected String generateBaseSql(JetspeedPrincipalQueryContext queryContext) {
        String attributeConstraint = null;
        String fromPart = "SECURITY_PRINCIPAL";
        if (queryContext.getSecurityAttributes() != null) {
            int cnt = 1;
            for (Map.Entry attribute : queryContext.getSecurityAttributes().entrySet()) {
                attributeConstraint = attributeConstraint == null ? "a" + cnt + ".PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID AND a" + cnt + ".ATTR_NAME = '" + (String)attribute.getKey() + "' AND a" + cnt + ".ATTR_VALUE LIKE '" + (String)attribute.getValue() + "'" : attributeConstraint + " AND a" + cnt + ".PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID AND a" + cnt + ".ATTR_NAME = '" + (String)attribute.getKey() + "' AND a" + cnt + ".ATTR_VALUE LIKE '" + (String)attribute.getValue() + "'";
                fromPart = fromPart + ", SECURITY_ATTRIBUTE a" + cnt;
                ++cnt;
            }
        }
        String constraint = null;
        if (queryContext.getNameFilter() != null && queryContext.getNameFilter().length() > 0) {
            constraint = "SECURITY_PRINCIPAL.PRINCIPAL_NAME LIKE '" + queryContext.getNameFilter().replace('*', '%') + "'";
        }
        String roleConstraints = null;
        if (queryContext.getAssociatedRoles() != null && queryContext.getAssociatedRoles().size() > 0 && ((String)queryContext.getAssociatedRoles().get(0)).length() > 0) {
            int cnt = 1;
            for (String roleName : queryContext.getAssociatedRoles()) {
                if (roleConstraints == null) {
                    roleConstraints = "r" + cnt + ".ASSOC_NAME='" + "isMemberOf" + "' AND r" + cnt + ".TO_PRINCIPAL_ID=rp" + cnt + ".PRINCIPAL_ID AND rp" + cnt + ".PRINCIPAL_NAME LIKE '" + roleName + "' AND rp" + cnt + ".PRINCIPAL_TYPE='role' AND r" + cnt + ".FROM_PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID";
                    continue;
                }
                roleConstraints = " AND r" + cnt + ".ASSOC_NAME='" + "isMemberOf" + "' AND r" + cnt + ".TO_PRINCIPAL_ID=rp" + cnt + ".PRINCIPAL_ID AND rp" + cnt + ".PRINCIPAL_NAME LIKE '" + roleName + "' AND rp" + cnt + ".PRINCIPAL_TYPE='role' AND r" + cnt + ".FROM_PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID";
            }
            fromPart = fromPart + ", SECURITY_PRINCIPAL_ASSOC r" + cnt + ", SECURITY_PRINCIPAL rp" + cnt;
            ++cnt;
        }
        String groupConstraints = null;
        if (queryContext.getAssociatedGroups() != null && queryContext.getAssociatedGroups().size() > 0 && ((String)queryContext.getAssociatedGroups().get(0)).length() > 0) {
            int cnt = 1;
            for (String groupName : queryContext.getAssociatedGroups()) {
                if (groupConstraints == null) {
                    groupConstraints = "r" + cnt + ".ASSOC_NAME='" + "isMemberOf" + "' AND r" + cnt + ".TO_PRINCIPAL_ID=rp" + cnt + ".PRINCIPAL_ID AND rp" + cnt + ".PRINCIPAL_NAME LIKE '" + groupName + "' AND rp" + cnt + ".PRINCIPAL_TYPE='group' AND r" + cnt + ".FROM_PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID";
                    continue;
                }
                groupConstraints = " AND r" + cnt + ".ASSOC_NAME='" + "isMemberOf" + "' AND r" + cnt + ".TO_PRINCIPAL_ID=rp" + cnt + ".PRINCIPAL_ID AND rp" + cnt + ".PRINCIPAL_NAME LIKE '" + groupName + "' AND rp" + cnt + ".PRINCIPAL_TYPE='group' AND r" + cnt + ".FROM_PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID";
            }
            fromPart = fromPart + ", SECURITY_PRINCIPAL_ASSOC r" + cnt + ", SECURITY_PRINCIPAL rp" + cnt;
            ++cnt;
        }
        String userConstraints = null;
        if (queryContext.getAssociatedUsers() != null && queryContext.getAssociatedUsers().size() > 0) {
            int cnt = 1;
            for (String userName : queryContext.getAssociatedGroups()) {
                if (userConstraints == null) {
                    userConstraints = "r" + cnt + ".ASSOC_NAME='" + "isMemberOf" + "' AND r" + cnt + ".FROM_PRINCIPAL_ID=rp" + cnt + ".PRINCIPAL_ID AND rp" + cnt + ".PRINCIPAL_NAME LIKE '" + userName + "' AND rp" + cnt + ".PRINCIPAL_TYPE='user' AND r" + cnt + ".TO_PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID";
                    continue;
                }
                userConstraints = " AND r" + cnt + ".ASSOC_NAME='" + "isMemberOf" + "' AND r" + cnt + ".FROM_PRINCIPAL_ID=rp" + cnt + ".PRINCIPAL_ID AND rp" + cnt + ".PRINCIPAL_NAME LIKE '" + userName + "' AND rp" + cnt + ".PRINCIPAL_TYPE='group' AND r" + cnt + ".TO_PRINCIPAL_ID=SECURITY_PRINCIPAL.PRINCIPAL_ID";
            }
            fromPart = fromPart + ", SECURITY_PRINCIPAL_ASSOC r" + cnt + ", SECURITY_PRINCIPAL rp" + cnt;
            ++cnt;
        }
        if (attributeConstraint != null) {
            constraint = constraint != null ? constraint + " AND " + attributeConstraint : attributeConstraint;
        }
        if (roleConstraints != null) {
            constraint = constraint != null ? constraint + " AND " + roleConstraints : roleConstraints;
        }
        if (groupConstraints != null) {
            constraint = constraint != null ? constraint + " AND " + groupConstraints : groupConstraints;
        }
        if (userConstraints != null) {
            constraint = constraint != null ? constraint + " AND " + userConstraints : userConstraints;
        }
        String baseSqlStr = "SELECT SECURITY_PRINCIPAL.* from " + fromPart + " WHERE SECURITY_PRINCIPAL.PRINCIPAL_TYPE='" + queryContext.getJetspeedPrincipalType() + "' AND SECURITY_PRINCIPAL.DOMAIN_ID=" + queryContext.getSecurityDomain();
        if (constraint != null) {
            baseSqlStr = baseSqlStr + " AND " + constraint;
        }
        baseSqlStr = queryContext.getOrder() != null && queryContext.getOrder().equalsIgnoreCase("desc") ? baseSqlStr + " ORDER BY SECURITY_PRINCIPAL.PRINCIPAL_NAME DESC" : baseSqlStr + " ORDER BY SECURITY_PRINCIPAL.PRINCIPAL_NAME";
        return baseSqlStr;
    }

    protected abstract String getPagingSql(String var1, JetspeedPrincipalQueryContext var2);

    protected abstract void scrollToOffset(Connection var1, ResultSet var2, long var3) throws SQLException;
}

