/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.JetspeedPrincipalAssociationReference;
import org.apache.jetspeed.security.JetspeedPrincipalManager;
import org.apache.jetspeed.security.JetspeedPrincipalManagerProvider;
import org.apache.jetspeed.security.SecurityAttribute;
import org.apache.jetspeed.security.SecurityAttributes;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.mapping.SecurityEntityManager;
import org.apache.jetspeed.security.mapping.impl.BaseEntitySearchResultHandler;
import org.apache.jetspeed.security.mapping.model.Attribute;
import org.apache.jetspeed.security.mapping.model.AttributeDef;
import org.apache.jetspeed.security.mapping.model.Entity;
import org.apache.jetspeed.security.mapping.model.SecurityEntityRelationType;
import org.apache.jetspeed.security.spi.JetspeedSecuritySynchronizer;
import org.apache.jetspeed.security.spi.impl.SynchronizationStateAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJetspeedSecuritySynchronizer
implements JetspeedSecuritySynchronizer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJetspeedSecuritySynchronizer.class);
    JetspeedPrincipalManagerProvider principalManagerProvider;
    SecurityEntityManager securityEntityManager;

    public DefaultJetspeedSecuritySynchronizer(JetspeedPrincipalManagerProvider principalManagerProvider, SecurityEntityManager securityEntityManager) {
        this.principalManagerProvider = principalManagerProvider;
        this.securityEntityManager = securityEntityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void synchronizeAll() throws SecurityException {
        this.setSynchronizing(true);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Synchronizing all entities");
            }
            final HashMap processing = new HashMap();
            final HashMap processed = new HashMap();
            for (String type : this.securityEntityManager.getSupportedEntityTypes()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Synchronizing all " + type + " entities");
                }
                BaseEntitySearchResultHandler handler = new BaseEntitySearchResultHandler(){

                    protected boolean processSearchResult(Entity entity, int pageSize, int pageIndex, int index) {
                        try {
                            DefaultJetspeedSecuritySynchronizer.this.synchronizeEntity(entity, processing, processed);
                        }
                        catch (SecurityException e) {
                            this.setFeedback((Object)e);
                            return false;
                        }
                        return true;
                    }
                };
                this.securityEntityManager.getAllEntities(type, handler);
                if (handler.getFeedback() == null) continue;
                throw (SecurityException)((Object)handler.getFeedback());
            }
        }
        finally {
            this.setSynchronizing(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void synchronizePrincipalsByType(String type) throws SecurityException {
        this.setSynchronizing(true);
        try {
            final HashMap processing = new HashMap();
            final HashMap processed = new HashMap();
            BaseEntitySearchResultHandler handler = new BaseEntitySearchResultHandler(){

                protected boolean processSearchResult(Entity entity, int pageSize, int pageIndex, int index) {
                    try {
                        DefaultJetspeedSecuritySynchronizer.this.synchronizeEntity(entity, processing, processed);
                    }
                    catch (SecurityException e) {
                        this.setFeedback((Object)e);
                        return false;
                    }
                    return true;
                }
            };
            this.securityEntityManager.getAllEntities(type, handler);
            if (handler.getFeedback() != null) {
                throw (SecurityException)((Object)handler.getFeedback());
            }
        }
        finally {
            this.setSynchronizing(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void synchronizeUserPrincipal(String name) throws SecurityException {
        block5: {
            this.setSynchronizing(true);
            try {
                Entity userEntity;
                if (logger.isDebugEnabled()) {
                    logger.debug("Synchronizing UserPrincipal(" + name + ")");
                }
                if ((userEntity = this.securityEntityManager.getEntity("user", name)) != null) {
                    this.synchronizeEntity(userEntity, new HashMap<String, Set<String>>(), new HashMap<String, Map<String, String>>());
                    break block5;
                }
                throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("user", (Object)name));
            }
            finally {
                this.setSynchronizing(false);
            }
        }
    }

    protected JetspeedPrincipal synchronizeEntity(Entity entity, Map<String, Set<String>> processing, Map<String, Map<String, String>> processed) throws SecurityException {
        JetspeedPrincipal principal = null;
        if (processing != null && processing.get(entity.getType()) != null && processing.get(entity.getType()).contains(entity.getId())) {
            throw new IllegalStateException("Circular relationship detected for Entity type " + entity.getType() + " id: " + entity.getId());
        }
        if (processed.get(entity.getType()) != null && processed.get(entity.getType()).containsKey(entity.getId())) {
            String principalName = processed.get(entity.getType()).get(entity.getId());
            return principalName != null ? this.getJetspeedPrincipal(entity.getType(), principalName) : null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Synchronizing entity " + entity.getType() + " id: " + entity.getId());
        }
        Set<JetspeedPrincipalAssociationReference> toAssociations = this.synchronizeEntityFromRelations(entity, processing, processed);
        principal = this.synchronizeEntity(entity, toAssociations);
        Map<String, String> entitiesMap = processed.get(entity.getType());
        if (entitiesMap == null) {
            entitiesMap = new HashMap<String, String>();
            processed.put(entity.getType(), entitiesMap);
        }
        entitiesMap.put(entity.getId(), entity.getId());
        return principal;
    }

    protected Set<JetspeedPrincipalAssociationReference> synchronizeEntityFromRelations(final Entity entity, final Map<String, Set<String>> processing, final Map<String, Map<String, String>> processed) throws SecurityException {
        final HashSet<JetspeedPrincipalAssociationReference> toAssociations = new HashSet<JetspeedPrincipalAssociationReference>();
        for (final SecurityEntityRelationType relationTypeForThisEntity : this.securityEntityManager.getSupportedEntityRelationTypes(entity.getType())) {
            if (!relationTypeForThisEntity.getFromEntityType().equals(entity.getType())) continue;
            final String toEntityType = relationTypeForThisEntity.getToEntityType();
            final Map<Object, Object> processedToType = processed.containsKey(toEntityType) ? processed.get(toEntityType) : new HashMap();
            final Set<String> processingToType = processing.containsKey(toEntityType) ? processing.get(toEntityType) : null;
            BaseEntitySearchResultHandler handler = new BaseEntitySearchResultHandler(){

                protected boolean processSearchResult(Entity relatedEntity, int pageSize, int pageIndex, int index) {
                    try {
                        JetspeedPrincipal principal = null;
                        if (processingToType != null && processingToType.contains(relatedEntity.getId())) {
                            throw new IllegalStateException("Circular relationship detected for Entity type " + toEntityType + " id: " + relatedEntity.getId());
                        }
                        if (processedToType != null && processedToType.containsKey(relatedEntity.getId())) {
                            String principalName = (String)((Map)processed.get(relatedEntity.getType())).get(relatedEntity.getId());
                            principal = principalName != null ? DefaultJetspeedSecuritySynchronizer.this.getJetspeedPrincipal(relatedEntity.getType(), principalName) : null;
                        } else {
                            HashSet<String> processingFromType = (HashSet<String>)processing.get(entity.getType());
                            if (processingFromType == null) {
                                processingFromType = new HashSet<String>();
                                processing.put(entity.getType(), processingFromType);
                            }
                            processingFromType.add(entity.getId());
                            principal = DefaultJetspeedSecuritySynchronizer.this.synchronizeEntity(relatedEntity, processing, processed);
                        }
                        if (principal != null) {
                            toAssociations.add(new JetspeedPrincipalAssociationReference(JetspeedPrincipalAssociationReference.Type.TO, principal, relationTypeForThisEntity.getRelationType()));
                        }
                    }
                    catch (SecurityException e) {
                        this.setFeedback((Object)e);
                        return false;
                    }
                    return true;
                }
            };
            this.securityEntityManager.getRelatedEntitiesFrom(entity, relationTypeForThisEntity, handler);
            if (handler.getFeedback() != null) {
                throw (SecurityException)((Object)handler.getFeedback());
            }
            Set<String> processingFromType = processing.get(entity.getType());
            if (processingFromType == null) continue;
            processingFromType.remove(entity.getId());
        }
        return toAssociations;
    }

    protected JetspeedPrincipal synchronizeEntity(Entity entity, Set<JetspeedPrincipalAssociationReference> toAssociations) throws SecurityException {
        JetspeedPrincipal principal = this.getJetspeedPrincipal(entity.getType(), entity.getId());
        JetspeedPrincipalManager principalManager = this.principalManagerProvider.getManager(this.principalManagerProvider.getPrincipalType(entity.getType()));
        boolean syncAll = false;
        if (principal == null) {
            principal = principalManager.newPrincipal(entity.getId(), true);
            principalManager.addPrincipal(principal, toAssociations);
            syncAll = true;
        } else {
            if (!principal.isMapped()) {
                logger.debug("Found " + principal.getType().getName() + " principal: " + principal.getName() + " is not mapped therefore not synchronized!");
                return null;
            }
            for (SecurityEntityRelationType relationType : this.securityEntityManager.getSupportedEntityRelationTypes(entity.getType())) {
                if (!relationType.getFromEntityType().equals(entity.getType())) continue;
                List associatedFrom = principalManager.getAssociatedFrom(principal.getName(), principal.getType(), relationType.getRelationType());
                for (JetspeedPrincipal p : associatedFrom) {
                    if (!toAssociations.isEmpty() && toAssociations.remove(new JetspeedPrincipalAssociationReference(JetspeedPrincipalAssociationReference.Type.TO, p, relationType.getRelationType()))) continue;
                    principalManager.removeAssociation(principal, p, relationType.getRelationType());
                }
            }
            for (JetspeedPrincipalAssociationReference ref : toAssociations) {
                principalManager.addAssociation(principal, ref.ref, ref.associationName);
            }
        }
        boolean updated = false;
        SecurityAttributes principalAttrs = principal.getSecurityAttributes();
        for (AttributeDef attrDef : entity.getAttributeDefinitions()) {
            SecurityAttribute principalAttr;
            if (!attrDef.isMapped() || attrDef.isMultiValue()) continue;
            Attribute attr = entity.getAttribute(attrDef.getName());
            if (attr == null) {
                if (syncAll || (principalAttr = principalAttrs.getAttribute(attrDef.getMappedName())) == null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Removing attribute " + principalAttr.getName() + " for principal " + principal.getName() + ".");
                }
                principalAttrs.removeAttribute(principalAttr.getName());
                updated = true;
                continue;
            }
            if (syncAll) {
                principalAttr = principalAttrs.getAttribute(attrDef.getMappedName(), true);
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding attribute " + principalAttr.getName() + " for principal " + principal.getName() + ". Value: " + attr.getValue());
                }
                principalAttr.setStringValue(attr.getValue());
                updated = true;
                continue;
            }
            principalAttr = principalAttrs.getAttribute(attrDef.getMappedName(), true);
            if (StringUtils.equals((String)principalAttr.getStringValue(), (String)attr.getValue())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Updating attribute " + principalAttr.getName() + " for principal " + principal.getName() + ". Old value: " + principalAttr.getStringValue() + " new value: " + attr.getValue());
            }
            principalAttr.setStringValue(attr.getValue());
            updated = true;
        }
        if (updated) {
            if (logger.isDebugEnabled()) {
                logger.debug("Storing attribute changes for principal " + principal.getName());
            }
            principalManager.updatePrincipal(principal);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Synchronized entity " + entity.getType() + " id: " + entity.getId() + " mapped attributes");
        }
        return principal;
    }

    protected JetspeedPrincipal getJetspeedPrincipal(String principalType, String principalName) throws SecurityException {
        JetspeedPrincipalManager principalManager = this.principalManagerProvider.getManager(this.principalManagerProvider.getPrincipalType(principalType));
        if (principalManager != null) {
            return principalManager.getPrincipal(principalName);
        }
        throw new SecurityException(SecurityException.UNKNOWN_PRINCIPAL_TYPE.create((Object)principalType));
    }

    private void setSynchronizing(boolean sync) {
        SynchronizationStateAccess.setSynchronizing(sync ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setPrincipalManagerProvider(JetspeedPrincipalManagerProvider principalManagerProvider) {
        this.principalManagerProvider = principalManagerProvider;
    }
}

