/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mapping.model.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.jetspeed.security.mapping.model.Attribute;
import org.apache.jetspeed.security.mapping.model.AttributeDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeImpl
implements Attribute {
    private Collection<String> values = new ArrayList<String>();
    private String value;
    private AttributeDef definition;

    public AttributeImpl(AttributeDef definition) {
        this.definition = definition;
    }

    @Override
    public String getValue() {
        return this.getDefinition().isMultiValue() ? null : this.value;
    }

    @Override
    public void setValue(String value) {
        this.values = null;
        this.value = value;
    }

    @Override
    public String getName() {
        return this.definition.getName();
    }

    @Override
    public String getMappedName() {
        return this.definition.getMappedName();
    }

    @Override
    public Collection<String> getValues() {
        if (this.getDefinition().isMultiValue()) {
            return this.values;
        }
        if (this.value == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.value);
    }

    @Override
    public void setValues(Collection<String> values) {
        if (this.getDefinition().isMultiValue()) {
            this.values = values;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.definition == null ? 0 : this.definition.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.values == null ? 0 : ((Object)this.values).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeImpl other = (AttributeImpl)obj;
        if (this.definition == null ? other.definition != null : !this.definition.equals(other.definition)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.values == null ? other.values != null : !((Object)this.values).equals(other.values));
    }

    @Override
    public AttributeDef getDefinition() {
        return this.definition;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append("=");
        if (this.getDefinition().isMultiValue()) {
            Collection<String> values = this.getValues();
            if (values != null) {
                Iterator<String> valIter = values.iterator();
                while (valIter.hasNext()) {
                    sb.append(valIter.next());
                    if (!valIter.hasNext()) continue;
                    sb.append(",");
                }
            }
        } else {
            sb.append(this.getValue());
        }
        return sb.toString();
    }
}

