/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mapping.impl;

import org.apache.jetspeed.security.mapping.SearchResultCallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSearchResultHandler<T, R>
implements SearchResultCallbackHandler {
    private final int maxCount;
    private int searchPageSize = -1;
    private int count;
    private int size;
    private boolean aborted;
    private Object feedback;

    public BaseSearchResultHandler() {
        this(0);
    }

    public BaseSearchResultHandler(int maxCount) {
        int n = this.maxCount = maxCount < 1 ? 0 : maxCount;
        if (maxCount == 1) {
            this.searchPageSize = 0;
        }
    }

    public void setSearchPageSize(int searchPageSize) {
        this.searchPageSize = searchPageSize < 0 ? 0 : (this.maxCount > 1 && searchPageSize > this.maxCount ? this.maxCount + 1 : searchPageSize);
    }

    @Override
    public int getSearchPageSize() {
        return this.searchPageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean handleSearchResult(Object result, int pageSize, int pageIndex, int index) {
        ++this.count;
        if (!this.aborted) {
            boolean noExceptions = false;
            try {
                T mappedResult = this.mapResult(result, pageSize, pageIndex, index);
                if (mappedResult != null) {
                    boolean bl = this.aborted = !this.processSearchResult(mappedResult, pageSize, pageIndex, index);
                    if (!this.aborted) {
                        this.aborted = !this.postHandleSearchResult(mappedResult, pageSize, pageIndex, index);
                    }
                }
                noExceptions = true;
            }
            finally {
                if (!noExceptions) {
                    this.aborted = true;
                }
            }
            if (!this.aborted) {
                ++this.size;
                if (this.maxCount > 0 && this.count > this.maxCount) {
                    this.aborted = true;
                }
            }
        }
        return !this.aborted;
    }

    @Override
    public void setFeedback(Object feedback) {
        this.feedback = feedback;
    }

    @Override
    public Object getFeedback() {
        return this.feedback;
    }

    public final boolean isAborted() {
        return this.aborted;
    }

    @Override
    public final int getMaxCount() {
        return this.maxCount;
    }

    public final int getCount() {
        return this.count;
    }

    public final int getSize() {
        return this.size;
    }

    protected T mapResult(R result, int pageSize, int pageIndex, int index) {
        return (T)result;
    }

    protected boolean processSearchResult(T result, int pageSize, int pageIndex, int index) {
        return true;
    }

    protected boolean postHandleSearchResult(T result, int pageSize, int pageIndex, int index) {
        return true;
    }
}

