/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.security.SecurityAttributeType;
import org.apache.jetspeed.security.SecurityAttributeTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityAttributeTypesImpl
implements SecurityAttributeTypes {
    private Map<String, SecurityAttributeType> securityAttributeTypes = new LinkedHashMap<String, SecurityAttributeType>();
    private Map<String, Map<String, SecurityAttributeType>> categoriesMap = new HashMap<String, Map<String, SecurityAttributeType>>();
    private boolean readOnly;
    private boolean extendable;

    public SecurityAttributeTypesImpl(boolean extendable, boolean readOnly, List<SecurityAttributeType> securityAttributeTypes) {
        this.extendable = extendable;
        this.readOnly = readOnly;
        for (SecurityAttributeType securityAttributeType : securityAttributeTypes) {
            if (this.securityAttributeTypes.put(securityAttributeType.getName(), securityAttributeType) != null) {
                throw new IllegalArgumentException("Duplicate SecurityAttributeType name: " + securityAttributeType.getName());
            }
            Map<String, SecurityAttributeType> categoryMap = this.categoriesMap.get(securityAttributeType.getCategory());
            if (categoryMap == null) {
                categoryMap = new LinkedHashMap<String, SecurityAttributeType>();
                this.categoriesMap.put(securityAttributeType.getCategory(), categoryMap);
            }
            categoryMap.put(securityAttributeType.getName(), securityAttributeType);
        }
        for (Map.Entry entry : this.categoriesMap.entrySet()) {
            entry.setValue(Collections.unmodifiableMap((Map)entry.getValue()));
        }
        this.securityAttributeTypes = Collections.unmodifiableMap(this.securityAttributeTypes);
    }

    public SecurityAttributeTypesImpl(List<SecurityAttributeType> securityAttributeTypes) {
        this(true, false, securityAttributeTypes);
    }

    public Map<String, SecurityAttributeType> getAttributeTypeMap() {
        return this.securityAttributeTypes;
    }

    public Map<String, SecurityAttributeType> getAttributeTypeMap(String category) {
        Map<String, SecurityAttributeType> map = this.categoriesMap.get(category);
        if (map == null) {
            return Collections.EMPTY_MAP;
        }
        return map;
    }

    public boolean isExtendable() {
        return this.extendable;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }
}

