/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl.ldap;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.springframework.ldap.core.support.LdapContextSource;

public class LdapContextProxy
implements InvocationHandler {
    private Properties env;
    private LdapContext ctx;
    private LdapContextSource springContext;
    private String initialContextFactory;
    private String userFilter;
    private String memberShipSearchScope;
    private String userSearchBase;
    private String entryPrefix;

    public LdapContextProxy(LdapContextSource context, String factory, String userFilter, String memberShipSearchScope, String userSearchBase, String entryPrefix) {
        this.springContext = context;
        this.env = new Properties();
        this.env.put("java.naming.factory.initial", factory);
        this.env.put("java.naming.provider.url", this.springContext.getUrls()[0]);
        this.env.put("java.naming.security.authentication", "simple");
        this.env.put("java.naming.security.credentials", this.springContext.getAuthenticationSource().getCredentials());
        this.env.put("java.naming.security.principal", this.springContext.getAuthenticationSource().getPrincipal());
        this.initialContextFactory = factory;
        this.userFilter = userFilter;
        this.memberShipSearchScope = memberShipSearchScope;
        this.userSearchBase = userSearchBase;
        this.entryPrefix = entryPrefix;
    }

    public LdapContext getCtx() throws NamingException {
        if (this.ctx == null) {
            this.ctx = new InitialLdapContext(this.env, null);
        }
        return this.ctx;
    }

    private void closeCtx() {
        if (this.ctx != null) {
            try {
                this.ctx.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ctx = null;
        }
    }

    public synchronized Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        boolean close;
        Object result = null;
        boolean bl = close = "close".equals(m.getName()) && args.length == 0;
        if (!close || this.ctx != null) {
            LdapContext ctx = this.getCtx();
            try {
                result = m.invoke((Object)ctx, args);
                if (close) {
                    this.closeCtx();
                }
            }
            catch (Throwable t) {
                this.closeCtx();
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                if (t instanceof ServiceUnavailableException || t instanceof CommunicationException) {
                    try {
                        ctx = this.getCtx();
                        result = m.invoke((Object)ctx, args);
                    }
                    catch (Throwable t2) {
                        this.closeCtx();
                        if (t2 instanceof InvocationTargetException) {
                            t2 = ((InvocationTargetException)t2).getTargetException();
                        }
                        throw t2;
                    }
                }
                throw t;
            }
        }
        return result;
    }

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public String getUserSearchBase() {
        return this.userSearchBase;
    }

    public String getRootContext() {
        return this.springContext.getBaseLdapPathAsString();
    }

    public LdapContextSource getContextSource() {
        return this.springContext;
    }

    public String getMemberShipSearchScope() {
        return this.memberShipSearchScope;
    }

    public String getEntryPrefix() {
        return this.entryPrefix;
    }
}

