/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.security.Permission;
import org.apache.jetspeed.security.spi.PersistentJetspeedPermission;
import org.apache.jetspeed.security.spi.impl.BaseJetspeedPermission;
import org.apache.jetspeed.security.spi.impl.JetspeedPermissionFactory;

public class PortletPermission
extends BaseJetspeedPermission {
    private static final long serialVersionUID = 3246898917185555596L;

    protected PortletPermission(PersistentJetspeedPermission permission) {
        super(permission);
    }

    protected PortletPermission(String type, String name, int mask) {
        super(type, name, mask);
    }

    protected PortletPermission(String type, String name, String actions) {
        super(type, name, actions);
    }

    public boolean implies(Permission permission) {
        int index;
        if (!(permission instanceof PortletPermission)) {
            return false;
        }
        String name = this.getName();
        if (name != null && ((index = name.indexOf(42)) > -1 ? !permission.getName().startsWith(name.substring(0, index)) : !permission.getName().equals(name))) {
            return false;
        }
        PortletPermission portletPerm = (PortletPermission)permission;
        return (this.mask & portletPerm.mask) == portletPerm.mask;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PortletPermission)) {
            return false;
        }
        PortletPermission p = (PortletPermission)object;
        return p.mask == this.mask && p.getName().equals(this.getName());
    }

    public static class Factory
    extends JetspeedPermissionFactory {
        public Factory() {
            super("portlet");
        }

        public PortletPermission newPermission(String name, String actions) {
            return new PortletPermission(this.getType(), name, actions);
        }

        public PortletPermission newPermission(String name, int mask) {
            return new PortletPermission(this.getType(), name, mask);
        }

        public PortletPermission newPermission(PersistentJetspeedPermission permission) {
            if (permission.getType().equals(this.getType())) {
                return new PortletPermission(permission);
            }
            throw new IllegalArgumentException("Permission is not of type " + this.getType());
        }
    }
}

