/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mapping.ldap.dao;

import org.apache.jetspeed.security.mapping.ldap.filter.SimpleFilter;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.OrFilter;

public class SearchUtil {
    public static Filter andFilters(Filter ... filters) {
        AndFilter andFilter = new AndFilter();
        for (Filter filter : filters) {
            andFilter.and(filter);
        }
        return andFilter;
    }

    public static Filter constructMatchingFieldsFilter(Filter baseFilter, String[] ... fieldNamesAndValues) {
        AndFilter filter = new AndFilter();
        for (String[] nameAndValues : fieldNamesAndValues) {
            if (nameAndValues.length <= 1) continue;
            String name = nameAndValues[0];
            OrFilter fieldFilter = new OrFilter();
            for (int i = 1; i < nameAndValues.length; ++i) {
                fieldFilter.or((Filter)new EqualsFilter(name, nameAndValues[i]));
            }
            filter.and((Filter)fieldFilter);
        }
        return baseFilter != null ? SearchUtil.andFilters(new Filter[]{baseFilter, filter}) : filter;
    }

    public static Filter constructMatchingFieldsFilter(String baseFilter, String[] ... fieldNamesAndValues) {
        return SearchUtil.constructMatchingFieldsFilter(new SimpleFilter(baseFilter), fieldNamesAndValues);
    }
}

