/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mapping.ldap.dao;

import java.util.Set;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.security.mapping.model.AttributeDef;
import org.springframework.ldap.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPEntityDAOConfiguration {
    private String baseDN;
    private String searchDN;
    private Filter baseFilter;
    private String ldapIdAttribute;
    private Set<AttributeDef> attributeDefinitions;
    private String entityType;
    private String[] objectClassesArr;

    public void initialize() throws JetspeedException {
        this.checkNotEmpty("entityType", this.entityType);
        this.checkNotNull("baseDN", this.baseDN);
        this.checkNotEmpty("ldapIdAttribute", this.ldapIdAttribute);
        this.checkNotNull("attributeDefinitions", this.attributeDefinitions);
    }

    private void checkNotNull(String fieldName, Object fieldValue) throws JetspeedException {
        if (fieldValue == null) {
            throw new JetspeedException(this.getClass().getName() + ": property '" + fieldName + "' cannot be null.");
        }
    }

    private void checkNotEmpty(String fieldName, String fieldValue) throws JetspeedException {
        if (fieldValue == null) {
            throw new JetspeedException(this.getClass().getName() + ": property '" + fieldName + "' cannot be null or empty.");
        }
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    public String getSearchDN() {
        return this.searchDN;
    }

    public void setSearchDN(String searchDN) {
        this.searchDN = searchDN;
    }

    public Filter getSearchFilter() {
        return this.baseFilter;
    }

    public void setSearchFilter(Filter baseFilter) {
        this.baseFilter = baseFilter;
    }

    public Set<AttributeDef> getAttributeDefinitions() {
        return this.attributeDefinitions;
    }

    public void setAttributeDefinitions(Set<AttributeDef> attributeDefinitions) {
        this.attributeDefinitions = attributeDefinitions;
    }

    public String getLdapIdAttribute() {
        return this.ldapIdAttribute;
    }

    public void setLdapIdAttribute(String ldapIdAttribute) {
        this.ldapIdAttribute = ldapIdAttribute;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public String[] getObjectClassesArray() {
        return this.objectClassesArr;
    }

    public void setObjectClasses(String objectClasses) {
        if (objectClasses != null) {
            this.objectClassesArr = objectClasses.split(",");
        }
    }
}

