/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mapping.ldap.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.mapping.EntityFactory;
import org.apache.jetspeed.security.mapping.SecurityEntityManager;
import org.apache.jetspeed.security.mapping.SecurityEntityRelationType;
import org.apache.jetspeed.security.mapping.ldap.dao.EntityDAO;
import org.apache.jetspeed.security.mapping.ldap.dao.EntityRelationDAO;
import org.apache.jetspeed.security.mapping.model.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLDAPEntityManager
implements SecurityEntityManager {
    protected Map<String, EntityDAO> entityDAOs;
    protected Map<SecurityEntityRelationType, EntityRelationDAO> entityRelationDAOs = new HashMap<SecurityEntityRelationType, EntityRelationDAO>();

    @Override
    public Collection<SecurityEntityRelationType> getSupportedEntityRelationTypes() {
        return Collections.unmodifiableCollection(this.entityRelationDAOs.keySet());
    }

    @Override
    public Collection<String> getSupportedEntityTypes() {
        return Collections.unmodifiableCollection(this.entityDAOs.keySet());
    }

    @Override
    public Collection<SecurityEntityRelationType> getSupportedEntityRelationTypes(String entityType) {
        ArrayList<SecurityEntityRelationType> supportedRelationTypes = new ArrayList<SecurityEntityRelationType>();
        for (SecurityEntityRelationType type : this.entityRelationDAOs.keySet()) {
            if (!type.getFromEntityType().equals(entityType) && !type.getToEntityType().equals(entityType)) continue;
            supportedRelationTypes.add(type);
        }
        return Collections.unmodifiableCollection(supportedRelationTypes);
    }

    private EntityDAO getDAOForEntity(Entity entity) {
        return entity.getType() != null ? this.entityDAOs.get(entity.getType()) : null;
    }

    @Override
    public void addRelation(Entity sourceEntity, Entity targetEntity, SecurityEntityRelationType relationType) throws SecurityException {
        EntityRelationDAO relationDAO = this.entityRelationDAOs.get(relationType);
        if (relationDAO != null) {
            EntityDAO targetDAO;
            EntityDAO sourceDAO;
            if (relationType.getFromEntityType().equals(sourceEntity.getType())) {
                sourceDAO = this.entityDAOs.get(sourceEntity.getType());
                targetDAO = this.entityDAOs.get(relationType.getToEntityType());
            } else {
                targetDAO = this.entityDAOs.get(sourceEntity.getType());
                sourceDAO = this.entityDAOs.get(relationType.getToEntityType());
            }
            if (relationDAO != null) {
                relationDAO.addRelation(sourceDAO, targetDAO, sourceEntity, targetEntity);
            }
        }
    }

    @Override
    public void removeRelation(Entity entity, Entity relatedEntity, SecurityEntityRelationType relationType) throws SecurityException {
        EntityRelationDAO relationDAO = this.entityRelationDAOs.get(relationType);
        if (relationDAO != null) {
            EntityDAO targetDAO;
            EntityDAO sourceDAO;
            if (relationType.getFromEntityType().equals(entity.getType())) {
                sourceDAO = this.entityDAOs.get(entity.getType());
                targetDAO = this.entityDAOs.get(relationType.getToEntityType());
            } else {
                targetDAO = this.entityDAOs.get(entity.getType());
                sourceDAO = this.entityDAOs.get(relationType.getToEntityType());
            }
            if (relationDAO != null) {
                relationDAO.removeRelation(sourceDAO, targetDAO, entity, relatedEntity);
            }
        }
    }

    @Override
    public Collection<Entity> getAllEntities(String entityType) {
        EntityDAO dao = this.entityDAOs.get(entityType);
        return dao != null ? dao.getAllEntities() : null;
    }

    @Override
    public Entity getEntity(String entityType, String entityId) {
        EntityDAO dao = this.entityDAOs.get(entityType);
        return dao != null ? dao.getEntity(entityId) : null;
    }

    @Override
    public Collection<Entity> getRelatedEntitiesTo(Entity toEntity, SecurityEntityRelationType relationType) {
        EntityDAO fromDAO = this.entityDAOs.get(relationType.getFromEntityType());
        EntityDAO toDAO = this.entityDAOs.get(relationType.getToEntityType());
        EntityRelationDAO relationDAO = this.entityRelationDAOs.get(relationType);
        if (fromDAO != null && toDAO != null && relationDAO != null) {
            return relationDAO.getRelatedEntitiesTo(fromDAO, toDAO, toEntity);
        }
        return null;
    }

    @Override
    public Collection<Entity> getRelatedEntitiesFrom(Entity fromEntity, SecurityEntityRelationType relationType) {
        EntityDAO fromDAO = this.entityDAOs.get(relationType.getFromEntityType());
        EntityDAO toDAO = this.entityDAOs.get(relationType.getToEntityType());
        EntityRelationDAO relationDAO = this.entityRelationDAOs.get(relationType);
        if (fromDAO != null && toDAO != null && relationDAO != null) {
            return relationDAO.getRelatedEntitiesFrom(fromDAO, toDAO, fromEntity);
        }
        return null;
    }

    @Override
    public void updateEntity(Entity entity) throws SecurityException {
        EntityDAO dao = this.getDAOForEntity(entity);
        if (dao != null) {
            dao.update(entity);
        }
    }

    @Override
    public void removeEntity(Entity entity) throws SecurityException {
        EntityDAO dao = this.getDAOForEntity(entity);
        if (dao != null) {
            dao.remove(entity);
        }
    }

    @Override
    public void addEntity(Entity entity) throws SecurityException {
        EntityDAO dao = this.getDAOForEntity(entity);
        if (dao != null) {
            dao.add(entity);
        }
    }

    @Override
    public void addEntity(Entity entity, Entity parentEntity) throws SecurityException {
        EntityDAO parentEntityDao = this.getDAOForEntity(parentEntity);
        Entity liveParentEntity = null;
        if (parentEntityDao != null) {
            liveParentEntity = parentEntityDao.getEntity(parentEntity.getId());
            if (liveParentEntity == null) {
                throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(parentEntity.getType(), (Object)parentEntity.getId()));
            }
            EntityDAO dao = this.getDAOForEntity(entity);
            if (dao != null) {
                dao.add(entity, liveParentEntity);
            }
        }
    }

    public void setEntityDAOs(Map<String, EntityDAO> entityDAOs) {
        this.entityDAOs = entityDAOs;
    }

    public void setEntityRelationDAOs(Collection<EntityRelationDAO> entityRelationDAOs) {
        this.entityRelationDAOs.clear();
        for (EntityRelationDAO dao : entityRelationDAOs) {
            this.entityRelationDAOs.put(dao.getRelationType(), dao);
        }
    }

    @Override
    public EntityFactory getEntityFactory(String entityType) {
        EntityDAO dao = this.entityDAOs.get(entityType);
        return dao != null ? dao.getEntityFactory() : null;
    }
}

