/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.security.AuthenticatedUser;
import org.apache.jetspeed.security.AuthenticatedUserImpl;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserCredential;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.impl.BaseAuthenticationProvider;
import org.apache.jetspeed.security.impl.UserCredentialImpl;
import org.apache.jetspeed.security.mapping.ldap.util.DnUtils;
import org.apache.jetspeed.security.spi.JetspeedSecuritySynchronizer;
import org.apache.jetspeed.security.spi.UserPasswordCredentialManager;
import org.apache.jetspeed.security.spi.impl.ldap.LdapContextProxy;

public class LdapAuthenticationProvider
extends BaseAuthenticationProvider {
    private JetspeedSecuritySynchronizer synchronizer;
    private UserPasswordCredentialManager upcm;
    private UserManager manager;
    private LdapContextProxy context;

    public LdapAuthenticationProvider(String providerName, String providerDescription, String loginConfig, UserPasswordCredentialManager upcm, UserManager manager) {
        super(providerName, providerDescription, loginConfig);
        this.upcm = upcm;
        this.manager = manager;
    }

    public void setContext(LdapContextProxy context) {
        this.context = context;
    }

    public void setSynchronizer(JetspeedSecuritySynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public AuthenticatedUser authenticate(String userName, String password) throws SecurityException {
        AuthenticatedUserImpl authUser = null;
        boolean authenticated = false;
        try {
            if (userName == null) {
                throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("user", (Object)userName));
            }
            if (password == null) {
                throw new SecurityException(SecurityException.PASSWORD_REQUIRED);
            }
            authenticated = this.authenticateUser(userName, password);
            if (authenticated) {
                User user = this.getUser(userName);
                authUser = new AuthenticatedUserImpl(user, (UserCredential)new UserCredentialImpl((UserCredential)this.upcm.getPasswordCredential(user)));
            }
        }
        catch (SecurityException authEx) {
            if (authEx.getCause().getMessage().equalsIgnoreCase("[LDAP: error code 49 - Invalid Credentials]")) {
                throw new SecurityException(SecurityException.INCORRECT_PASSWORD);
            }
            throw authEx;
        }
        return authUser;
    }

    private User getUser(String userName) throws SecurityException {
        if (this.synchronizer != null) {
            this.synchronizer.synchronizeUserPrincipal(userName, false);
        }
        return this.manager.getUser(userName);
    }

    private boolean authenticateUser(String userName, String password) throws SecurityException {
        try {
            Hashtable env = (Hashtable)this.context.getCtx().getEnvironment().clone();
            String dn = this.lookupByUid(userName);
            if (dn == null) {
                throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("user", (Object)userName));
            }
            if (!StringUtils.isEmpty((String)this.context.getRootContext()) && DnUtils.encodeDn(dn).indexOf(DnUtils.encodeDn(this.context.getRootContext())) < 0) {
                dn = dn + "," + DnUtils.encodeDn(this.context.getRootContext());
            }
            env.put("java.naming.security.principal", dn);
            env.put("java.naming.security.credentials", password);
            new InitialContext(env);
            return true;
        }
        catch (AuthenticationException aex) {
            throw new SecurityException((Throwable)aex);
        }
        catch (NamingException nex) {
            throw new SecurityException(SecurityException.UNEXPECTED.create((Object)this.getClass().getName(), (Object)"authenticateUser", (Object)nex.getMessage()));
        }
    }

    public String lookupByUid(String uid) throws SecurityException {
        try {
            SearchControls cons = this.setSearchControls();
            NamingEnumeration searchResults = this.searchByWildcardedUid(uid, cons);
            return this.getFirstDnForUid(searchResults);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    protected SearchControls setSearchControls() {
        SearchControls controls = new SearchControls();
        controls.setReturningAttributes(new String[0]);
        controls.setSearchScope(2);
        controls.setReturningObjFlag(true);
        return controls;
    }

    protected NamingEnumeration searchByWildcardedUid(String filter, SearchControls cons) throws NamingException {
        String query = "";
        query = StringUtils.isEmpty((String)this.getSearchSuffix()) ? "(" + this.context.getEntryPrefix() + "=" + (StringUtils.isEmpty((String)filter) ? "*" : filter) + ")" : "(&(" + this.context.getEntryPrefix() + "=" + (StringUtils.isEmpty((String)filter) ? "*" : filter) + ")" + this.getSearchSuffix() + ")";
        cons.setSearchScope(Integer.parseInt(this.context.getMemberShipSearchScope()));
        NamingEnumeration<SearchResult> results = this.context.getCtx().search(this.getSearchDomain(), query, cons);
        return results;
    }

    private String getFirstDnForUid(NamingEnumeration searchResults) throws NamingException {
        String userDn = null;
        while (null != searchResults && searchResults.hasMore()) {
            SearchResult searchResult = (SearchResult)searchResults.next();
            userDn = searchResult.getName();
            String searchDomain = this.getSearchDomain();
            if (searchDomain.length() <= 0) continue;
            userDn = userDn + "," + StringUtils.replace((String)searchDomain, (String)("," + this.context.getRootContext()), (String)"");
        }
        return userDn;
    }

    private String getSearchSuffix() {
        return this.context.getUserFilter();
    }

    private String getSearchDomain() {
        StringBuffer searchDomain = new StringBuffer();
        if (!StringUtils.isEmpty((String)this.context.getUserSearchBase())) {
            searchDomain.append(this.context.getUserSearchBase());
        }
        if (searchDomain.length() == 0 && !StringUtils.isEmpty((String)this.context.getRootContext())) {
            searchDomain.append(this.context.getRootContext());
        }
        return searchDomain.toString();
    }
}

