/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class OverwriteProperties {
    protected File baseProperties;
    protected File properties;
    protected File includeRoot;
    public boolean verbose = false;
    protected ArrayList baseArray = new ArrayList(1024);
    protected ArrayList removeArray = new ArrayList(128);
    protected HashMap baseMap = new HashMap();
    protected String lineSeparator = System.getProperty("line.separator", "\r\n");

    public void setBaseProperties(File baseProperties) {
        this.baseProperties = baseProperties;
    }

    public void setProperties(File properties) {
        this.properties = properties;
    }

    public void setIncludeRoot(File includeRoot) {
        this.includeRoot = includeRoot;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public File getBaseProperties() {
        return this.baseProperties;
    }

    public File getProperties() {
        return this.properties;
    }

    public File getIncludeRoot() {
        return this.includeRoot;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public static void main(String[] args) throws Exception {
        OverwriteProperties overwriteProperties = new OverwriteProperties();
        try {
            if (args.length < 3) {
                System.out.println("Usage: java OverwriteProperties c:/temp/File1.props c:/temp/File2.props c:/include-root/");
                System.out.println("Usage: File1 will be modified, new parameters from File 2 will be added,");
                System.out.println("Usage: and same parameters will be updated. The include-root is where include files are found.");
                throw new Exception("Incorrect number of arguments supplied");
            }
            overwriteProperties.setBaseProperties(new File(args[0]));
            overwriteProperties.setProperties(new File(args[1]));
            overwriteProperties.setIncludeRoot(new File(args[2]));
            overwriteProperties.execute();
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex.getMessage());
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        catch (SecurityException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public void execute() throws FileNotFoundException, IOException, SecurityException {
        if (this.verbose) {
            System.out.println("Merging into file " + this.getBaseProperties() + " file " + this.getProperties());
        }
        if (!this.getBaseProperties().exists()) {
            throw new FileNotFoundException("Could not find file:" + this.getBaseProperties());
        }
        if (!this.getProperties().exists()) {
            throw new FileNotFoundException("Could not find file:" + this.getProperties());
        }
        if (!this.getIncludeRoot().exists() || !this.getIncludeRoot().isDirectory()) {
            throw new FileNotFoundException("Could not find directory:" + this.getIncludeRoot());
        }
        BufferedReader reader = new BufferedReader(new FileReader(this.baseProperties));
        int index = 0;
        String key = null;
        String line = null;
        while ((line = reader.readLine()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(line, "=");
            this.baseArray.add(index, line);
            if (this.verbose) {
                System.out.println("While reading baseArray[" + index + "] = " + line);
            }
            if (!(tokenizer.countTokens() < 1 || line.startsWith("#") || line.startsWith("include") || line.startsWith("module.packages") || (key = tokenizer.nextToken().trim()) == null || key.length() <= 0)) {
                this.baseMap.put(key, new Integer(index));
                if (this.verbose) {
                    System.out.println("baseMap[" + key + "," + index + "]");
                }
            }
            ++index;
        }
        reader.close();
        if (this.verbose) {
            System.out.println("\nOverwrite with Delta\n");
        }
        this.readProperties(this.properties, index);
        boolean[] flags = this.removeProperties();
        this.baseArray.trimToSize();
        this.writeToFile(flags);
    }

    public void writeToFile(boolean[] flags) throws FileNotFoundException, IOException {
        FileOutputStream writer = new FileOutputStream(this.baseProperties);
        writer.flush();
        for (int i = 0; i < this.baseArray.size(); ++i) {
            if (flags[i]) {
                if (!this.verbose) continue;
                System.out.println("Skipping property[" + i + "] = " + this.baseArray.get(i));
                continue;
            }
            if (this.verbose) {
                System.out.println("Writing property[" + i + "] = " + this.baseArray.get(i));
            }
            writer.write(((String)this.baseArray.get(i)).getBytes());
            writer.write(this.lineSeparator.getBytes());
            writer.flush();
        }
        writer.close();
    }

    public boolean[] removeProperties() {
        boolean[] flags = new boolean[this.baseArray.size()];
        for (int i = 0; i < this.baseArray.size(); ++i) {
            flags[i] = false;
        }
        for (int ix = 0; ix < this.removeArray.size(); ++ix) {
            String prefix = (String)this.removeArray.get(ix);
            for (int iy = 0; iy < this.baseArray.size(); ++iy) {
                String line = (String)this.baseArray.get(iy);
                if (!line.startsWith(prefix)) continue;
                flags[iy] = true;
                if (!this.verbose) continue;
                System.out.println("flagging removal of property: " + line);
            }
        }
        return flags;
    }

    public void readProperties(File propFile, int index) throws FileNotFoundException, IOException {
        BufferedReader reader = new BufferedReader(new FileReader(propFile));
        String key = null;
        String line = null;
        while ((line = reader.readLine()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(line, "=");
            int count = tokenizer.countTokens();
            if (count == 2 && line.startsWith("include")) {
                key = tokenizer.nextToken().trim();
                File includeFile = new File(this.includeRoot + tokenizer.nextToken().trim());
                if (this.verbose) {
                    System.out.println("include File = " + includeFile);
                }
                this.readProperties(includeFile, index);
                continue;
            }
            if (count >= 1 && line.startsWith("module.packages")) {
                this.baseArray.add(index, line);
                if (this.verbose) {
                    System.out.println("Adding module.package to baseArray[" + index + "] = " + line);
                }
                ++index;
                key = line.trim();
                if (!this.baseMap.containsKey(key)) continue;
                int ix = (Integer)this.baseMap.get(key);
                this.baseArray.set(ix, line);
                if (!this.verbose) continue;
                System.out.println("Resetting baseArray[" + ix + "] = " + line);
                continue;
            }
            if (count >= 1 && line.startsWith("-")) {
                String prefix = line.trim().substring(1);
                this.removeArray.add(prefix);
                if (!this.verbose) continue;
                System.out.println("Flagging for removal = " + line);
                continue;
            }
            if (count < 1 || line.startsWith("#") || (key = tokenizer.nextToken().trim()) == null || key.length() <= 0) continue;
            if (this.baseMap.containsKey(key)) {
                int ix = (Integer)this.baseMap.get(key);
                this.baseArray.set(ix, line);
                if (!this.verbose) continue;
                System.out.println("Resetting baseArray[" + ix + "] = " + line);
                continue;
            }
            this.baseArray.add(index, line);
            if (this.verbose) {
                System.out.println("Adding new entry to baseArray[" + index + "] = " + line);
            }
            this.baseMap.put(key, new Integer(index));
            if (this.verbose) {
                System.out.println("baseMap[" + key + "," + index + "]");
            }
            ++index;
        }
        reader.close();
    }
}

