/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.capabilities.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jetspeed.capabilities.Capability;
import org.apache.jetspeed.capabilities.CapabilityMap;
import org.apache.jetspeed.capabilities.Client;
import org.apache.jetspeed.capabilities.MediaType;
import org.apache.jetspeed.capabilities.MimeType;
import org.apache.jetspeed.capabilities.impl.JetspeedCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CapabilityMapImpl
implements CapabilityMap {
    private static Logger log = LoggerFactory.getLogger(JetspeedCapabilities.class);
    private String userAgent;
    private Map<String, MimeType> mimeTypeMap = new HashMap<String, MimeType>();
    private Map<String, Capability> capabilityMap = new HashMap<String, Capability>();
    private Map<String, MediaType> mediaTypeMap = new HashMap<String, MediaType>();
    private Client client;
    private MediaType preferredMediaType;

    CapabilityMapImpl() {
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Client getClient() {
        return this.client;
    }

    public void addCapability(Capability capability) {
        if (capability != null) {
            this.capabilityMap.put(capability.getName(), capability);
        }
    }

    public void addMimetype(MimeType mimetype) {
        if (mimetype != null) {
            this.mimeTypeMap.put(mimetype.getName(), mimetype);
        }
    }

    public void addMediaType(MediaType mediatype) {
        if (mediatype != null) {
            this.mediaTypeMap.put(mediatype.getName(), mediatype);
        }
    }

    public MimeType getPreferredType() {
        int prefMimeTypeId = this.client.getPreferredMimeTypeId();
        MimeType mt2 = null;
        for (MimeType mt2 : this.mimeTypeMap.values()) {
            if (mt2.getMimetypeId() != prefMimeTypeId) continue;
            return mt2;
        }
        log.error("Could not find preferred Mime Type for " + prefMimeTypeId);
        return null;
    }

    public void setPreferredMediaType(MediaType type) {
        this.preferredMediaType = type;
    }

    public MediaType getPreferredMediaType() {
        return this.preferredMediaType;
    }

    public Iterator<MediaType> listMediaTypes() {
        return this.mediaTypeMap.values().iterator();
    }

    public String getAgent() {
        return this.userAgent;
    }

    public void setAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean hasCapability(int capability) {
        Iterator<Capability> capabilities = this.capabilityMap.values().iterator();
        while (capabilities.hasNext()) {
            if (capabilities.next().getCapabilityId() != capability) continue;
            return true;
        }
        return false;
    }

    public boolean hasCapability(String capability) {
        Iterator<Capability> capabilities = this.capabilityMap.values().iterator();
        while (capabilities.hasNext()) {
            if (!capabilities.next().getName().equals(capability)) continue;
            return true;
        }
        return false;
    }

    public Iterator<MimeType> getMimeTypes() {
        return this.mimeTypeMap.values().iterator();
    }

    public boolean supportsMimeType(MimeType mimeType) {
        Iterator<MimeType> mimetypes = this.mimeTypeMap.values().iterator();
        while (mimetypes.hasNext()) {
            if (!mimetypes.next().getName().equals(mimeType.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean supportsMediaType(String media) {
        Iterator<MediaType> mediatypes = this.mediaTypeMap.values().iterator();
        while (mediatypes.hasNext()) {
            if (!mediatypes.next().getName().equals(media)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "";
    }
}

