/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;

public class JetspeedActions {
    public static final PortletMode ABOUT_MODE = new PortletMode("about");
    public static final PortletMode CONFIG_MODE = new PortletMode("config");
    public static final PortletMode EDIT_DEFAULTS_MODE = new PortletMode("edit_defaults");
    public static final PortletMode PRINT_MODE = new PortletMode("print");
    public static final WindowState SOLO_STATE = new WindowState("solo");
    public static final int MASK_MINIMIZE = 1;
    public static final int MASK_MAXIMIZE = 2;
    public static final int MASK_NORMAL = 4;
    public static final int MASK_VIEW = 8;
    public static final int MASK_EDIT = 16;
    public static final int MASK_HELP = 32;
    public static final String VIEW = PortletMode.VIEW.toString();
    public static final String EDIT = PortletMode.EDIT.toString();
    public static final String HELP = PortletMode.HELP.toString();
    public static final String ABOUT = ABOUT_MODE.toString();
    public static final String CONFIG = CONFIG_MODE.toString();
    public static final String EDIT_DEFAULTS = EDIT_DEFAULTS_MODE.toString();
    public static final String PRINT = PRINT_MODE.toString();
    public static final String NORMAL = WindowState.NORMAL.toString();
    public static final String MINIMIZE = WindowState.MINIMIZED.toString();
    public static final String MAXIMIZE = WindowState.MAXIMIZED.toString();
    public static final String SOLO = SOLO_STATE.toString();
    private static final List standardPortletModes;
    private static final List standardWindowStates;
    private static JetspeedActions instance;
    private final List extendedPortletModes;
    private final List extendedWindowStates;
    private final Map actionsMap;
    private final Object[] actions;

    public static List getStandardPortletModes() {
        return standardPortletModes;
    }

    public static List getStandardWindowStates() {
        return standardWindowStates;
    }

    public JetspeedActions(String[] supportedPortletModes, String[] supportedWindowStates) {
        int i;
        int index = 0;
        ArrayList<Object> actionsList = new ArrayList<Object>();
        this.actionsMap = new HashMap();
        this.actionsMap.put(WindowState.MINIMIZED.toString(), new Integer(index++));
        actionsList.add(WindowState.MINIMIZED);
        this.actionsMap.put(WindowState.MAXIMIZED.toString(), new Integer(index++));
        actionsList.add(WindowState.MAXIMIZED);
        this.actionsMap.put(WindowState.NORMAL.toString(), new Integer(index++));
        actionsList.add(WindowState.NORMAL);
        this.actionsMap.put(PortletMode.VIEW.toString(), new Integer(index++));
        actionsList.add(PortletMode.VIEW);
        this.actionsMap.put(PortletMode.EDIT.toString(), new Integer(index++));
        actionsList.add(PortletMode.EDIT);
        this.actionsMap.put(PortletMode.HELP.toString(), new Integer(index++));
        actionsList.add(PortletMode.HELP);
        ArrayList<Object> list = new ArrayList<Object>();
        for (i = 0; index < 32 && i < supportedWindowStates.length; ++i) {
            WindowState state = new WindowState(supportedWindowStates[i]);
            if (!this.actionsMap.containsKey(state.toString())) {
                this.actionsMap.put(state.toString(), new Integer(index++));
                actionsList.add(state);
                list.add(state);
                continue;
            }
            if (standardWindowStates.contains(state)) continue;
            throw new IllegalArgumentException("WindowState " + state + " already defined as extended PortletMode or WindowState");
        }
        this.extendedWindowStates = Collections.unmodifiableList(list);
        list = new ArrayList();
        for (i = 0; index < 32 && i < supportedPortletModes.length; ++i) {
            PortletMode mode = new PortletMode(supportedPortletModes[i]);
            if (!this.actionsMap.containsKey(mode.toString())) {
                this.actionsMap.put(mode.toString(), new Integer(index++));
                actionsList.add(mode);
                list.add(mode);
                continue;
            }
            if (standardPortletModes.contains(mode)) continue;
            throw new IllegalArgumentException("PortletMode " + mode + " already defined as extended PortletMode or WindowState");
        }
        this.extendedPortletModes = Collections.unmodifiableList(list);
        this.actions = actionsList.toArray();
        instance = this;
    }

    public static List getExtendedPortletModes() {
        return JetspeedActions.instance.extendedPortletModes;
    }

    public static List getExtendedWindowStates() {
        return JetspeedActions.instance.extendedWindowStates;
    }

    public static int getContainerActionMask(String action) {
        Integer index = (Integer)JetspeedActions.instance.actionsMap.get(action);
        if (index == null) {
            throw new IllegalArgumentException("Unknown action: " + action);
        }
        return 1 << index;
    }

    public static String getContainerAction(int index) {
        JetspeedActions ja = instance;
        return index > -1 && index < ja.actions.length ? ja.actions[index].toString() : null;
    }

    public static String getContainerActions(int mask) {
        JetspeedActions ja = instance;
        StringBuffer buffer = new StringBuffer();
        boolean append = false;
        int i = 0;
        int j = 1 << i;
        while (i < ja.actions.length) {
            if ((mask & j) == j) {
                if (append) {
                    buffer.append(", ");
                } else {
                    append = true;
                }
                buffer.append(ja.actions[i].toString());
            }
            j = 1 << ++i;
        }
        return buffer.toString();
    }

    public static int getContainerActionsMask(String actions) {
        int mask = 0;
        if (actions != null) {
            JetspeedActions ja = instance;
            StringTokenizer tokenizer = new StringTokenizer(actions, ",\t ");
            while (tokenizer.hasMoreTokens()) {
                String action = tokenizer.nextToken();
                Integer index = (Integer)ja.actionsMap.get(action);
                if (index == null) {
                    throw new IllegalArgumentException("Unknown action: " + action);
                }
                mask |= 1 << index;
            }
        }
        return mask;
    }

    static {
        ArrayList<Object> list = new ArrayList<Object>(3);
        list.add(PortletMode.VIEW);
        list.add(PortletMode.EDIT);
        list.add(PortletMode.HELP);
        standardPortletModes = Collections.unmodifiableList(list);
        list = new ArrayList(3);
        list.add(WindowState.NORMAL);
        list.add(WindowState.MINIMIZED);
        list.add(WindowState.MAXIMIZED);
        standardWindowStates = Collections.unmodifiableList(list);
        instance = new JetspeedActions(new String[0], new String[0]);
    }
}

