/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.util;

import com.google.step2.util.TimeSource;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExpiringLruCache<K, V> {
    private final LruLinkedHashMap<K, V> map;
    private TimeSource timeSource = new TimeSource();

    public ExpiringLruCache(int capacity) {
        this.map = new LruLinkedHashMap(capacity);
    }

    public void setTimeSource(TimeSource timeSource) {
        this.timeSource = timeSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value, long maxSeconds) {
        LruLinkedHashMap<K, V> lruLinkedHashMap = this.map;
        synchronized (lruLinkedHashMap) {
            long maxAge = this.timeSource.currentTimeMillis() + maxSeconds * 1000L;
            this.map.put(key, new EntryWithAge<V>(value, maxAge));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        LruLinkedHashMap<K, V> lruLinkedHashMap = this.map;
        synchronized (lruLinkedHashMap) {
            EntryWithAge entry = (EntryWithAge)this.map.get(key);
            if (entry != null && this.timeSource.currentTimeMillis() < entry.expireMillis) {
                return (V)entry.value;
            }
            return null;
        }
    }

    private static class LruLinkedHashMap<K, V>
    extends LinkedHashMap<K, EntryWithAge<V>> {
        private final int capacity;

        public LruLinkedHashMap(int capacity) {
            super(capacity, 0.75f, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, EntryWithAge<V>> eldest) {
            return this.size() > this.capacity;
        }
    }

    private static class EntryWithAge<V> {
        private final V value;
        private final long expireMillis;

        public EntryWithAge(V value, long expireMillis) {
            this.value = value;
            this.expireMillis = expireMillis;
        }
    }
}

