/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.discovery;

import com.google.step2.discovery.HostMeta;
import com.google.step2.discovery.HostMetaException;
import com.google.step2.discovery.HostMetaFetcher;
import com.google.step2.discovery.IdpIdentifier;
import com.google.step2.discovery.SecureDiscoveryInformation;
import com.google.step2.discovery.XrdDiscoveryResolver;
import com.google.step2.discovery.XrdLocationSelector;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openid4java.discovery.Discovery;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.discovery.UrlIdentifier;
import org.openid4java.discovery.html.HtmlResolver;
import org.openid4java.discovery.xri.XriResolver;
import org.openid4java.discovery.yadis.YadisResolver;

public class Discovery2
extends Discovery {
    private static final Logger logger = Logger.getLogger(Discovery2.class.getName());
    private final HostMetaFetcher hostMetaFetcher;
    private final XrdDiscoveryResolver xrdResolver;
    private final XrdLocationSelector xrdLocationSelector;
    private final FallbackDiscovery<IdpIdentifier> siteFallbackDiscoverer = new FallbackDiscovery<IdpIdentifier>(){

        @Override
        public List<SecureDiscoveryInformation> newStyleDiscovery(IdpIdentifier idp) throws DiscoveryException {
            return Discovery2.this.discoverOpEndpointsForSite(idp);
        }

        @Override
        public Identifier getLegacyIdentifier(IdpIdentifier idp) throws DiscoveryException {
            try {
                String openIdAsString = idp.getIdentifier().trim();
                URI openIdAsUri = URI.create(openIdAsString);
                if (openIdAsUri.getScheme() == null) {
                    openIdAsString = "http://" + openIdAsString;
                }
                return new UrlIdentifier(openIdAsString);
            }
            catch (IllegalArgumentException e) {
                throw new DiscoveryException((Throwable)e);
            }
        }
    };
    private final FallbackDiscovery<UrlIdentifier> userFallbackDiscoverer = new FallbackDiscovery<UrlIdentifier>(){

        @Override
        public List<SecureDiscoveryInformation> newStyleDiscovery(UrlIdentifier url) throws DiscoveryException {
            return Discovery2.this.discoverOpEndpointsForUser(url);
        }

        @Override
        public Identifier getLegacyIdentifier(UrlIdentifier url) {
            return url;
        }
    };

    public Discovery2(HostMetaFetcher hostMetaFetcher, XrdDiscoveryResolver xrdResolver, HtmlResolver htmlResolver, YadisResolver yadisResolver, XriResolver xriResolver) {
        this.setHtmlResolver(htmlResolver);
        this.setYadisResolver(yadisResolver);
        this.setXriResolver(xriResolver);
        this.hostMetaFetcher = hostMetaFetcher;
        this.xrdResolver = xrdResolver;
        this.xrdLocationSelector = new XrdLocationSelector();
    }

    public List<SecureDiscoveryInformation> discoverOpEndpointsForSite(IdpIdentifier site) throws DiscoveryException {
        HostMeta hostMeta;
        String host = site.getIdentifier();
        try {
            hostMeta = this.hostMetaFetcher.getHostMeta(host);
        }
        catch (HostMetaException e) {
            throw new DiscoveryException("could not get host-meta for " + host, (Throwable)e);
        }
        URI xrdUri = this.xrdLocationSelector.findSiteXrdUriForOp(hostMeta, this.xrdResolver.getDiscoveryDocumentType());
        if (xrdUri == null) {
            return Collections.emptyList();
        }
        return this.xrdResolver.findOpEndpointsForSite(site, xrdUri);
    }

    public List<SecureDiscoveryInformation> discoverOpEndpointsForUser(UrlIdentifier claimedId) throws DiscoveryException {
        List<SecureDiscoveryInformation> result;
        try {
            result = this.tryHostMetaBasedDiscoveryForUser(claimedId);
        }
        catch (DiscoveryException e) {
            result = null;
        }
        if (result != null) {
            return result;
        }
        try {
            result = this.tryLinkHeaderBasedDiscoveryForUser(claimedId);
        }
        catch (DiscoveryException e) {
            result = null;
        }
        if (result != null) {
            return result;
        }
        return this.tryLinkElementBasedDiscoveryForUser(claimedId);
    }

    List<SecureDiscoveryInformation> tryHostMetaBasedDiscoveryForUser(UrlIdentifier claimedId) throws DiscoveryException {
        HostMeta hostMeta;
        String host = claimedId.getUrl().getHost();
        try {
            hostMeta = this.hostMetaFetcher.getHostMeta(host);
        }
        catch (HostMetaException e) {
            throw new DiscoveryException("could not get host-meta for " + host, (Throwable)e);
        }
        URI xrdUri = this.xrdLocationSelector.findUserXrdUriForOp(hostMeta, this.xrdResolver.getDiscoveryDocumentType(), claimedId);
        if (xrdUri != null) {
            return this.xrdResolver.findOpEndpointsForUser(claimedId, xrdUri);
        }
        xrdUri = this.xrdLocationSelector.findSiteXrdUriForOp(hostMeta, this.xrdResolver.getDiscoveryDocumentType());
        if (xrdUri != null) {
            return this.xrdResolver.findOpEndpointsForUserThroughSiteXrd(claimedId, xrdUri);
        }
        return Collections.emptyList();
    }

    private List<SecureDiscoveryInformation> tryLinkElementBasedDiscoveryForUser(UrlIdentifier claimedId) throws DiscoveryException {
        throw new DiscoveryException("link-element-based discovery is not implemented yet");
    }

    private List<SecureDiscoveryInformation> tryLinkHeaderBasedDiscoveryForUser(UrlIdentifier claimedId) throws DiscoveryException {
        throw new DiscoveryException("link-header-based discovery is not implemented yet");
    }

    public List<SecureDiscoveryInformation> discover(Identifier identifier) throws DiscoveryException {
        if (identifier instanceof IdpIdentifier) {
            IdpIdentifier site = (IdpIdentifier)identifier;
            return this.siteFallbackDiscoverer.get(site);
        }
        if (identifier instanceof UrlIdentifier) {
            UrlIdentifier url = (UrlIdentifier)identifier;
            return this.userFallbackDiscoverer.get(url);
        }
        List result = super.discover(identifier);
        return Discovery2.convertToNewDiscoveryInfo(result);
    }

    static List<SecureDiscoveryInformation> convertToNewDiscoveryInfo(List<DiscoveryInformation> infos) throws DiscoveryException {
        if (infos == null) {
            return null;
        }
        ArrayList<SecureDiscoveryInformation> result = new ArrayList<SecureDiscoveryInformation>(infos.size());
        for (DiscoveryInformation info : infos) {
            result.add(new SecureDiscoveryInformation(info));
        }
        return result;
    }

    abstract class FallbackDiscovery<T extends Identifier> {
        FallbackDiscovery() {
        }

        public abstract List<SecureDiscoveryInformation> newStyleDiscovery(T var1) throws DiscoveryException;

        public abstract Identifier getLegacyIdentifier(T var1) throws DiscoveryException;

        public List<SecureDiscoveryInformation> get(T id) throws DiscoveryException {
            List<SecureDiscoveryInformation> result;
            try {
                result = this.newStyleDiscovery(id);
                if (result != null && result.size() == 0) {
                    logger.log(Level.WARNING, "could not perform new-style discovery on " + id.getIdentifier() + ". discovery returned null");
                    result = null;
                }
            }
            catch (DiscoveryException e) {
                logger.log(Level.WARNING, "could not perform new-style discovery on " + id.getIdentifier(), e);
                result = null;
            }
            if (result != null) {
                return result;
            }
            return Discovery2.convertToNewDiscoveryInfo(this.oldStyleDiscovery(this.getLegacyIdentifier(id)));
        }

        List<DiscoveryInformation> oldStyleDiscovery(Identifier id) throws DiscoveryException {
            return Discovery2.super.discover(id);
        }
    }
}

