/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.util;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.ArrayUtils;

public class EncodingUtil {
    public static Charset UTF8 = Charset.forName("UTF-8");

    public static String getUtf8String(byte[] data) {
        return UTF8.decode(ByteBuffer.wrap(data)).toString();
    }

    public static byte[] getUtf8Bytes(String s) {
        if (s == null) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        ByteBuffer bb = UTF8.encode(s);
        return ArrayUtils.subarray((byte[])bb.array(), (int)0, (int)bb.limit());
    }

    public static String encodeBase64(byte[] bytes) {
        return EncodingUtil.getUtf8String(Base64.encodeBase64((byte[])bytes, (boolean)false));
    }

    public static byte[] decodeBase64(String b64) {
        return Base64.decodeBase64((byte[])EncodingUtil.getUtf8Bytes(b64));
    }

    public static byte[] decodeBase64(byte[] b64) {
        return Base64.decodeBase64((byte[])b64);
    }
}

