/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClasspathScanner {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$util$ClasspathScanner == null ? (class$org$apache$pluto$util$ClasspathScanner = ClasspathScanner.class$("org.apache.pluto.util.ClasspathScanner")) : class$org$apache$pluto$util$ClasspathScanner));
    static /* synthetic */ Class class$org$apache$pluto$util$ClasspathScanner;

    public static List scan(String path) throws IOException {
        List list = ClasspathScanner.scan(path, (class$org$apache$pluto$util$ClasspathScanner == null ? (class$org$apache$pluto$util$ClasspathScanner = ClasspathScanner.class$("org.apache.pluto.util.ClasspathScanner")) : class$org$apache$pluto$util$ClasspathScanner).getClassLoader());
        list.addAll(ClasspathScanner.scan(path, Thread.currentThread().getContextClassLoader()));
        list.add((class$org$apache$pluto$util$ClasspathScanner == null ? (class$org$apache$pluto$util$ClasspathScanner = ClasspathScanner.class$("org.apache.pluto.util.ClasspathScanner")) : class$org$apache$pluto$util$ClasspathScanner).getResource(path));
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Found " + list.size() + " resources for path '" + path + "'."));
        }
        return list;
    }

    public static List scan(String path, ClassLoader loader) throws IOException {
        ArrayList<URL> list = new ArrayList<URL>();
        if (loader == null) {
            return list;
        }
        Enumeration<URL> enumeration = loader.getResources(path);
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list;
    }

    public static List findConfiguredImplementations(Class implemented) throws IOException {
        ArrayList classes = new ArrayList();
        List resources = ClasspathScanner.scan("/META-INF/pluto.properties");
        Iterator i = resources.iterator();
        Properties p = new Properties();
        while (i.hasNext()) {
            URL url = (URL)i.next();
            p.load(url.openStream());
            String impl = p.getProperty(implemented.getName());
            if (impl != null) {
                StringTokenizer st = new StringTokenizer(impl, ",", false);
                while (st.hasMoreTokens()) {
                    String token = st.nextToken().trim();
                    if (token.length() <= 0) continue;
                    try {
                        classes.add(Class.forName(token));
                    }
                    catch (ClassNotFoundException cnfe) {
                        LOG.warn((Object)("Unable to find configured implementation " + impl + " of interface " + implemented.getName()));
                    }
                }
            }
            ((Hashtable)p).clear();
        }
        return classes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

