/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.internal.impl;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.core.ContainerInvocation;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.apache.pluto.descriptors.portlet.PortletInfoDD;
import org.apache.pluto.internal.impl.CombinedPortletResourceBundle;
import org.apache.pluto.internal.impl.InlinePortletResourceBundle;
import org.apache.pluto.spi.optional.PortletInfoService;
import org.apache.pluto.util.StringManager;

class ResourceBundleFactory {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$internal$impl$ResourceBundleFactory == null ? (class$org$apache$pluto$internal$impl$ResourceBundleFactory = ResourceBundleFactory.class$("org.apache.pluto.internal.impl.ResourceBundleFactory")) : class$org$apache$pluto$internal$impl$ResourceBundleFactory));
    private static final StringManager EXCEPTIONS = StringManager.getManager((class$org$apache$pluto$internal$impl$ResourceBundleFactory == null ? (class$org$apache$pluto$internal$impl$ResourceBundleFactory = ResourceBundleFactory.class$("org.apache.pluto.internal.impl.ResourceBundleFactory")) : class$org$apache$pluto$internal$impl$ResourceBundleFactory).getPackage().getName());
    private InlinePortletResourceBundle defaultBundle;
    private final Map bundles = new HashMap();
    private final String bundleName;
    static /* synthetic */ Class class$org$apache$pluto$internal$impl$ResourceBundleFactory;

    public ResourceBundleFactory(PortletDD dd) {
        this.bundleName = dd.getResourceBundle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resource Bundle Created: " + this.bundleName));
        }
        PortletInfoDD info = dd.getPortletInfo();
        PortletInfoService infoService = this.getPortletInfoService();
        PortletWindow window = this.getWindow();
        if (info != null) {
            String title = infoService == null ? info.getTitle() : infoService.getTitle(window);
            String shortTitle = infoService == null ? info.getShortTitle() : infoService.getShortTitle(window);
            String keywords = infoService == null ? info.getKeywords() : infoService.getKeywords(window);
            this.defaultBundle = new InlinePortletResourceBundle(title, shortTitle, keywords);
        } else {
            this.defaultBundle = new InlinePortletResourceBundle(new Object[][]{{"a", "b"}});
        }
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resource Bundle: " + this.bundleName + " : " + locale + " requested. "));
        }
        if (this.bundles.containsKey(locale)) {
            return (ResourceBundle)this.bundles.get(locale);
        }
        try {
            ResourceBundle bundle = null;
            if (this.bundleName != null) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                bundle = ResourceBundle.getBundle(this.bundleName, locale, loader);
                this.bundles.put(locale, new CombinedPortletResourceBundle(this.defaultBundle, bundle));
            } else {
                this.bundles.put(locale, this.defaultBundle);
            }
        }
        catch (MissingResourceException mre) {
            if (this.bundleName != null && LOG.isWarnEnabled()) {
                LOG.info((Object)EXCEPTIONS.getString("warning.resourcebundle.notfound", this.bundleName, mre.getMessage()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using default bundle for locale (" + locale + ")."));
            }
            this.bundles.put(locale, this.defaultBundle);
        }
        return (ResourceBundle)this.bundles.get(locale);
    }

    private PortletInfoService getPortletInfoService() {
        ContainerInvocation invocation = ContainerInvocation.getInvocation();
        if (invocation != null) {
            return invocation.getPortletContainer().getOptionalContainerServices().getPortletInfoService();
        }
        return null;
    }

    private PortletWindow getWindow() {
        ContainerInvocation invocation = ContainerInvocation.getInvocation();
        if (invocation != null) {
            return invocation.getPortletWindow();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

