/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.validation;

import java.util.Locale;
import org.apache.pivot.wtk.validation.ComparableValidator;

public class ComparableRangeValidator<T extends Comparable<T>>
extends ComparableValidator<T> {
    private T minValue;
    private T maxValue;

    public ComparableRangeValidator() {
        this(Locale.getDefault());
    }

    public ComparableRangeValidator(Locale locale) {
        super(locale);
        this.minValue = null;
        this.maxValue = null;
    }

    public ComparableRangeValidator(T minValue, T maxValue) {
        this(Locale.getDefault(), minValue, maxValue);
    }

    public ComparableRangeValidator(Locale locale, T minValue, T maxValue) {
        super(locale);
        this.setMinimum(minValue);
        this.setMaximum(maxValue);
        if (maxValue.compareTo(minValue) < 0) {
            throw new IllegalArgumentException("maxValue must be higher or equals than minValue");
        }
    }

    public T getMinimum() {
        return this.minValue;
    }

    public void setMinimum(T minValue) {
        if (minValue == null) {
            throw new IllegalArgumentException("minValue must be not null");
        }
        this.minValue = minValue;
    }

    public T getMaximum() {
        return this.maxValue;
    }

    public void setMaximum(T maxValue) {
        if (maxValue == null) {
            throw new IllegalArgumentException("maxValue must be not null");
        }
        this.maxValue = maxValue;
    }

    @Override
    public boolean isValid(String text) {
        Comparable<?> value;
        boolean valid = false;
        if (super.isValid(text) && (value = this.textToComparable(text)) != null) {
            valid = value.compareTo(this.minValue) >= 0 && value.compareTo(this.maxValue) <= 0;
        }
        return valid;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.minValue + "," + this.maxValue + ")";
    }
}

